/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.ElementWalker;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import java.util.ArrayList;
import java.util.Stack;

public class QueryCompilerVisitor
implements ElementVisitor {
    protected Plan plan = null;
    private Stack retStack = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;

    public QueryCompilerVisitor(Plan plan) {
        this.plan = plan;
    }

    public PlanElement compile(Element element) {
        ElementWalker.walk(element, this);
        if (!$assertionsDisabled && this.retStack.size() != 1) {
            throw new AssertionError();
        }
        PlanElement planElement = (PlanElement)this.retStack.pop();
        return planElement;
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        PlanElement planElement = PlanTriplePattern.make(this.plan, elementTriplePattern);
        this.push(planElement);
    }

    public void visit(ElementFilter elementFilter) {
        PlanElement planElement = PlanFilter.make(this.plan, elementFilter);
        this.push(planElement);
    }

    public void visit(ElementUnion elementUnion) {
        PlanElement planElement;
        int n;
        ArrayList<PlanElement> arrayList = new ArrayList<PlanElement>();
        int n2 = elementUnion.getElements().size();
        int n3 = this.retStack.size();
        for (n = 0; n < n2; ++n) {
            planElement = this.pop();
            arrayList.add(0, planElement);
        }
        n = this.retStack.size();
        if (!$assertionsDisabled && n3 - n != elementUnion.getElements().size()) {
            throw new AssertionError();
        }
        planElement = PlanUnion.make(this.plan, arrayList);
        this.push(planElement);
    }

    public void visit(ElementGroup elementGroup) {
        ArrayList<PlanElement> arrayList = new ArrayList<PlanElement>();
        int n = elementGroup.getElements().size();
        for (int i = 0; i < n; ++i) {
            PlanElement planElement = this.pop();
            arrayList.add(0, planElement);
        }
        PlanElement planElement = PlanGroup.make(this.plan, arrayList);
        this.push(planElement);
    }

    public void visit(ElementBlock elementBlock) {
        PlanElement planElement = null;
        if (elementBlock.getPatternElement() != null) {
            planElement = this.pop();
        }
        PlanElement planElement2 = PlanBlock.make(this.plan, elementBlock, planElement);
        this.push(planElement2);
    }

    public void visit(ElementOptional elementOptional) {
        PlanElement planElement = this.pop();
        PlanElement planElement2 = PlanOptional.make(this.plan, elementOptional, planElement);
        this.push(planElement2);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        PlanElement planElement = this.pop();
        PlanElement planElement2 = PlanNamedGraph.make(this.plan, elementNamedGraph, planElement);
        this.push(planElement2);
    }

    public void visit(ElementUnsaid elementUnsaid) {
        PlanElement planElement = this.pop();
        PlanElement planElement2 = PlanUnsaid.make(this.plan, elementUnsaid, planElement);
        this.push(planElement2);
    }

    public void visit(ElementExtension elementExtension) {
        PlanElement planElement = PlanExtension.make(this.plan, elementExtension);
        this.push(planElement);
    }

    private void push(PlanElement planElement) {
        this.retStack.push(planElement);
    }

    private PlanElement pop() {
        return (PlanElement)this.retStack.pop();
    }

    static {
        $assertionsDisabled = !QueryCompilerVisitor.class.desiredAssertionStatus();
    }
}

