/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engineHTTP;

import com.hp.hpl.jena.query.engineHTTP.Params;
import com.hp.hpl.jena.query.engineHTTP.QueryExceptionHTTP;
import com.hp.hpl.jena.query.util.Convert;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.shared.JenaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpQuery
extends Params {
    static final Log log = LogFactory.getLog((String)HttpQuery.class.getName());
    public static int urlLimit = 2048;
    String serviceURL;
    String contentTypeResult = "application/xml";
    static final Object noValue = new Object();
    int responseCode = 0;
    String responseMessage = null;
    boolean forcePOST = false;
    String queryString = null;
    static final String ENC_UTF8 = "UTF-8";

    public HttpQuery(String string) {
        this.init(string);
    }

    public HttpQuery(URL uRL) {
        this.init(uRL.toString());
    }

    private void init(String string) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("URL: " + string));
        }
        if (string.indexOf(63) >= 0) {
            throw new QueryExceptionHTTP(-1, "URL already has a query string (" + string + ")");
        }
        this.serviceURL = string;
    }

    private String getQueryString() {
        if (this.queryString == null) {
            this.queryString = super.httpString();
        }
        return this.queryString;
    }

    public void setAccept(String string) {
        this.contentTypeResult = string;
    }

    public boolean usesPOST() {
        if (this.forcePOST) {
            return true;
        }
        String string = this.getQueryString();
        return this.serviceURL.length() + string.length() >= urlLimit;
    }

    public void setForcePOST() {
        this.forcePOST = true;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public InputStream exec() throws QueryExceptionHTTP {
        try {
            if (this.usesPOST()) {
                return this.execPost();
            }
            return this.execGet();
        }
        catch (QueryExceptionHTTP queryExceptionHTTP) {
            log.trace((Object)"Exception in exec", (Throwable)((Object)queryExceptionHTTP));
            throw queryExceptionHTTP;
        }
        catch (JenaException jenaException) {
            log.trace((Object)"JenaException in exec", (Throwable)jenaException);
            throw jenaException;
        }
    }

    private InputStream execGet() throws QueryExceptionHTTP {
        URL uRL = null;
        String string = this.getQueryString();
        try {
            uRL = this.count() == 0 ? new URL(this.serviceURL) : new URL(this.serviceURL + "?" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malformedURLException);
        }
        log.trace((Object)("GET " + uRL.toExternalForm()));
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Accept", this.contentTypeResult);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            try {
                return this.execCommon(httpURLConnection);
            }
            catch (QueryExceptionHTTP queryExceptionHTTP) {
                if (queryExceptionHTTP.getResponseCode() == 414) {
                    return this.execPost();
                }
                throw queryExceptionHTTP;
            }
        }
        catch (ConnectException connectException) {
            throw new QueryExceptionHTTP(-404, "Failed to connect to remote server");
        }
        catch (IOException iOException) {
            throw new QueryExceptionHTTP(iOException);
        }
    }

    private InputStream execPost() throws QueryExceptionHTTP {
        URL uRL = null;
        try {
            uRL = new URL(this.serviceURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malformedURLException);
        }
        log.trace((Object)("POST " + uRL.toExternalForm()));
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Accept", this.contentTypeResult);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            ListIterator listIterator = this.pairs().listIterator();
            while (listIterator.hasNext()) {
                Params.Pair pair = (Params.Pair)listIterator.next();
                outputStream.write(pair.getName().getBytes());
                outputStream.write(61);
                String string = pair.getValue();
                string = Convert.encWWWForm(string);
                outputStream.write(string.getBytes());
                outputStream.write(38);
            }
            outputStream.flush();
            httpURLConnection.connect();
            return this.execCommon(httpURLConnection);
        }
        catch (RDFException rDFException) {
            throw new QueryExceptionHTTP(-1, "Failed to create RDF request");
        }
        catch (ConnectException connectException) {
            throw new QueryExceptionHTTP(-1, "Failed to connect to remote server");
        }
        catch (IOException iOException) {
            throw new QueryExceptionHTTP(iOException);
        }
    }

    private InputStream execCommon(HttpURLConnection httpURLConnection) throws QueryExceptionHTTP {
        try {
            this.responseCode = httpURLConnection.getResponseCode();
            this.responseMessage = Convert.decWWWForm(httpURLConnection.getResponseMessage());
            if (300 <= this.responseCode && this.responseCode < 400) {
                throw new QueryExceptionHTTP(this.responseCode, this.responseMessage);
            }
            if (this.responseCode >= 400) {
                throw new QueryExceptionHTTP(this.responseCode, this.responseMessage);
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            return inputStream;
        }
        catch (IOException iOException) {
            throw new QueryExceptionHTTP(iOException);
        }
        catch (RDFException rDFException) {
            throw new QueryExceptionHTTP(rDFException);
        }
    }

    public String toString() {
        String string = this.httpString();
        if (string != null || string.length() > 0) {
            return this.serviceURL + "?" + this.httpString();
        }
        return this.serviceURL;
    }
}

