/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engineHTTP;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.engineHTTP.HttpQuery;
import com.hp.hpl.jena.query.resultset.XMLInputStAX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryEngineHTTP
implements QueryExecution {
    String queryString;
    String service;
    List defaultGraphURIs = new ArrayList();
    List namedGraphURIs = new ArrayList();

    public QueryEngineHTTP(String string, Query query2) {
        this.queryString = query2.toString();
        this.service = string;
    }

    public QueryEngineHTTP(String string, String string2) {
        this.queryString = string2;
        this.service = string;
    }

    public void setFileManager(FileManager fileManager) {
    }

    public void setInitialBinding(QuerySolution querySolution) {
        throw new QueryException("Initial bindings not supportd for remote queries");
    }

    public void setDefaultGraphURIs(List list) {
        this.defaultGraphURIs = list;
    }

    public void setNamedGraphURIs(List list) {
        this.namedGraphURIs = list;
    }

    public void addDefaultGraph(String string) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList();
        }
        this.defaultGraphURIs.add(string);
    }

    public void addNamedGraph(String string) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList();
        }
        this.namedGraphURIs.add(string);
    }

    public ResultSet execSelect() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/xml");
        InputStream inputStream = httpQuery.exec();
        ResultSet resultSet = ResultSetFactory.fromXML(inputStream);
        return resultSet;
    }

    public Model execConstruct() {
        return this.execModel();
    }

    public Model execDescribe() {
        return this.execModel();
    }

    private Model execModel() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/rdf+xml");
        InputStream inputStream = httpQuery.exec();
        Model model = ModelFactory.createDefaultModel();
        model.read(inputStream, null);
        return model;
    }

    public boolean execAsk() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/rdf+xml");
        InputStream inputStream = httpQuery.exec();
        XMLInputStAX xMLInputStAX = new XMLInputStAX(inputStream);
        return xMLInputStAX.getBooleanResult();
    }

    private HttpQuery makeHttpQuery() {
        String string;
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.addParam("query", this.queryString);
        Iterator iterator = this.defaultGraphURIs.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            httpQuery.addParam("default-graph-uri", string);
        }
        iterator = this.namedGraphURIs.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            httpQuery.addParam("named-graph-uri", string);
        }
        return httpQuery;
    }

    public void abort() {
    }

    public void close() {
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }
}

