/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.E_Function;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.CastXSD;

public class E_Cast
extends E_Function {
    Expr expr;
    Node castType;
    CastXSD castXSD = null;

    public E_Cast(XSDDatatype xSDDatatype, Expr expr) {
        super(xSDDatatype.getURI(), expr);
        this.expr = expr;
        this.castType = Node.createURI((String)xSDDatatype.getURI());
        this.castXSD = new CastXSD(xSDDatatype);
    }

    public E_Cast(Node node, Expr expr) {
        super(node.getURI(), expr);
        this.expr = expr;
        this.castType = node;
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(node.getURI());
        if (rDFDatatype instanceof XSDDatatype) {
            this.castXSD = new CastXSD((XSDDatatype)rDFDatatype);
        }
    }

    public NodeValue eval(Binding binding) {
        NodeValue nodeValue = this.expr.eval(binding);
        if (this.castXSD != null) {
            return this.castXSD.exec(nodeValue);
        }
        String string = null;
        if (nodeValue.isNode()) {
            if (nodeValue.getNode().isLiteral()) {
                string = nodeValue.getNode().getLiteralLexicalForm();
            } else {
                throw new ExprEvalException("Can't cast node: " + nodeValue);
            }
        }
        if (string != null && nodeValue.isString()) {
            string = nodeValue.getString();
        }
        if (string == null) {
            throw new ExprEvalException("Can't cast: " + nodeValue);
        }
        NodeValue nodeValue2 = NodeValue.makeNode(string, null, this.castType);
        return nodeValue2;
    }
}

