/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNodeOp1;
import com.hp.hpl.jena.query.expr.ExprUndefException;
import com.hp.hpl.jena.query.expr.NodeValue;

public class E_Datatype
extends ExprNodeOp1 {
    private static final String symbol = "datatype";

    public E_Datatype(Expr expr) {
        super(expr, symbol);
    }

    public NodeValue eval(Binding binding) {
        NodeValue nodeValue = this.expr.eval(binding);
        if (!nodeValue.isNode()) {
            return NodeValue.FALSE;
        }
        Node node = nodeValue.getNode();
        if (!node.isLiteral()) {
            throw new ExprEvalException("E_Datatype: Not a literal: " + node);
        }
        String string = node.getLiteralDatatypeURI();
        if (string == null) {
            throw new ExprUndefException("Datatype: No datatype URI (" + node + ")");
        }
        return NodeValue.makeNode(Node.createURI((String)string));
    }
}

