/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.Function;
import com.hp.hpl.jena.query.function.FunctionRegistry;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import java.util.ArrayList;
import java.util.List;

public class E_Function
extends ExprNodeFunction {
    private static final String symbol = "function";
    List args = null;
    String name = null;
    Function function = null;
    boolean initialized = false;

    public E_Function(String string, Expr expr) {
        super(symbol);
        this.name = string;
        this.args = new ArrayList();
        this.args.add(expr);
    }

    public E_Function(String string, List list) {
        super(symbol);
        this.name = string;
        this.args = list;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.function = FunctionRegistry.global().get(this.name);
        if (this.function == null) {
            throw new ExprEvalException("URI '" + this.name + "' not found as a function");
        }
    }

    public NodeValue eval(Binding binding) {
        this.init();
        NodeValue nodeValue = this.function.exec(this.args, binding);
        return nodeValue;
    }

    public void check() {
    }

    public Expr getArg(int n) {
        if (this.args.size() <= --n) {
            return null;
        }
        return (Expr)this.args.get(n);
    }

    public int numArgs() {
        return this.args.size();
    }

    public String getPrintName(SerializationContext serializationContext) {
        return FmtUtils.stringForURI(this.name, serializationContext);
    }
}

