/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.ReturnBoolean;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class E_Regex
extends ExprNodeFunction
implements ReturnBoolean {
    private static final String name = "regex";
    Expr expr;
    Expr pattern;
    Expr flags;
    boolean constantRegex = false;
    Regex regex = null;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();

    public E_Regex(Expr expr, Expr expr2, Expr expr3) {
        super(name);
        this.expr = expr;
        this.pattern = expr2;
        this.flags = expr3;
        if (this.pattern instanceof NodeValue && this.flags instanceof NodeValue) {
            NodeValue nodeValue = (NodeValue)expr2;
            NodeValue nodeValue2 = (NodeValue)expr3;
            if (nodeValue.isString() && nodeValue2.isString()) {
                this.constantRegex = true;
                try {
                    this.regex = new Regex(nodeValue.getString(), nodeValue2.getString());
                }
                catch (MalformedPatternException malformedPatternException) {
                    throw new ExprException("Regex: Pattern exception: " + (Object)((Object)malformedPatternException));
                }
            }
        }
    }

    public E_Regex(Expr expr, String string, String string2) {
        super(name);
        this.expr = expr;
        this.pattern = NodeValue.makeNodeString(string);
        this.flags = NodeValue.makeNodeString(string2);
        try {
            this.regex = new Regex(string, string2);
            this.constantRegex = true;
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new ExprException("Regex: Pattern exception: " + (Object)((Object)malformedPatternException));
        }
    }

    public NodeValue eval(Binding binding) {
        boolean bl;
        NodeValue nodeValue = this.expr.eval(binding);
        if (!nodeValue.isString()) {
            throw new ExprEvalException("REGEX: " + this.expr + " evaluates to " + nodeValue + ", which is not a string");
        }
        Regex regex = this.regex;
        if (regex == null) {
            NodeValue nodeValue2 = this.pattern.eval(binding);
            NodeValue nodeValue3 = null;
            if (this.flags != null) {
                nodeValue3 = this.flags.eval(binding);
            }
            if (!nodeValue2.isString()) {
                throw new ExprEvalException("REGEX: Pattern is no a string: " + nodeValue2);
            }
            if (nodeValue3 != null && !nodeValue3.isString()) {
                throw new ExprEvalException("REGEX: Pattern flags are not a string: " + nodeValue3);
            }
            String string = nodeValue3 == null ? null : nodeValue3.getString();
            try {
                regex = new Regex(nodeValue2.getString(), string);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new ExprEvalException("Regex: Pattern exception: " + (Object)((Object)malformedPatternException));
            }
        }
        return (bl = regex.match(nodeValue.getString())) ? NodeValue.TRUE : NodeValue.FALSE;
    }

    public void check() {
    }

    private int makeMask(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 1;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 's': {
                    n |= 0x10;
                    continue block6;
                }
                case 'x': {
                    n |= 0x20;
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regex modifiers: " + string.charAt(i));
                }
            }
        }
        return n;
    }

    public Expr getArg(int n) {
        if (n == 1) {
            return this.expr;
        }
        if (n == 2) {
            return this.pattern;
        }
        if (n == 3 && this.flags != null) {
            return this.flags;
        }
        return null;
    }

    public int numArgs() {
        if (this.flags != null) {
            return 3;
        }
        return 2;
    }

    private class Regex {
        Pattern regexPattern;

        Regex(String string, String string2) throws MalformedPatternException {
            int n = 0;
            if (string2 != null) {
                n = E_Regex.this.makeMask(string2);
            }
            this.regexPattern = E_Regex.this.compiler.compile(string, n);
        }

        boolean match(String string) {
            return E_Regex.this.matcher.contains(string, this.regexPattern);
        }
    }
}

