/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.extension;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.QueryIterExtension;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.extension.ExtensionPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class ExtensionBase
implements ExtensionPoint {
    private Mark mark;
    private ExecutionContext context;
    private ElementExtension element;

    public QueryIterator compile(Mark mark, QueryIterator queryIterator, ElementExtension elementExtension, ExecutionContext executionContext, DatasetGraph datasetGraph) {
        this.mark = mark;
        this.context = executionContext;
        return new QueryIterExtension(mark, queryIterator, elementExtension, this, executionContext, datasetGraph);
    }

    protected Mark getMark() {
        return this.mark;
    }

    protected ExecutionContext getExecutionContext() {
        return this.context;
    }

    public QueryIterator execUnevaluated(List list, Binding binding) {
        if (list == null) {
            throw new ARQInternalErrorException("FunctionBase: Null args list");
        }
        ArrayList<NodeValue> arrayList = new ArrayList<NodeValue>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Expr expr = (Expr)listIterator.next();
            NodeValue nodeValue = expr.eval(binding);
            arrayList.add(nodeValue);
        }
        return this.execEvaluated(arrayList, binding);
    }

    public QueryIterator execEvaluated(List list, Binding binding) {
        return new QueryIterSingleton(this.getMark(), binding, this.getExecutionContext());
    }
}

