/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.FunctionBase1;

public class CastXSD
extends FunctionBase1 {
    XSDDatatype castType;

    public CastXSD(XSDDatatype xSDDatatype) {
        this.castType = xSDDatatype;
    }

    public NodeValue exec(NodeValue nodeValue) {
        String string = null;
        if (nodeValue.isNode()) {
            if (nodeValue.getNode().isLiteral()) {
                string = nodeValue.getNode().getLiteralLexicalForm();
            } else {
                throw new ExprEvalException("CastXSD: Can't cast node: " + nodeValue);
            }
        }
        if (string != null && nodeValue.isString()) {
            string = nodeValue.getString();
        }
        if (string == null) {
            throw new ExprEvalException("CastXSD: Can't cast: " + nodeValue);
        }
        if (!this.castType.isValid(string)) {
            throw new ExprEvalException("CastXSD: Not a valid literal form: " + string);
        }
        NodeValue nodeValue2 = NodeValue.makeNode(string, this.castType);
        return nodeValue2;
    }
}

