/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.function.CastXSD;
import com.hp.hpl.jena.query.function.Function;
import com.hp.hpl.jena.query.function.library.evenInteger;
import com.hp.hpl.jena.query.function.library.matches;
import com.hp.hpl.jena.query.util.Loader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FunctionRegistry {
    static FunctionRegistry globalRegistry = null;
    Map registry = new HashMap();
    Set attemptedLoads = new HashSet();
    static final String xfn = "http://www.w3.org/2005/04/xpath-functions/#";

    public static synchronized FunctionRegistry global() {
        if (globalRegistry == null) {
            globalRegistry = new FunctionRegistry();
            globalRegistry.loadStdDefs();
            FunctionRegistry.global().put("http://example.org/functions#even", new evenInteger());
        }
        return globalRegistry;
    }

    public void put(String string, Function function) {
        this.registry.put(string, function);
    }

    public Function get(String string) {
        Function function = (Function)this.registry.get(string);
        if (function == null) {
            if (this.attemptedLoads.contains(string)) {
                return null;
            }
            function = (Function)Loader.load(string, Function.class);
            this.put(string, function);
            this.attemptedLoads.add(string);
        }
        return function;
    }

    public Function remove(String string) {
        return (Function)this.registry.remove(string);
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }

    private void loadStdDefs() {
        this.addCast(XSDDatatype.XSDdecimal);
        this.addCast(XSDDatatype.XSDinteger);
        this.addCast(XSDDatatype.XSDlong);
        this.addCast(XSDDatatype.XSDint);
        this.addCast(XSDDatatype.XSDshort);
        this.addCast(XSDDatatype.XSDbyte);
        this.addCast(XSDDatatype.XSDnonPositiveInteger);
        this.addCast(XSDDatatype.XSDnegativeInteger);
        this.addCast(XSDDatatype.XSDnonNegativeInteger);
        this.addCast(XSDDatatype.XSDpositiveInteger);
        this.addCast(XSDDatatype.XSDunsignedLong);
        this.addCast(XSDDatatype.XSDunsignedInt);
        this.addCast(XSDDatatype.XSDunsignedShort);
        this.addCast(XSDDatatype.XSDdouble);
        this.addCast(XSDDatatype.XSDfloat);
        this.addCast(XSDDatatype.XSDdateTime);
        this.addCast(XSDDatatype.XSDboolean);
        this.addCast(XSDDatatype.XSDstring);
        this.addCast(XSDDatatype.XSDanyURI);
        this.put("http://www.w3.org/2005/04/xpath-functions/#matches", new matches());
    }

    private void addCast(XSDDatatype xSDDatatype) {
        this.put(xSDDatatype.getURI(), new CastXSD(xSDDatatype));
    }
}

