/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import junit.framework.TestCase;

public class SerializerTest
extends TestCase {
    static int count = 0;
    String queryString;
    TestItem testItem;

    public SerializerTest(String string, TestItem testItem) {
        super(string);
        this.testItem = testItem;
    }

    public SerializerTest(String string) {
        this(string, string);
    }

    public SerializerTest(String string, String string2) {
        this.setTest(string, string2);
    }

    private void setTest(String string, String string2) {
        super.setName(string);
        this.queryString = string2;
    }

    protected void runTest() throws Throwable {
        try {
            Query query2 = null;
            query2 = this.queryString == null ? this.queryFromTestItem(this.testItem) : this.queryFromString(this.queryString);
            Syntax syntax = Syntax.syntaxSPARQL;
            if (this.testItem != null && this.testItem.getQueryFileSyntax() != null) {
                syntax = this.testItem.getQueryFileSyntax();
            }
            IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
            query2.serialize(indentedLineBuffer, syntax);
            try {
                Query query3 = QueryFactory.create(indentedLineBuffer.toString(), syntax);
                if (query3 == null) {
                    return;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return;
            }
            catch (QueryException queryException) {
                SerializerTest.fail((String)("Parsing printed query: " + queryException.getMessage()));
            }
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Exception exception) {
            SerializerTest.fail((String)("Exception: " + exception.getClass().getName() + ": " + exception.getMessage()));
        }
    }

    private Query queryFromString(String string) {
        Query query2 = QueryFactory.create(string);
        return query2;
    }

    private Query queryFromTestItem(TestItem testItem) {
        if (testItem.getQueryFile() == null) {
            SerializerTest.fail((String)"Query test file is null");
            return null;
        }
        Query query2 = QueryFactory.read(testItem.getQueryFile(), null, testItem.getQueryFileSyntax());
        return query2;
    }
}

