/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import com.hp.hpl.jena.query.parser.sparql.ParseException;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParser;
import com.hp.hpl.jena.query.parser.sparql.TokenMgrError;
import com.hp.hpl.jena.shared.JenaException;
import java.io.ByteArrayInputStream;
import junit.framework.TestCase;

public abstract class TestExpr
extends TestCase {
    public static final int NO_FAILURE = 100;
    public static final int PARSE_FAIL = 250;
    public static final int EVAL_FAIL = 200;
    String testName;
    String exprString;
    Query query;
    Binding binding;
    int failureMode;
    boolean doEval;

    protected TestExpr(String string, String string2, Query query2, Binding binding, int n) {
        this.testName = string;
        this.doEval = true;
        String string3 = string.replace('(', '[').replace(')', ']');
        switch (n) {
            case 100: {
                break;
            }
            case 250: {
                string3 = string3 + " [Parse fail]";
                break;
            }
            case 200: {
                string3 = string3 + " [Eval fail]";
                break;
            }
            default: {
                string3 = string3 + " [Unknown fail]";
            }
        }
        this.setName(string3);
        this.exprString = string2;
        if (query2 == null) {
            query2 = QueryFactory.make();
        }
        this.query = query2;
        if (binding == null) {
            binding = new BindingMap();
        }
        this.binding = binding;
        this.failureMode = n;
    }

    protected void runTest() throws Throwable {
        Expr expr = null;
        try {
            expr = this.parse(this.exprString);
        }
        catch (Error error) {
            TestExpr.fail((String)("Error thrown in parse: " + error));
        }
        catch (Exception exception) {
            if (this.failureMode != 250) {
                TestExpr.fail((String)("Unexpected parsing failure: " + exception));
            }
            this.checkException(expr, exception);
            return;
        }
        if (this.failureMode == 250) {
            TestExpr.fail((String)("Test should have failed in parsing: " + expr));
            return;
        }
        this.checkExpr(expr);
        if (!this.doEval) {
            return;
        }
        try {
            NodeValue nodeValue = expr.eval(this.binding);
            this.checkValue(expr, nodeValue);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            this.checkException(expr, exception);
        }
    }

    private Expr parse(String string) throws Throwable {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            return this.parseSPARQL(byteArrayInputStream);
        }
        catch (QueryParseException queryParseException) {
            throw queryParseException;
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (JenaException jenaException) {
            throw new QueryException(jenaException.getMessage(), jenaException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            TestExpr.fail((String)("Unexpected throwable: " + throwable));
            throw new QueryParseException(throwable);
        }
    }

    private Expr parseARQ(ByteArrayInputStream byteArrayInputStream) throws Throwable {
        try {
            ARQParser aRQParser = new ARQParser(byteArrayInputStream);
            aRQParser.setQuery(this.query);
            return aRQParser.Expression();
        }
        catch (com.hp.hpl.jena.query.parser.arq.ParseException parseException) {
            throw new QueryParseException(parseException.getMessage());
        }
        catch (com.hp.hpl.jena.query.parser.arq.TokenMgrError tokenMgrError) {
            throw new QueryParseException(tokenMgrError.getMessage());
        }
        catch (Error error) {
            String string = error.getMessage();
            if (string == null) {
                throw new QueryParseException(error);
            }
            throw new QueryParseException(string);
        }
    }

    private Expr parseSPARQL(ByteArrayInputStream byteArrayInputStream) throws Throwable {
        try {
            SPARQLParser sPARQLParser = new SPARQLParser(byteArrayInputStream);
            sPARQLParser.setQuery(this.query);
            return sPARQLParser.Expression();
        }
        catch (ParseException parseException) {
            throw new QueryParseException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new QueryParseException(tokenMgrError.getMessage());
        }
        catch (Error error) {
            String string = error.getMessage();
            if (string == null) {
                throw new QueryParseException(error);
            }
            throw new QueryParseException(string);
        }
    }

    protected boolean failureCorrect() {
        return this.failureMode != 100;
    }

    protected boolean evalCorrect() {
        return this.failureMode != 200;
    }

    abstract void checkExpr(Expr var1);

    abstract void checkValue(Expr var1, NodeValue var2);

    abstract void checkException(Expr var1, Exception var2);

    public String toString() {
        return this.testName;
    }
}

