/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.query.vocabulary.VocabTestQuery;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;

class TestItem {
    Resource testResource = null;
    Resource actionResource;
    String name;
    String resultFile;
    String comment;
    List defaultGraphURIs;
    List namedGraphURIs;
    Resource testType = null;
    String baseURI;
    String queryFile;
    Syntax queryFileSyntax;
    Resource queryForm;
    Resource resultForm;

    public String getName() {
        return this.name;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String getComment() {
        return this.comment;
    }

    public List getDefaultGraphURIs() {
        return this.defaultGraphURIs;
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public Resource getTestType() {
        return this.testType;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public Syntax getQueryFileSyntax() {
        return this.queryFileSyntax;
    }

    public Resource getQueryForm() {
        return this.queryForm;
    }

    public Resource getResultForm() {
        return this.resultForm;
    }

    TestItem(Resource resource, Resource resource2, Syntax syntax, DataFormat dataFormat) {
        this.testResource = resource;
        if (!resource.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem with no action");
        }
        if (!resource.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name");
        }
        this.testType = TestUtils.getResource(resource, RDF.type);
        if (this.testType == null) {
            this.testType = resource2;
        }
        this.queryFileSyntax = syntax;
        this.name = this._getName();
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.defaultGraphURIs = this._getDefaultGraphURIs();
        this.namedGraphURIs = this._getNamedGraphsURIs();
        this.queryFile = this._getQueryFile();
        this.queryFileSyntax = this._getSyntax(resource.getModel(), this.queryFile, syntax);
        if (this.queryFileSyntax == null && this.queryFile != null) {
            this.queryFileSyntax = Syntax.guessQueryFileSyntax(this.queryFile);
        }
        this.queryForm = this._getQueryForm();
        this.resultForm = this._getResultForm();
    }

    public Resource getResource() {
        return this.testResource;
    }

    String _getName() {
        Statement statement = this.testResource.getProperty(TestManifest.name);
        if (statement == null) {
            return "<<unset>>";
        }
        return statement.getString();
    }

    Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    String _getResultFile() {
        return TestUtils.getLiteralOrURI(this.testResource, TestManifest.result);
    }

    String _getComment() {
        Statement statement = this.testResource.getProperty(RDFS.comment);
        if (statement == null) {
            return null;
        }
        return statement.getString();
    }

    List _getDefaultGraphURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StmtIterator stmtIterator = this._getAction().listProperties(VocabTestQuery.data);
        while (stmtIterator.hasNext()) {
            Object object = stmtIterator.next();
            String string = ((Statement)object).getResource().getURI();
            arrayList.add(string);
        }
        stmtIterator.close();
        return arrayList;
    }

    List _getNamedGraphsURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StmtIterator stmtIterator = this._getAction().listProperties(VocabTestQuery.graphData);
        while (stmtIterator.hasNext()) {
            Object object = stmtIterator.next();
            String string = ((Statement)object).getResource().getURI();
            arrayList.add(string);
        }
        stmtIterator.close();
        return arrayList;
    }

    String _getQueryFile() {
        Resource resource = this._getAction();
        if (resource.hasProperty(VocabTestQuery.query)) {
            return TestUtils.getLiteralOrURI(resource, VocabTestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    Resource _getQueryForm() {
        return null;
    }

    Resource _getResultForm() {
        return null;
    }

    Syntax _getSyntax(Model model, String string, Syntax syntax) {
        Resource resource = model.createResource(string);
        if (resource.hasProperty(RDF.type)) {
            return Syntax.make(resource.getProperty(RDF.type).getResource().getURI());
        }
        return syntax;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        stringBuffer.append("Name: " + string);
        if (this.getComment() != null) {
            stringBuffer.append("    Comment: " + this.getComment());
        }
        return stringBuffer.toString();
    }
}

