/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.query.vocabulary.TestManifestX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.LogFactory;

class TestManifestList {
    Model manifest = null;
    List testEntries = new ArrayList();
    List includedFiles = new ArrayList();
    String name = null;
    String realName = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$query$junit$TestManifestList;

    public TestManifestList(String string) {
        string = RelURI.resolveFileURL(string);
        this.manifest = FileManager.get().loadModel(string);
        this.parseManifestModel();
    }

    public Model getModel() {
        return this.manifest;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.realName = string;
        String string2 = string;
        string2 = string2.replace('(', '{');
        this.name = string2 = string2.replace(')', '}');
    }

    public Iterator iterator() {
        return this.testEntries.iterator();
    }

    public Iterator includedManifests() {
        return this.includedFiles.iterator();
    }

    private void parseManifestModel() {
        this.parseIncludes();
        this.parseTests();
    }

    private void parseIncludes() {
        StmtIterator stmtIterator = this.manifest.listStatements(null, TestManifestX.include, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            if (!(statement.getObject() instanceof Resource)) {
                LogFactory.getLog((Class)(class$com$hp$hpl$jena$query$junit$TestManifestList == null ? TestManifestList.class$("com.hp.hpl.jena.query.junit.TestManifestList") : class$com$hp$hpl$jena$query$junit$TestManifestList)).warn((Object)("Include: not a Resource" + statement));
                continue;
            }
            Resource resource = statement.getResource();
            this.parseIncludes(resource);
        }
        stmtIterator.close();
    }

    private void parseIncludes(Resource resource) {
        if (!resource.isAnon()) {
            String string = resource.getURI();
            if (this.includedFiles.contains(string)) {
                return;
            }
            this.includedFiles.add(resource.getURI());
            return;
        }
        Resource resource2 = resource;
        while (!resource2.equals(RDF.nil)) {
            resource = resource2.getRequiredProperty(RDF.first).getResource();
            this.parseIncludes(resource);
            resource2 = resource2.getRequiredProperty(RDF.rest).getResource();
        }
    }

    private void parseTests() {
        StmtIterator stmtIterator = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        while (stmtIterator.hasNext()) {
            Syntax syntax;
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            String string = TestUtils.getLiteral(resource, RDFS.label);
            if (string != null) {
                this.setName(string);
            }
            if (!((syntax = TestUtils.getQuerySyntax(resource)) == null || syntax.equals(Syntax.syntaxRDQL) || syntax.equals(Syntax.syntaxARQ) || syntax.equals(Syntax.syntaxSPARQL))) {
                throw new QueryTestException("Unknown syntax: " + syntax);
            }
            Resource resource2 = TestUtils.getResource(resource, TestManifestX.defaultTestType);
            StmtIterator stmtIterator2 = resource.listProperties(TestManifest.entries);
            while (stmtIterator2.hasNext()) {
                Resource resource3 = stmtIterator2.nextStatement().getResource();
                while (!resource3.equals(RDF.nil)) {
                    Resource resource4 = resource3.getRequiredProperty(RDF.first).getResource();
                    TestItem testItem = new TestItem(resource4, resource2, syntax, DataFormat.langXML);
                    this.testEntries.add(testItem);
                    resource3 = resource3.getRequiredProperty(RDF.rest).getResource();
                }
            }
            stmtIterator2.close();
        }
        stmtIterator.close();
    }

    public void apply(ActionProc actionProc) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TestItem testItem = (TestItem)iterator.next();
            actionProc.map1(testItem);
        }
    }

    public static interface ActionProc {
        public void map1(TestItem var1);
    }
}

