/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.parser.ParserARQ;
import com.hp.hpl.jena.query.parser.ParserN3QL;
import com.hp.hpl.jena.query.parser.ParserRDQL;
import com.hp.hpl.jena.query.parser.ParserSPARQL;
import com.hp.hpl.jena.query.parser.ParserXML;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Parser {
    static Log log = LogFactory.getLog((Class)Parser.class);

    public abstract Query parse(Query var1, String var2) throws QueryParseException;

    public static boolean canParse(Syntax syntax) {
        Parser parser = Parser.createParser(syntax);
        return parser != null;
    }

    public static Parser createParser(Syntax syntax) {
        if (syntax.equals(Syntax.syntaxSPARQL)) {
            return new ParserSPARQL();
        }
        if (syntax.equals(Syntax.syntaxSPARQL_X)) {
            return new ParserXML();
        }
        if (syntax.equals(Syntax.syntaxARQ)) {
            return new ParserARQ();
        }
        if (syntax.equals(Syntax.syntaxRDQL)) {
            return new ParserRDQL();
        }
        if (syntax.equals(Syntax.syntaxN3QL)) {
            return new ParserN3QL();
        }
        return null;
    }

    static void queryStep2(Query query2) {
        if (query2.isSelectType()) {
            if (query2.getQueryBlock() == null) {
                throw new QueryParseException("Missing WHERE clause in SELECT query");
            }
            if (query2.isQueryResultStar()) {
                Parser.findAndAddNamedVars(query2);
            }
        }
        if (query2.isConstructType()) {
            if (query2.getQueryBlock() == null) {
                throw new QueryParseException("Missing WHERE clause in CONSTRUCT query");
            }
            Parser.findAndAddNamedVars(query2);
        }
        if (query2.isDescribeType() && query2.isQueryResultStar()) {
            Parser.findAndAddNamedVars(query2);
        }
        if (query2.isAskType() && query2.getQueryBlock() == null) {
            throw new QueryParseException("Missing WHERE clause in ASK query");
        }
    }

    private static void findAndAddNamedVars(Query query2) {
        Set set = query2.getQueryBlock().varsMentioned();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            char c = string.charAt(0);
            if (!Character.isLetter(c)) continue;
            query2.addResultVar(string);
        }
    }
}

