/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.TripleCollector;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.parser.QNameException;
import com.hp.hpl.jena.query.util.JenaURIException;
import com.hp.hpl.jena.query.util.LabelToNodeMap;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.vocabulary.RDF;

public class ParserBase {
    protected final Node XSD_TRUE = Node.createLiteral((String)"true", null, (RDFDatatype)XSDDatatype.XSDboolean);
    protected final Node XSD_FALSE = Node.createLiteral((String)"false", null, (RDFDatatype)XSDDatatype.XSDboolean);
    protected final Node nRDFtype = RDF.type.asNode();
    protected final Node nRDFnil = RDF.nil.asNode();
    protected final Node nRDFfirst = RDF.first.asNode();
    protected final Node nRDFrest = RDF.rest.asNode();
    protected final Node nRDFsubject = RDF.subject.asNode();
    protected final Node nRDFpredicate = RDF.predicate.asNode();
    protected final Node nRDFobject = RDF.object.asNode();
    protected boolean inConstructTemplate = false;
    LabelToNodeMap bNodeLabels = new LabelToNodeMap(false);
    LabelToNodeMap anonVarLabels;
    LabelToNodeMap activeLabelMap = this.anonVarLabels = new LabelToNodeMap(true);
    Query query;
    static final String bNodeLabelStart = "_:";

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public Query getQuery() {
        return this.query;
    }

    protected void setInConstructTemplate(boolean bl) {
        this.inConstructTemplate = bl;
        this.activeLabelMap = this.inConstructTemplate ? this.bNodeLabels : this.anonVarLabels;
    }

    protected Element compressGroupOfOneGroup(ElementGroup elementGroup) {
        Element element;
        if (elementGroup.getElements().size() == 1 && (element = (Element)elementGroup.getElements().get(0)) instanceof ElementGroup) {
            return element;
        }
        return elementGroup;
    }

    protected Node makeNodeInteger(String string) {
        return Node.createLiteral((String)string, null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node makeNodeInteger(long l) {
        return Node.createLiteral((String)Long.toString(l), null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node makeNodeDouble(String string) {
        return Node.createLiteral((String)string, null, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    protected Node makeNode(String string, String string2, Node node) {
        String string3 = node == null ? null : node.getURI();
        return this.makeNode(string, string2, string3);
    }

    protected Node makeNode(String string, String string2, String string3) {
        Node node = null;
        if (string3 != null) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
            node = Node.createLiteral((String)string, null, (RDFDatatype)rDFDatatype);
        } else {
            node = Node.createLiteral((String)string, (String)string2, null);
        }
        return node;
    }

    protected long integerValue(String string) {
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        if (string.startsWith("0x")) {
            string = string.substring(2);
            return Long.parseLong(string, 16);
        }
        return Long.parseLong(string);
    }

    protected double doubleValue(String string) {
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        double d = Double.parseDouble(string);
        return d;
    }

    protected String stripQuotes(String string) {
        return string.substring(1, string.length() - 1);
    }

    protected String stripChars(String string, int n) {
        return string.substring(n, string.length());
    }

    protected Node createNodeFromURI(String string, int n, int n2) {
        String string2 = string;
        if (string.startsWith(bNodeLabelStart)) {
            string = string.substring(bNodeLabelStart.length());
            Node node = Node.createAnon((AnonId)new AnonId(string));
            return node;
        }
        if (this.getQuery() != null && this.getQuery().getBaseURI() != null) {
            try {
                string2 = RelURI.resolve(string2, this.getQuery().getBaseURI());
            }
            catch (JenaURIException jenaURIException) {
                String string3 = "Line " + n + ", column " + n2;
                throw new QueryParseException(string3 + ": " + jenaURIException.getMessage());
            }
        }
        return Node.createURI((String)string2);
    }

    protected Node createBNode() {
        return this.activeLabelMap.allocNode();
    }

    protected Node createBNode(String string) {
        return this.activeLabelMap.asNode(string);
    }

    protected String fixupQName(String string, int n, int n2) {
        String string2 = this.getQuery().expandQName(string);
        if (string2 == null) {
            String string3 = "Line " + n + ", column " + n2;
            throw new QNameException(string3 + ": Unresolved qname: " + string);
        }
        return string2;
    }

    protected String fixupPrefix(String string, int n, int n2) {
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void insert(TripleCollector tripleCollector, Node node, Node node2, Node node3) {
        tripleCollector.addTriple(new Triple(node, node2, node3));
    }

    protected void insert(TripleCollector tripleCollector, int n, Node node, Node node2, Node node3) {
        tripleCollector.addTriple(n, new Triple(node, node2, node3));
    }

    protected Expr asExpr(Node node) {
        if (node.isVariable()) {
            return new NodeVar(node.getName());
        }
        return NodeValue.makeNode(node);
    }

    protected String unescapeURI(String string, int n, int n2) {
        return ParserBase.unescapeStr(string, '\\', true, n, n2);
    }

    protected String unescapeStr(String string, int n, int n2) {
        return ParserBase.unescapeStr(string, '\\', false, n, n2);
    }

    public static String unescapeStr(String string, char c, boolean bl, int n, int n2) {
        int n3 = string.indexOf(c);
        if (n3 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n3));
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case '\n': 
                case '\r': {
                    ++n;
                    n2 = 1;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            if (c2 != c) {
                stringBuffer.append(c2);
            } else {
                char c3;
                if (n3 >= string.length() - 1) {
                    throw new QueryParseException(ParserBase.exMsg("Illegal escape at end of string", n, n2));
                }
                char c4 = string.charAt(n3 + 1);
                if (c4 == 'u') {
                    if (n3 + 5 >= string.length()) {
                        throw new QueryParseException(ParserBase.exMsg("\\u escape too short", n, n2));
                    }
                    c3 = ParserBase.hex(string, n3 + 2, 4, n, n2);
                    stringBuffer.append(c3);
                    n3 += 5;
                    n2 += 5;
                } else if (c4 == 'U') {
                    if (n3 + 9 >= string.length()) {
                        throw new QueryParseException(ParserBase.exMsg("\\U escape too short", n, n2));
                    }
                    c3 = ParserBase.hex(string, n3 + 2, 8, n, n2);
                    stringBuffer.append(c3);
                    n3 += 9;
                    n2 += 9;
                } else {
                    c3 = '\u0000';
                    if (bl) {
                        if (c4 == '\\') {
                            c3 = '\\';
                        }
                    } else {
                        switch (c4) {
                            case 'n': {
                                c3 = '\n';
                                break;
                            }
                            case 't': {
                                c3 = '\t';
                                break;
                            }
                            case 'r': {
                                c3 = '\r';
                                break;
                            }
                            case 'b': {
                                c3 = '\b';
                                break;
                            }
                            case 'f': {
                                c3 = '\f';
                                break;
                            }
                            case '\'': {
                                c3 = '\'';
                                break;
                            }
                            case '\"': {
                                c3 = '\"';
                                break;
                            }
                            case '\\': {
                                c3 = '\\';
                            }
                        }
                    }
                    if (c3 == '\u0000') {
                        throw new QueryParseException(ParserBase.exMsg("Unknown escape: \\" + c4, n, n2));
                    }
                    ++n3;
                    ++n2;
                    stringBuffer.append(c3);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static int hex(String string, int n, int n2, int n3, int n4) {
        if (n + n2 >= string.length()) {
            // empty if block
        }
        int n5 = 0;
        for (int i = n; i < n + n2; ++i) {
            char c = string.charAt(i);
            ++n4;
            int n6 = 0;
            switch (c) {
                case '0': {
                    n6 = 0;
                    break;
                }
                case '1': {
                    n6 = 1;
                    break;
                }
                case '2': {
                    n6 = 2;
                    break;
                }
                case '3': {
                    n6 = 3;
                    break;
                }
                case '4': {
                    n6 = 4;
                    break;
                }
                case '5': {
                    n6 = 5;
                    break;
                }
                case '6': {
                    n6 = 6;
                    break;
                }
                case '7': {
                    n6 = 7;
                    break;
                }
                case '8': {
                    n6 = 8;
                    break;
                }
                case '9': {
                    n6 = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    n6 = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    n6 = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    n6 = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    n6 = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    n6 = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    n6 = 15;
                    break;
                }
                default: {
                    throw new QueryParseException(ParserBase.exMsg("Illegal hex escape: " + c, n3, n4));
                }
            }
            n5 = (n5 << 4) + n6;
        }
        return n5;
    }

    protected static String exMsg(String string, int n, int n2) {
        return "Line " + n + ", column " + n2 + ": " + string;
    }
}

