/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser;

import com.hp.hpl.jena.query.Constants;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.parser.Parser;
import com.hp.hpl.jena.query.parser.rdql.ParseException;
import com.hp.hpl.jena.query.parser.rdql.Q_Query;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import com.hp.hpl.jena.query.util.RelURI;
import java.io.StringReader;

class ParserRDQL
extends Parser {
    ParserRDQL() {
    }

    public Query parse(Query query2, String string) {
        query2.setSyntax(Syntax.syntaxRDQL);
        PrefixMapping2 prefixMapping2 = new PrefixMapping2(Constants.getGlobalPrefixMap(), query2.getPrefixMapping());
        query2.setPrefixMapping(prefixMapping2);
        query2.getPrefixMapping().setNsPrefixes(Constants.getGlobalPrefixMap());
        Q_Query q_Query = null;
        try {
            StringReader stringReader = new StringReader(string);
            RDQLParser rDQLParser = new RDQLParser(stringReader);
            rDQLParser.CompilationUnit();
            q_Query = (Q_Query)rDQLParser.top();
            q_Query.rdqlPhase2(query2);
            if (query2.getGraphURIs() != null) {
                for (int i = 0; i < query2.getGraphURIs().size(); ++i) {
                    String string2 = (String)query2.getGraphURIs().get(i);
                    string2 = RelURI.resolve(string2, query2.getBaseURI());
                    query2.getGraphURIs().set(i, string2);
                }
            }
            return query2;
        }
        catch (QueryParseException queryParseException) {
            throw queryParseException;
        }
        catch (ParseException parseException) {
            throw new QueryParseException("Parse error: " + parseException.getMessage());
        }
        catch (Error error) {
            throw new QueryParseException("Parse error: " + error.getMessage());
        }
        catch (Exception exception) {
            throw new QueryParseException("Unexpected exception: " + exception.getMessage());
        }
    }
}

