/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.Node;
import com.hp.hpl.jena.query.parser.rdql.ParsedLiteral;
import com.hp.hpl.jena.query.parser.rdql.Q_ConstraintClause;
import com.hp.hpl.jena.query.parser.rdql.Q_Identifier;
import com.hp.hpl.jena.query.parser.rdql.Q_PrefixDecl;
import com.hp.hpl.jena.query.parser.rdql.Q_PrefixesClause;
import com.hp.hpl.jena.query.parser.rdql.Q_QName;
import com.hp.hpl.jena.query.parser.rdql.Q_SelectClause;
import com.hp.hpl.jena.query.parser.rdql.Q_SourceClause;
import com.hp.hpl.jena.query.parser.rdql.Q_TriplePattern;
import com.hp.hpl.jena.query.parser.rdql.Q_TriplePatternClause;
import com.hp.hpl.jena.query.parser.rdql.Q_URI;
import com.hp.hpl.jena.query.parser.rdql.Q_URL;
import com.hp.hpl.jena.query.parser.rdql.Q_Var;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;
import com.hp.hpl.jena.query.parser.rdql.SimpleNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class Q_Query
extends SimpleNode {
    private Query query = null;
    boolean constructStar = false;
    boolean selectAllVars = false;

    public Q_Query(int n) {
        super(n);
    }

    public Q_Query(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void rdqlPhase2(Query query2) {
        this.query = query2;
        ElementGroup elementGroup = new ElementGroup();
        this.query.setQueryElement(elementGroup);
        ArrayList arrayList = new ArrayList();
        try {
            this.postParse1(query2);
            this.postParse2(query2);
            int n = this.jjtGetNumChildren();
            int n2 = 0;
            if (this.jjtGetChild(n2) instanceof Q_SelectClause) {
                query2.setQueryType(111);
                this.extractVarList(query2, this.jjtGetChild(n2));
                ++n2;
            }
            if (query2.isUnknownType()) {
                throw new ARQInternalErrorException("Parser didn't catch absence of SELECT, DESCRIBE, ASK or CONSTRUCT clause");
            }
            if (n2 < n && this.jjtGetChild(n2) instanceof Q_SourceClause) {
                int n3 = this.jjtGetChild(n2).jjtGetNumChildren();
                if (n3 > 1) {
                    throw new QueryException("Error: Multiple sources in FROM clause");
                }
                for (int i = 0; i < n3; ++i) {
                    Node node = this.jjtGetChild(n2).jjtGetChild(i).jjtGetChild(0);
                    String string = ((Q_URL)node).urlString;
                    query2.addGraphURI(string);
                }
                ++n2;
            }
            if (n2 < n && this.jjtGetChild(n2) instanceof Q_TriplePatternClause) {
                this.makeElementTriplePatterns(query2, this.jjtGetChild(n2), elementGroup, arrayList);
                ++n2;
            }
            if (n2 < n && this.jjtGetChild(n2) instanceof Q_ConstraintClause) {
                this.makeElementConstraints(query2, elementGroup, this.jjtGetChild(n2));
                ++n2;
            }
            if (this.constructStar) {
                // empty if block
            }
            if (this.selectAllVars) {
                this.query.setQueryResultStar(true);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    query2.addResultVar(string);
                }
            }
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            throw aRQInternalErrorException;
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (ClassCastException classCastException) {
            throw new ARQInternalErrorException("Parser generated illegal parse tree", classCastException);
        }
        catch (Exception exception) {
            LogFactory.getLog((Class)Q_Query.class).warn((Object)"Unknown exception", (Throwable)exception);
            throw new ARQInternalErrorException("Unknown exception: " + exception);
        }
    }

    public String toString() {
        throw new UnsupportedOperationException("Q_Query.toString()");
    }

    private void extractVarList(Query query2, Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        for (int i = 0; i < n; ++i) {
            Node node2 = node.jjtGetChild(i);
            if (!(node2 instanceof Q_Var)) {
                throw new ARQInternalErrorException("Internal error: parser created '" + node2.getClass().getName() + "' when Q_Var expected");
            }
            Q_Var q_Var = (Q_Var)node2;
            query2.addResultVar(q_Var.varName);
        }
    }

    private void extractVarOrURIList(Query query2, Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        for (int i = 0; i < n; ++i) {
            ExprNode exprNode;
            Node node2 = node.jjtGetChild(i);
            if (node2 instanceof Q_Var) {
                exprNode = (Q_Var)node2;
                query2.addResultVar(((Q_Var)exprNode).varName);
                continue;
            }
            if (node2 instanceof Q_URI || node2 instanceof Q_QName) {
                exprNode = (Q_URI)node2;
                query2.addResultURIs(((ParsedLiteral)exprNode).getNode());
                continue;
            }
            throw new ARQInternalErrorException("Internal error: parser created '" + node2.getClass().getName() + "' when Q_Var expected");
        }
    }

    private void makeElementTriplePatterns(Query query2, Node node, ElementGroup elementGroup, List list) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Q_TriplePattern q_TriplePattern = (Q_TriplePattern)node.jjtGetChild(i);
            if (q_TriplePattern.jjtGetNumChildren() != 3) {
                throw new ARQInternalErrorException("Triple pattern has " + q_TriplePattern.jjtGetNumChildren() + " children");
            }
            com.hp.hpl.jena.graph.Node node2 = Q_Query.convertToGraphNode(q_TriplePattern.jjtGetChild(0), query2, list);
            com.hp.hpl.jena.graph.Node node3 = Q_Query.convertToGraphNode(q_TriplePattern.jjtGetChild(1), query2, list);
            com.hp.hpl.jena.graph.Node node4 = Q_Query.convertToGraphNode(q_TriplePattern.jjtGetChild(2), query2, list);
            Triple triple = new Triple(node2, node3, node4);
            ElementTriplePattern elementTriplePattern = new ElementTriplePattern(triple);
            elementGroup.addElement(elementTriplePattern);
        }
    }

    private void extractFixedTriplePatterns(Query query2, List list, Node node, List list2) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Q_TriplePattern q_TriplePattern = (Q_TriplePattern)node.jjtGetChild(i);
            if (q_TriplePattern.jjtGetNumChildren() != 3) {
                throw new ARQInternalErrorException("Triple pattern has " + q_TriplePattern.jjtGetNumChildren() + " children");
            }
            com.hp.hpl.jena.graph.Node node2 = Q_Query.convertToGraphNode(q_TriplePattern.jjtGetChild(0), query2, list2);
            com.hp.hpl.jena.graph.Node node3 = Q_Query.convertToGraphNode(q_TriplePattern.jjtGetChild(1), query2, list2);
            com.hp.hpl.jena.graph.Node node4 = Q_Query.convertToGraphNode(q_TriplePattern.jjtGetChild(2), query2, list2);
            list.add(new Triple(node2, node3, node4));
        }
    }

    private static com.hp.hpl.jena.graph.Node convertToGraphNode(Node node, Query query2, List list) {
        if (node instanceof Q_Var) {
            String string = ((Q_Var)node).getName();
            if (list != null) {
                list.add(string);
            }
            return com.hp.hpl.jena.graph.Node.createVariable((String)((Q_Var)node).getName());
        }
        if (node instanceof ParsedLiteral) {
            ParsedLiteral parsedLiteral = (ParsedLiteral)node;
            if (parsedLiteral.isNode()) {
                return parsedLiteral.getNode();
            }
            if (parsedLiteral.isURI()) {
                return com.hp.hpl.jena.graph.Node.createURI((String)parsedLiteral.getURI());
            }
            if (parsedLiteral.isString()) {
                return com.hp.hpl.jena.graph.Node.createLiteral((String)parsedLiteral.getString(), null, null);
            }
            if (parsedLiteral.isBoolean()) {
                return com.hp.hpl.jena.graph.Node.createLiteral((String)parsedLiteral.asUnquotedString(), null, null);
            }
            if (parsedLiteral.isInt()) {
                return com.hp.hpl.jena.graph.Node.createLiteral((String)parsedLiteral.asUnquotedString(), null, (RDFDatatype)XSDDatatype.XSDinteger);
            }
            if (parsedLiteral.isDouble()) {
                return com.hp.hpl.jena.graph.Node.createLiteral((String)parsedLiteral.asUnquotedString(), null, (RDFDatatype)XSDDatatype.XSDdouble);
            }
            String string = parsedLiteral.getString();
            LogFactory.getLog((Class)Q_Query.class).fatal((Object)("Failed to convert: " + string));
        }
        throw new ARQInternalErrorException("convertToGraphNode encountered strange type: " + node.getClass().getName());
    }

    private void makeElementConstraints(Query query2, ElementGroup elementGroup, Node node) {
        Q_ConstraintClause q_ConstraintClause = (Q_ConstraintClause)node;
        int n = q_ConstraintClause.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node2 = q_ConstraintClause.jjtGetChild(i);
            if (!(node2 instanceof Constraint)) {
                throw new ARQInternalErrorException("Parse node in AND clause isn't a Constraint");
            }
            ElementFilter elementFilter = new ElementFilter((Constraint)((Object)node2));
            elementGroup.addElement(elementFilter);
        }
    }

    private void extractPrefixes(Query query2, Q_PrefixesClause q_PrefixesClause) {
        if (q_PrefixesClause == null) {
            return;
        }
        int n = q_PrefixesClause.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Q_PrefixDecl q_PrefixDecl = (Q_PrefixDecl)q_PrefixesClause.jjtGetChild(i);
            for (int j = 0; j < q_PrefixDecl.jjtGetNumChildren(); j += 2) {
                Q_Identifier q_Identifier = (Q_Identifier)q_PrefixDecl.jjtGetChild(j);
                Q_URI q_URI = (Q_URI)q_PrefixDecl.jjtGetChild(j + 1);
                this.query.setPrefix(q_Identifier.toString(), q_URI.toString());
            }
        }
    }
}

