/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetMem
implements ResultSetRewindable {
    static Log log = LogFactory.getLog((Class)ResultSetMem.class);
    static final boolean DEBUG = false;
    List rows = new ArrayList();
    List varNames = null;
    int rowNumber = 0;
    Iterator iterator = null;
    boolean ordered = false;
    boolean distinct = false;

    public ResultSetMem(ResultSetMem resultSetMem) {
        this(resultSetMem, false);
    }

    public ResultSetMem(ResultSetMem resultSetMem, boolean bl) {
        this.varNames = resultSetMem.varNames;
        this.ordered = resultSetMem.ordered;
        this.distinct = resultSetMem.distinct;
        if (bl) {
            Iterator iterator = resultSetMem.rows.iterator();
            while (iterator.hasNext()) {
                this.rows.add(iterator.next());
            }
        } else {
            this.rows = resultSetMem.rows;
        }
        this.reset();
    }

    public ResultSetMem(ResultSet resultSet) {
        this.ordered = resultSet.isOrdered();
        this.distinct = resultSet.isDistinct();
        if (resultSet instanceof ResultSetMem) {
            ResultSetMem resultSetMem = (ResultSetMem)resultSet;
            this.rows = resultSetMem.rows;
            this.varNames = resultSetMem.varNames;
        } else {
            this.varNames = resultSet.getResultVars();
            while (resultSet.hasNext()) {
                QuerySolution querySolution = resultSet.nextSolution();
                this.rows.add(querySolution);
            }
        }
        this.reset();
    }

    public ResultSetMem(Model model) {
        this.buildFromDumpFormat(model);
    }

    public ResultSetMem() {
        this.varNames = new ArrayList();
        this.reset();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass() + ": Attempt to remove an element");
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public QuerySolution nextSolution() {
        ++this.rowNumber;
        return (QuerySolution)this.iterator.next();
    }

    public Object next() {
        return this.nextSolution();
    }

    public void close() {
        this.iterator = null;
    }

    public void rewind() {
        this.reset();
    }

    public void reset() {
        this.iterator = this.rows.iterator();
        this.rowNumber = 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List getResultVars() {
        return this.varNames;
    }

    private void buildFromDumpFormat(Model model) {
        this.varNames = new ArrayList();
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)ResultSetVocab.ResultSet);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            this.buildOneResource(resource);
        }
        stmtIterator.close();
        this.reset();
    }

    private void buildOneResource(Resource resource) {
        this.buildVariables(resource);
        int n = this.buildPreprocess(resource);
        if (this.ordered) {
            this.buildRowsOrdered(resource, n);
        } else {
            this.buildRows(resource);
        }
    }

    private void buildVariables(Resource resource) {
        StmtIterator stmtIterator = resource.listProperties(ResultSetVocab.resultVariable);
        while (stmtIterator.hasNext()) {
            String string = stmtIterator.nextStatement().getString();
            this.varNames.add(string);
        }
        stmtIterator.close();
    }

    private int buildPreprocess(Resource resource) {
        StmtIterator stmtIterator = resource.listProperties(ResultSetVocab.solution);
        int n = 0;
        int n2 = 0;
        while (stmtIterator.hasNext()) {
            Resource resource2 = stmtIterator.nextStatement().getResource();
            ++n;
            if (!resource2.hasProperty(ResultSetVocab.index)) continue;
            ++n2;
        }
        stmtIterator.close();
        if (n2 > 0 && n != n2) {
            log.warn((Object)("Rows = " + n + " but only " + n2 + " indexes"));
            return n;
        }
        if (n2 > 0) {
            this.ordered = true;
        }
        return n;
    }

    private void buildRowsOrdered(Resource resource, int n) {
        Literal literal;
        StmtIterator stmtIterator;
        Model model = resource.getModel();
        int n2 = 1;
        while ((stmtIterator = model.listStatements(null, ResultSetVocab.index, (RDFNode)(literal = model.createTypedLiteral(n2)))).hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            if (stmtIterator.hasNext()) {
                log.warn((Object)("More than one solution: index = " + n2));
            }
            Resource resource2 = statement.getSubject();
            ResultBinding resultBinding = this.buildBinding(resource2);
            this.rows.add(resultBinding);
            stmtIterator.close();
            ++n2;
        }
        if (this.rows.size() != n) {
            log.warn((Object)("Found " + this.rows.size() + ": expected " + n));
        }
    }

    private void buildRows(Resource resource) {
        int n = 0;
        StmtIterator stmtIterator = resource.listProperties(ResultSetVocab.solution);
        while (stmtIterator.hasNext()) {
            Resource resource2 = stmtIterator.nextStatement().getResource();
            ++n;
            ResultBinding resultBinding = this.buildBinding(resource2);
            this.rows.add(resultBinding);
        }
        stmtIterator.close();
        if (resource.hasProperty(ResultSetVocab.size)) {
            try {
                int n2 = resource.getRequiredProperty(ResultSetVocab.size).getInt();
                if (n2 != n) {
                    log.warn((Object)("Warning: Declared size = " + n2 + " : Count = " + n));
                }
            }
            catch (JenaException jenaException) {
                // empty catch block
            }
        }
    }

    private ResultBinding buildBinding(Resource resource) {
        ResultBinding resultBinding = new ResultBinding(resource.getModel());
        StmtIterator stmtIterator = resource.listProperties(ResultSetVocab.binding);
        while (stmtIterator.hasNext()) {
            Resource resource2 = stmtIterator.nextStatement().getResource();
            String string = resource2.getRequiredProperty(ResultSetVocab.variable).getString();
            try {
                RDFNode rDFNode = resource2.getRequiredProperty(ResultSetVocab.value).getObject();
                resultBinding.add(string, rDFNode);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                log.warn((Object)("Failed to get value for ?" + string));
            }
        }
        stmtIterator.close();
        return resultBinding;
    }

    public Model toModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("rs", ResultSetVocab.getURI());
        model.setNsPrefix("rdf", RDF.getURI());
        this.asRDF(model);
        return model;
    }

    public Resource asRDF(Model model) {
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter((ResultSet)this, (PrefixMapping)model);
        Resource resource = resultSetFormatter.asRDF(model);
        return resource;
    }

    public void list(PrintWriter printWriter) {
        ResultSetMem resultSetMem = new ResultSetMem(this);
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSetMem);
        resultSetFormatter.dump(printWriter, false);
        resultSetMem.close();
    }

    public void list(OutputStream outputStream) {
        ResultSetMem resultSetMem = new ResultSetMem(this);
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSetMem);
        resultSetFormatter.dump(outputStream, false);
        resultSetMem.close();
    }
}

