/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.resultset.BindingComparator;
import com.hp.hpl.jena.query.resultset.QueryIterWrapped;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SortedResultSet
implements ResultSet {
    ResultSet resultSet;

    public SortedResultSet(ResultSet resultSet, List list) {
        this(resultSet, new BindingComparator(list));
    }

    private SortedResultSet(ResultSet resultSet, Comparator comparator) {
        Object object;
        TreeSet<Binding> treeSet = new TreeSet<Binding>(comparator);
        while (resultSet.hasNext()) {
            object = resultSet.nextSolution();
            Binding binding = null;
            binding = object instanceof ResultBinding ? ((ResultBinding)object).getBinding() : this.copyToBinding((QuerySolution)object);
            treeSet.add(binding);
        }
        object = new QueryIterWrapped(treeSet.iterator());
        this.resultSet = new ResultSetStream(resultSet.getResultVars(), (QueryIterator)object);
    }

    public boolean hasNext() {
        return this.resultSet.hasNext();
    }

    public Object next() {
        return this.resultSet.next();
    }

    public QuerySolution nextSolution() {
        return this.resultSet.nextSolution();
    }

    public int getRowNumber() {
        return this.resultSet.getRowNumber();
    }

    public List getResultVars() {
        return this.resultSet.getResultVars();
    }

    public boolean isOrdered() {
        return true;
    }

    public boolean isDistinct() {
        return this.resultSet.isDistinct();
    }

    public void remove() {
        throw new UnsupportedOperationException(SortedResultSet.class.getName() + ".remove");
    }

    private Binding copyToBinding(QuerySolution querySolution) {
        BindingMap bindingMap = new BindingMap();
        Iterator iterator = querySolution.varNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RDFNode rDFNode = querySolution.get(string);
            bindingMap.add(string, rDFNode.asNode());
        }
        return bindingMap;
    }
}

