/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.resultset.ResultSetException;
import com.hp.hpl.jena.query.resultset.XMLResults;
import com.hp.hpl.jena.query.util.LabelToNodeMap;
import com.hp.hpl.jena.query.util.StringUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLInputStAX
implements ResultSet,
XMLResults {
    private static Log log = LogFactory.getLog((Class)XMLInputStAX.class);
    QuerySolution current = null;
    XMLStreamReader parser = null;
    List variables = new ArrayList();
    Binding binding = null;
    LabelToNodeMap bNodes = new LabelToNodeMap(false);
    boolean isResultSet = false;
    boolean ordered = false;
    boolean distinct = false;
    boolean finished = false;
    Model model = null;
    int row = 0;
    private boolean isBooleanResult = false;
    boolean askResult = false;

    public static ResultSet fromXML(InputStream inputStream) {
        return XMLInputStAX.fromXML(inputStream, null);
    }

    public static ResultSet fromXML(InputStream inputStream, Model model) {
        XMLInputStAX xMLInputStAX = new XMLInputStAX(inputStream, model);
        if (!xMLInputStAX.isResultSet) {
            throw new ResultSetException("Not a result set");
        }
        return xMLInputStAX;
    }

    public XMLInputStAX(InputStream inputStream) {
        this(inputStream, ModelFactory.createDefaultModel());
    }

    public XMLInputStAX(InputStream inputStream, Model model) {
        this.model = model;
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            this.parser = xMLInputFactory.createXMLStreamReader(inputStream);
            this.skipTo("head");
            this.processHead();
            this.skipTo(new String[]{"results", "boolean"}, new String[]{"results"});
            String string = this.parser.getLocalName();
            if (string.equals("results")) {
                this.isResultSet = true;
                this.processResults();
            }
            if (string.equals("boolean")) {
                this.isBooleanResult = true;
                this.processBoolean();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            log.warn((Object)("XMLStreamException: " + xMLStreamException.getMessage()), (Throwable)xMLStreamException);
        }
    }

    public boolean hasNext() {
        if (!this.isResultSet) {
            throw new ResultSetException("Not an XML result set");
        }
        try {
            if (this.finished) {
                return false;
            }
            if (this.binding == null) {
                this.binding = this.getOneSolution();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            this.staxError("XMLStreamException: " + xMLStreamException.getMessage(), xMLStreamException);
        }
        ++this.row;
        return this.binding != null;
    }

    public Object next() {
        return this.nextSolution();
    }

    public QuerySolution nextSolution() {
        if (this.finished) {
            throw new NoSuchElementException("End of XML Results");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("End of XML Results");
        }
        ResultBinding resultBinding = new ResultBinding(this.model, this.binding);
        this.binding = null;
        return resultBinding;
    }

    public int getRowNumber() {
        return this.row;
    }

    public List getResultVars() {
        return this.variables;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void remove() {
        throw new UnsupportedOperationException(XMLInputStAX.class.getName());
    }

    public boolean getBooleanResult() {
        if (!this.isBooleanResult) {
            throw new ResultSetException("Not an XML boolean result");
        }
        return this.askResult;
    }

    private void processBoolean() throws XMLStreamException {
        String string = this.parser.getElementText();
        if (string.equalsIgnoreCase("true")) {
            this.askResult = true;
            return;
        }
        if (string.equalsIgnoreCase("false")) {
            this.askResult = true;
            return;
        }
        throw new ResultSetException("Unknown boolean value: " + string);
    }

    private void skipTo(String string) throws XMLStreamException {
        this.skipTo(new String[]{string}, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipTo(String[] stringArray, String[] stringArray2) throws XMLStreamException {
        String string;
        boolean bl = false;
        block5: while (this.parser.hasNext()) {
            int n = this.parser.next();
            switch (n) {
                case 8: {
                    break block5;
                }
                case 2: {
                    if (stringArray2 == null || (string = this.parser.getLocalName()) == null || !this.containsName(stringArray2, string)) break;
                    return;
                }
                case 1: {
                    if (stringArray == null) break;
                    QName qName = this.parser.getName();
                    if (!qName.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
                        this.staxError("skipToHead: Unexpected tag: " + qName);
                    }
                    if (!this.containsName(stringArray, qName.getLocalPart())) break;
                    return;
                }
            }
        }
        if (!bl) {
            String string2 = "";
            if (stringArray != null) {
                string2 = StringUtils.join(", ", stringArray);
            }
            string = "";
            if (stringArray2 != null) {
                string = StringUtils.join(", ", stringArray2);
            }
            log.warn((Object)("Failed to find start of stop of specified elements: " + string2 + " :: " + string));
        }
    }

    private boolean containsName(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processHead() throws XMLStreamException {
        while (this.parser.hasNext()) {
            int n = this.parser.next();
            String string = null;
            switch (n) {
                case 8: {
                    return;
                }
                case 2: {
                    string = this.parser.getLocalName();
                    if (!this.isTag(string, "head")) break;
                    return;
                }
                case 1: {
                    string = this.parser.getLocalName();
                    if (this.isTag(string, "head")) break;
                    if (this.isTag(string, "variable")) {
                        String string2 = this.parser.getAttributeValue(null, "name");
                        this.variables.add(string2);
                        break;
                    }
                    if (this.isTag(string, "link")) break;
                    this.staxError("Unknown XML element: " + string);
                }
            }
        }
    }

    private void processResults() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "ordered");
        if (string != null && string.equals("true")) {
            this.ordered = true;
        }
        if ((string = this.parser.getAttributeValue(null, "distinct")) != null && string.equals("true")) {
            this.distinct = true;
        }
    }

    private Binding getOneSolution() throws XMLStreamException {
        BindingMap bindingMap = new BindingMap();
        String string = null;
        while (this.parser.hasNext()) {
            int n = this.parser.next();
            String string2 = null;
            switch (n) {
                case 8: {
                    this.staxError("End of document while processing solution");
                    return null;
                }
                case 2: {
                    string2 = this.parser.getLocalName();
                    if (this.isTag(string2, "result")) {
                        return bindingMap;
                    }
                    if (!this.isTag(string2, "results")) break;
                    return null;
                }
                case 1: {
                    Object object;
                    String string3;
                    string2 = this.parser.getLocalName();
                    if (this.isTag(string2, "result")) {
                        bindingMap = new BindingMap();
                        break;
                    }
                    if (this.isTag(string2, "binding")) {
                        string = this.parser.getAttributeValue(null, "name");
                        break;
                    }
                    if (this.isTag(string2, "bnode")) {
                        string3 = this.parser.getElementText();
                        object = this.bNodes.asNode(string3);
                        bindingMap.add(string, (Node)object);
                        break;
                    }
                    if (this.isTag(string2, "literal")) {
                        string3 = this.parser.getAttributeValue(null, "datatype");
                        object = this.parser.getAttributeValue(null, "lang");
                        String string4 = this.parser.getElementText();
                        RDFDatatype rDFDatatype = null;
                        if (string3 != null) {
                            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
                        }
                        Node node = Node.createLiteral((String)string4, (String)object, (RDFDatatype)rDFDatatype);
                        bindingMap.add(string, node);
                        break;
                    }
                    if (this.isTag(string2, "unbound") || !this.isTag(string2, "uri")) break;
                    string3 = this.parser.getElementText();
                    object = Node.createURI((String)string3);
                    bindingMap.add(string, (Node)object);
                    break;
                }
            }
        }
        this.staxError("getOneSolution: Hit end unexpectedly");
        return null;
    }

    private boolean isTag(String string, String string2) {
        if (!this.parser.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
            return false;
        }
        return string.equals(string2);
    }

    private void staxError(String string) {
        log.warn((Object)("StAX error: " + string));
        throw new ResultSetException(string);
    }

    private void staxError(String string, Throwable throwable) {
        log.warn((Object)("StAX error: " + string), throwable);
        throw new ResultSetException(string, throwable);
    }
}

