/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.ResultSetProcessor;
import com.hp.hpl.jena.query.resultset.XMLResults;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class XMLOutputResultSet
implements ResultSetProcessor,
XMLResults {
    int index = 0;
    String stylesheetURL = null;
    IndentedWriter out;
    int bNodeCounter = 0;
    Map bNodeMap = new HashMap();
    boolean xmlInst = true;

    public XMLOutputResultSet(OutputStream outputStream, String string) {
        this(new IndentedWriter(outputStream), string);
    }

    public XMLOutputResultSet(IndentedWriter indentedWriter, String string) {
        this.out = indentedWriter;
        this.stylesheetURL = string;
    }

    public void start(ResultSet resultSet) {
        if (this.xmlInst) {
            this.out.println("<?xml version=\"1.0\"?>");
        }
        if (this.stylesheetURL != null) {
            this.out.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetURL + "\"?>");
        }
        this.out.println("<sparql");
        this.out.incIndent(2);
        this.out.incIndent(2);
        this.out.println("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        this.out.println("xmlns:xs=\"http://www.w3.org/2001/XMLSchema#\"");
        this.out.println("xmlns=\"http://www.w3.org/2005/sparql-results#\" >");
        this.out.decIndent(2);
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.println("<head>");
        Iterator iterator = resultSet.getResultVars().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("variable");
            this.out.print(" name=\"" + string + "\"");
            this.out.println("/>");
            this.out.decIndent(2);
        }
        this.out.println("</head>");
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.print("<results ordered=");
        this.out.print(resultSet.isOrdered() ? "\"true\"" : "\"false\"");
        this.out.print(" distinct=");
        this.out.print(resultSet.isDistinct() ? "\"true\"" : "\"false\"");
        this.out.println(">");
        this.out.incIndent(2);
    }

    public void finish(ResultSet resultSet) {
        this.out.decIndent(2);
        this.out.println("</results>");
        this.out.decIndent(2);
        this.out.println("</sparql>");
        this.out.flush();
    }

    public void start(QuerySolution querySolution) {
        this.out.println("<result>");
        ++this.index;
        this.out.incIndent(2);
    }

    public void finish(QuerySolution querySolution) {
        this.out.decIndent(2);
        this.out.println("</result>");
    }

    public void binding(String string, RDFNode rDFNode) {
        this.out.print("<");
        this.out.print("binding");
        this.out.println(" name=\"" + string + "\">");
        this.out.incIndent(2);
        this.printBindingValue(rDFNode);
        this.out.decIndent(2);
        this.out.println("</binding>");
    }

    void printBindingValue(RDFNode rDFNode) {
        if (rDFNode == null) {
            this.out.println("<unbound/>");
            return;
        }
        if (rDFNode instanceof Literal) {
            this.printLiteral((Literal)rDFNode);
            return;
        }
        if (rDFNode instanceof Resource) {
            this.printResource((Resource)rDFNode);
            return;
        }
        LogFactory.getLog(this.getClass()).warn((Object)("Unknown RDFNode type in result set: " + rDFNode.getClass()));
    }

    void printLiteral(Literal literal) {
        String string = literal.getDatatypeURI();
        String string2 = literal.getLanguage();
        this.out.print("<literal");
        if (string2 != null && string2.length() != 0) {
            this.out.print(" xml:lang=\"" + string2 + "\"");
        }
        if (string != null && !string.equals("")) {
            this.out.print(" datatype=\"" + string + "\"");
        }
        this.out.print(">");
        this.out.print(XMLOutputResultSet.xml_escape(literal.getLexicalForm()));
        this.out.println("</literal>");
    }

    void printResource(Resource resource) {
        if (resource.isAnon()) {
            if (!this.bNodeMap.containsKey(resource)) {
                this.bNodeMap.put(resource, "b" + this.bNodeCounter++);
            }
            String string = (String)this.bNodeMap.get(resource);
            this.out.println("<bnode>" + string + "</" + "bnode" + ">");
        } else {
            this.out.println("<uri>" + XMLOutputResultSet.xml_escape(resource.getURI()) + "</" + "uri" + ">");
        }
    }

    static String xml_escape(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        return string2;
    }
}

