/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.Iterator;
import java.util.ListIterator;

public class FmtElementARQ
extends FormatterBase
implements FormatterElement {
    static final boolean allowDoubles = true;
    public static boolean PATTERN_MARKERS = false;
    public static boolean PATTERN_FINAL_DOT = false;
    public static boolean GROUP_SEP_DOT = false;
    public static boolean UNION_MARKERS = true;
    public static boolean GROUP_UNNEST_ONE = false;
    public static boolean GRAPH_FIXED_INDENT = true;
    public static boolean UNSAID_FIXED_INDENT = true;

    public FmtElementARQ(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        super(indentedWriter, serializationContext);
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Element element) {
        FmtElementARQ fmtElementARQ = new FmtElementARQ(indentedWriter, serializationContext);
        fmtElementARQ.startVisit();
        element.visit(fmtElementARQ);
        fmtElementARQ.finishVisit();
    }

    public static String asString(Element element) {
        SerializationContext serializationContext = new SerializationContext(null, null, null);
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FmtElementARQ.format(indentedLineBuffer.getIndentedWriter(), serializationContext, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.formatTriple(elementTriplePattern.getTriple());
        this.out.print(" .");
    }

    public void visit(ElementBlock elementBlock) {
        if (elementBlock.getDataset() != null) {
            DatasetGraph datasetGraph = elementBlock.getDataset();
            this.out.print("DATASET ");
            this.out.incIndent(2);
            Iterator iterator = datasetGraph.listNames();
            if (iterator.hasNext()) {
                boolean bl = false;
                while (iterator.hasNext()) {
                    if (!bl) {
                        this.out.newline();
                    }
                    this.out.print("FROM <");
                    String string = (String)iterator.next();
                    this.out.print(string);
                    this.out.print(">");
                }
            }
            this.out.decIndent(2);
            this.out.newline();
        }
        if (elementBlock.getPatternElement() != null) {
            this.visitAsGroup(elementBlock.getPatternElement());
        }
    }

    public void visit(ElementFilter elementFilter) {
        this.out.print("FILTER ");
        if (elementFilter.getConstraint() instanceof Expr) {
            Expr expr = (Expr)elementFilter.getConstraint();
            FmtExprARQ fmtExprARQ = new FmtExprARQ(this.out, this.context);
            boolean bl = false;
            if (expr instanceof NodeVar) {
                bl = true;
            }
            if (expr instanceof NodeValue) {
                bl = true;
            }
            if (bl) {
                this.out.print("( ");
            }
            expr.visit(fmtExprARQ);
            if (bl) {
                this.out.print(" )");
            }
        } else {
            this.out.print(elementFilter.getConstraint().toString());
        }
    }

    public void visit(ElementUnion elementUnion) {
        if (elementUnion.getElements().size() == 1) {
            Element element = (Element)elementUnion.getElements().get(0);
            this.visitAsGroup(element);
            return;
        }
        if (UNION_MARKERS) {
            this.out.print("{");
            this.out.newline();
            this.out.pad();
        }
        this.out.incIndent(2);
        boolean bl = true;
        ListIterator listIterator = elementUnion.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.out.decIndent(2);
                this.out.newline();
                this.out.print("UNION");
                this.out.newline();
                this.out.incIndent(2);
            }
            Element element = (Element)listIterator.next();
            this.visitAsGroup(element);
            bl = false;
        }
        this.out.decIndent(2);
        if (UNION_MARKERS) {
            this.out.newline();
            this.out.print("}");
        }
    }

    public void visit(ElementGroup elementGroup) {
        if (GROUP_UNNEST_ONE && elementGroup.getElements().size() == 1) {
            Element element = (Element)elementGroup.getElements().get(0);
            this.visitAsGroup(element);
            return;
        }
        this.out.print("{");
        this.out.incIndent(2);
        int n = this.out.getRow();
        this.out.pad();
        boolean bl = true;
        ListIterator listIterator = elementGroup.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                if (GROUP_SEP_DOT) {
                    this.out.print(" . ");
                }
                this.out.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
        }
        this.out.decIndent(2);
        int n2 = this.out.getRow();
        if (n != n2) {
            if (GROUP_SEP_DOT && !PATTERN_FINAL_DOT) {
                this.out.print(" .");
            }
            this.out.newline();
            this.out.print("}");
        } else {
            this.out.print(" }");
        }
    }

    public void visit(ElementOptional elementOptional) {
        this.out.print("OPTIONAL");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(elementOptional.getElement());
        this.out.decIndent(2);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        String string = "GRAPH ";
        int n = string.length();
        this.out.print(string);
        string = elementNamedGraph.getGraphNameNode() == null ? "*" : this.slotToString(this.context, elementNamedGraph.getGraphNameNode());
        this.out.print(string);
        n += string.length();
        if (GRAPH_FIXED_INDENT) {
            this.out.incIndent(2);
            this.out.newline();
        } else {
            this.out.print(" ");
            this.out.incIndent(++n);
        }
        this.visitAsGroup(elementNamedGraph.getElement());
        if (GRAPH_FIXED_INDENT) {
            this.out.decIndent(2);
        } else {
            this.out.decIndent(n);
        }
    }

    public void visit(ElementUnsaid elementUnsaid) {
        String string = "UNSAID ";
        int n = string.length();
        this.out.print(string);
        n += string.length();
        if (UNSAID_FIXED_INDENT) {
            this.out.incIndent(2);
            this.out.newline();
        } else {
            this.out.print(" ");
            this.out.incIndent(++n);
        }
        this.visitAsGroup(elementUnsaid.getElement());
        if (UNSAID_FIXED_INDENT) {
            this.out.decIndent(2);
        } else {
            this.out.decIndent(n);
        }
    }

    public void visit(ElementExtension elementExtension) {
        Expr expr;
        this.out.print("EXT ");
        String string = elementExtension.getURI();
        String string2 = FmtUtils.stringForURI(string, this.context.getPrefixMapping());
        this.out.print(string2);
        this.out.print("(");
        int n = 1;
        while ((expr = elementExtension.getArg(n)) != null) {
            if (n != 1) {
                this.out.print(", ");
            }
            FmtExprARQ fmtExprARQ = new FmtExprARQ(this.out, this.context);
            expr.visit(fmtExprARQ);
            ++n;
        }
        this.out.print(")");
    }

    private void visitAsGroup(Element element) {
        boolean bl = element instanceof ElementGroup;
        if (!bl) {
            this.out.print("{ ");
            this.out.incIndent(2);
        }
        element.visit(this);
        if (!bl) {
            this.out.print(" }");
            this.out.incIndent(2);
        }
    }

    private void formatTriple(Triple triple) {
        this.out.print(this.slotToString(this.context, triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getObject()));
    }

    private String slotToString(SerializationContext serializationContext, Node node) {
        return FmtUtils.stringForNode(node, serializationContext);
    }
}

