/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.Iterator;

public class FmtTemplateARQ
extends FormatterBase
implements FormatterTemplate {
    public FmtTemplateARQ(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        super(indentedWriter, serializationContext);
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Template template) {
        FmtTemplateARQ fmtTemplateARQ = new FmtTemplateARQ(indentedWriter, serializationContext);
        fmtTemplateARQ.startVisit();
        template.visit(fmtTemplateARQ);
        fmtTemplateARQ.finishVisit();
    }

    public static String asString(Template template) {
        SerializationContext serializationContext = new SerializationContext(null, null, null);
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FmtTemplateARQ.format(indentedLineBuffer.getIndentedWriter(), serializationContext, template);
        return indentedLineBuffer.toString();
    }

    public void visit(TemplateGroup templateGroup) {
        this.out.print("{");
        this.out.incIndent(2);
        this.out.pad();
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            template.visit(this);
            this.out.print(" .");
            this.out.newline();
        }
        this.out.decIndent(2);
        this.out.print("}");
        this.out.newline();
    }

    public void visit(TemplateTriple templateTriple) {
        this.formatTriple(templateTriple.getTriple());
    }

    private void formatTriple(Triple triple) {
        this.out.print(this.slotToString(this.context, triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getObject()));
    }

    private String slotToString(SerializationContext serializationContext, Node node) {
        return FmtUtils.stringForNode(node, serializationContext);
    }
}

