/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FmtExprAbstract;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.Iterator;

public class FormatterPlain
extends FormatterBase
implements FormatterElement,
FormatterTemplate {
    static int INDENT = 2;

    public FormatterPlain(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        super(indentedWriter, serializationContext);
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Element element) {
        FormatterPlain formatterPlain = new FormatterPlain(indentedWriter, serializationContext);
        formatterPlain.startVisit();
        element.visit(formatterPlain);
        formatterPlain.finishVisit();
    }

    public static String asString(Element element) {
        SerializationContext serializationContext = new SerializationContext(null, null, null);
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterPlain.format(indentedLineBuffer.getIndentedWriter(), serializationContext, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.out.print("TriplePattern");
        this.formatTriple(elementTriplePattern.getTriple());
    }

    public void visit(ElementBlock elementBlock) {
        this.out.print("Block");
        this.out.incIndent(INDENT);
        this.out.newline();
        if (elementBlock.getDataset() != null) {
            this.out.print("dataset");
        }
        elementBlock.getPatternElement().visit(this);
        this.out.decIndent(INDENT);
    }

    public void visit(ElementFilter elementFilter) {
        this.out.print("Constraint");
        this.out.incIndent(INDENT);
        this.out.newline();
        if (elementFilter.getConstraint() instanceof Expr) {
            Expr expr = (Expr)elementFilter.getConstraint();
            FmtExprAbstract fmtExprAbstract = new FmtExprAbstract(this.out, this.context);
            expr.visit(fmtExprAbstract);
        } else {
            this.out.print(elementFilter.getConstraint().toString());
        }
        this.out.decIndent(INDENT);
    }

    public void visit(ElementUnion elementUnion) {
        this.multiElement("Union", elementUnion.getElements().iterator());
    }

    public void visit(ElementGroup elementGroup) {
        this.multiElement("Group", elementGroup.getElements().iterator());
    }

    public void visit(ElementOptional elementOptional) {
        this.singleElement("Optional", elementOptional.getElement());
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        this.singleElement("Graph", elementNamedGraph.getElement());
    }

    public void visit(ElementUnsaid elementUnsaid) {
        this.singleElement("Unsaid", elementUnsaid.getElement());
    }

    public void visit(ElementExtension elementExtension) {
        Expr expr;
        this.out.print("Ext ");
        String string = elementExtension.getURI();
        String string2 = FmtUtils.stringForURI(string, this.context.getPrefixMapping());
        this.out.print(string2);
        this.out.print("(");
        int n = 1;
        while ((expr = elementExtension.getArg(n)) != null) {
            if (n != 1) {
                this.out.print(", ");
            }
            FmtExprARQ fmtExprARQ = new FmtExprARQ(this.out, this.context);
            expr.visit(fmtExprARQ);
            ++n;
        }
        this.out.print(")");
    }

    private void formatTriple(Triple triple) {
        this.out.print(this.slotToString(this.context, triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getObject()));
    }

    private String slotToString(SerializationContext serializationContext, Node node) {
        return FmtUtils.stringForNode(node, serializationContext);
    }

    private void singleElement(String string, Element element) {
        this.out.print(string);
        this.out.incIndent(INDENT);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(INDENT);
    }

    private void multiElement(String string, Iterator iterator) {
        this.out.print(string);
        this.out.incIndent(INDENT);
        while (iterator.hasNext()) {
            this.out.newline();
            Element element = (Element)iterator.next();
            element.visit(this);
        }
        this.out.decIndent(INDENT);
    }

    public void visit(TemplateTriple templateTriple) {
        Triple triple = templateTriple.getTriple();
        this.formatTriple(triple);
    }

    public void visit(TemplateGroup templateGroup) {
        this.out.print("Template Group");
        this.out.incIndent(INDENT);
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            this.out.newline();
            Template template = (Template)iterator.next();
            template.visit(this);
        }
        this.out.decIndent(INDENT);
        this.out.println();
    }
}

