/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.serializer.FmtExprAbstract;
import com.hp.hpl.jena.query.serializer.FormatterAbstract;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterExpr;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuerySerializerAbstract
implements QueryVisitor {
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FormatterExpr fmtExpr;
    protected IndentedWriter out = null;
    static final int INDENT = 2;
    static final boolean closingBracketOnSameLine = true;

    QuerySerializerAbstract(OutputStream outputStream, SerializationContext serializationContext) {
        this(new IndentedWriter(outputStream), serializationContext);
    }

    QuerySerializerAbstract(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        FormatterAbstract formatterAbstract = new FormatterAbstract(indentedWriter, serializationContext);
        this.fmtElement = formatterAbstract;
        this.fmtTemplate = formatterAbstract;
        this.fmtExpr = new FmtExprAbstract(indentedWriter, serializationContext);
        this.out = indentedWriter;
    }

    public void startVisit(Query query2) {
        this.out.println("(query ");
        this.out.incIndent(2);
    }

    public void visitResultForm(Query query2) {
    }

    public void visitBase(Query query2) {
    }

    public void visitPrefixes(Query query2) {
        if (query2.getPrefixMapping() == null) {
            return;
        }
        Map map = query2.getPrefixMapping().getNsPrefixMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            this.out.println("(prefix " + string + ": <" + string2 + ">)");
        }
    }

    public void visitSelectResultForm(Query query2) {
        this.out.print("(select");
        this.resultFormModifiers(query2);
        this.writeVarList(query2.getResultVars());
        this.out.println(")");
    }

    public void visitConstructResultForm(Query query2) {
        this.out.print("(construct");
        this.resultFormModifiers(query2);
        this.out.println();
        this.out.incIndent(2);
        query2.getConstructTemplate().visit(this.fmtTemplate);
        this.out.decIndent(2);
        this.printClose();
        this.out.println();
    }

    public void visitDescribeResultForm(Query query2) {
        this.out.print("(describe");
        this.resultFormModifiers(query2);
        this.writeVarList(query2.getResultVars());
        this.writeURIList(query2.getResultURIs());
        this.out.println(")");
    }

    public void visitAskResultForm(Query query2) {
        this.out.println("(ask");
        this.out.println(")");
    }

    public void visitDatasetDecl(Query query2) {
    }

    public void visitQueryPattern(Query query2) {
        query2.getQueryBlock().visit(this.fmtElement);
    }

    public void visitOrderBy(Query query2) {
        if (query2.hasOrderBy()) {
            this.out.println("(order");
            this.out.incIndent(2);
            Iterator iterator = query2.getOrderBy().iterator();
            while (iterator.hasNext()) {
                this.out.println("(sort ");
                this.out.incIndent(2);
                SortCondition sortCondition = (SortCondition)iterator.next();
                sortCondition.format(this.fmtExpr, this.out);
                this.out.decIndent(2);
                this.out.println(")");
            }
            this.out.decIndent(2);
            this.printClose();
        }
    }

    public void visitLimit(Query query2) {
    }

    public void visitOffset(Query query2) {
    }

    public void finishVisit(Query query2) {
        this.out.decIndent(2);
        this.printClose();
        this.out.println();
        this.out.flush();
    }

    private void printClose() {
        this.out.print(")");
    }

    private void writeVarList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.out.print(" ?" + string);
        }
    }

    private void writeURIList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.out.println(" <" + string + ">");
        }
    }

    private void resultFormModifiers(Query query2) {
        if (query2.isDistinct()) {
            this.out.print(" (distinct true)");
        }
        if (query2.hasLimit()) {
            this.out.print(" (limit " + query2.getLimit() + ")");
        }
        if (query2.hasOffset()) {
            this.out.print(" (offset " + query2.getOffset() + ")");
        }
    }
}

