/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.serializer.FmtElementARQ;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FmtTemplateARQ;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterExpr;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.QuerySerializer;
import com.hp.hpl.jena.query.serializer.QuerySerializerAbstract;
import com.hp.hpl.jena.query.serializer.QuerySerializerPlain;
import com.hp.hpl.jena.query.serializer.QuerySerializerXML;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.NodeToLabelMap;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Serializer {
    static final int BLOCK_INDENT = 2;
    private static Log log = LogFactory.getLog((Class)Serializer.class);

    public static void serialize(Query query2, OutputStream outputStream) {
        Serializer.serialize(query2, outputStream, null);
    }

    public static void serialize(Query query2, OutputStream outputStream, Syntax syntax) {
        IndentedWriter indentedWriter = new IndentedWriter(outputStream);
        Serializer.serialize(query2, indentedWriter, syntax);
        indentedWriter.flush();
        try {
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void serialize(Query query2, IndentedLineBuffer indentedLineBuffer) {
        Syntax syntax = query2.getSyntax();
        if (syntax == null) {
            syntax = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query2, indentedLineBuffer, syntax);
    }

    public static void serialize(Query query2, IndentedLineBuffer indentedLineBuffer, Syntax syntax) {
        Serializer.serialize(query2, indentedLineBuffer.getIndentedWriter(), syntax);
    }

    public static void serialize(Query query2, IndentedWriter indentedWriter) {
        Syntax syntax = query2.getSyntax();
        if (syntax == null) {
            syntax = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query2, indentedWriter, syntax);
    }

    public static void serialize(Query query2, IndentedWriter indentedWriter, Syntax syntax) {
        if (syntax == null) {
            syntax = Syntax.syntaxSPARQL;
        }
        if (syntax.equals(Syntax.syntaxARQ)) {
            Serializer.serializeARQ(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (syntax.equals(Syntax.syntaxRDQL)) {
            Serializer.serializeRDQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (syntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (syntax.equals(Syntax.syntaxSPARQL_X)) {
            Serializer.serializeSPARQL_X(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (syntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (syntax.equals(Syntax.syntaxN3QL)) {
            Serializer.serializeN3QL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (syntax.equals(Syntax.syntaxAbstract)) {
            Serializer.serializeAbstract(query2, indentedWriter);
            return;
        }
        if (syntax.equals(Syntax.syntaxDebug)) {
            Serializer.serializePlain(query2, indentedWriter);
            return;
        }
        log.warn((Object)("Unknown syntax: " + syntax));
    }

    public static void serializeARQ(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), new NodeToLabelMap("b", true));
        SerializationContext serializationContext2 = new SerializationContext(query2, query2.getPrefixMapping(), new NodeToLabelMap("c", false));
        Serializer.serializeARQ(query2, indentedWriter, new FmtElementARQ(indentedWriter, serializationContext), new FmtExprARQ(indentedWriter, serializationContext), new FmtTemplateARQ(indentedWriter, serializationContext2));
    }

    private static void serializeARQ(Query query2, IndentedWriter indentedWriter, FormatterElement formatterElement, FormatterExpr formatterExpr, FormatterTemplate formatterTemplate) {
        QuerySerializer querySerializer = new QuerySerializer(indentedWriter, formatterElement, formatterExpr, formatterTemplate);
        query2.visit(querySerializer);
    }

    public static void serializeSPARQL(Query query2, IndentedWriter indentedWriter) {
        Serializer.serializeARQ(query2, indentedWriter);
    }

    public static void serializeSPARQL_X(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        QuerySerializerXML querySerializerXML = new QuerySerializerXML(indentedWriter, serializationContext);
        query2.visit(querySerializerXML);
    }

    public static void serializeRDQL(Query query2, IndentedWriter indentedWriter) {
        log.warn((Object)"# unparseRDQL: Not implemented - Native syntax instead");
        Serializer.serializeARQ(query2, indentedWriter);
    }

    public static void serializeAbstract(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        QuerySerializerAbstract querySerializerAbstract = new QuerySerializerAbstract(indentedWriter, serializationContext);
        query2.visit(querySerializerAbstract);
    }

    public static void serializePlain(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        QuerySerializerPlain querySerializerPlain = new QuerySerializerPlain(indentedWriter, serializationContext);
        query2.visit(querySerializerPlain);
    }

    public static void serializeN3QL(Query query2, IndentedWriter indentedWriter) {
        throw new UnsupportedOperationException("Not implemented: Formatting a query in N3QL syntax");
    }
}

