/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.parser.ParserBase;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMisc
extends TestCase {
    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestMisc.class);
        testSuite.setName("TestMisc");
        return testSuite;
    }

    public void testEsc01() {
        this.execTest("x\\uabcd", "x\uabcd");
    }

    public void testEsc02() {
        this.execTest("\\uabcdx", "\uabcdx");
    }

    public void testEsc03() {
        this.execTest("1234\\uabcd1234", "1234\uabcd1234");
    }

    public void testEsc04() {
        this.execTestFail("\\uabck");
    }

    public void testEsc05() {
        this.execTestFail("\\uab");
    }

    public void testEsc06() {
        this.execTestFail("\\uabc");
    }

    public void testEsc07() {
        this.execTestFail("\\ua");
    }

    public void testEsc08() {
        this.execTestFail("\\u");
    }

    public void testEsc09() {
        this.execTestFail("\\");
    }

    public void testEsc10() {
        this.execTest("\\u0020", " ");
    }

    public void testEsc11() {
        this.execTest("\\uFFFF", "\uffff");
    }

    public void testEsc12() {
        this.execTest("\\u0000", "\u0000");
    }

    public void testEsc13() {
        this.execTestFail("\\U0000");
    }

    public void testEsc14() {
        this.execTest("\\U00000000", "\u0000");
    }

    public void testEsc15() {
        this.execTest("x\\tx\\n\\r", "x\tx\n\r");
    }

    private void execTestFail(String string) {
        try {
            String string2 = ParserBase.unescapeStr(string, '\\', false, 1, 1);
            TestMisc.fail((String)("Unescaping succeeded on " + string));
        }
        catch (QueryParseException queryParseException) {
            return;
        }
    }

    private void execTest(String string, String string2) {
        String string3 = ParserBase.unescapeStr(string, '\\', false, 1, 1);
        TestMisc.assertEquals((String)("Unescaped string does not match (" + string + ")"), (String)string2, (String)string3);
    }
}

