/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.expr.NodeValue;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNodeValue
extends TestCase {
    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestNodeValue.class);
        testSuite.setName("TestNodeValue");
        return testSuite;
    }

    public void testNum1() {
        NodeValue nodeValue = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + nodeValue), (boolean)nodeValue.isInteger());
        TestNodeValue.assertFalse((String)("Is a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNum2() {
        NodeValue nodeValue = NodeValue.makeDouble(5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + nodeValue), (boolean)nodeValue.isDouble());
        TestNodeValue.assertFalse((String)("Is a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNum3() {
        NodeValue nodeValue = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + nodeValue), (boolean)nodeValue.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNum4() {
        NodeValue nodeValue = NodeValue.makeNodeDouble(5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + nodeValue), (boolean)nodeValue.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNodeInt1() {
        NodeValue nodeValue = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + nodeValue), (boolean)nodeValue.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNodeInt2() {
        NodeValue nodeValue = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + nodeValue), (boolean)nodeValue.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNodeInt3() {
        NodeValue nodeValue = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + nodeValue), (boolean)nodeValue.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57", (String)string);
    }

    public void testNodeInt4() {
        NodeValue nodeValue = NodeValue.makeNodeInteger(18L);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + nodeValue), (boolean)nodeValue.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"18", (String)string);
    }

    public void testNodeInt5() {
        NodeValue nodeValue = NodeValue.makeNodeInteger("018");
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + nodeValue), (boolean)nodeValue.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"018", (String)string);
    }

    public void testNodeDouble1() {
        NodeValue nodeValue = NodeValue.makeNode("57.0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + nodeValue), (boolean)nodeValue.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57.0", (String)string);
    }

    public void testNodeDouble2() {
        NodeValue nodeValue = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + nodeValue), (boolean)nodeValue.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">"), (String)string);
    }

    public void testNodeDouble3() {
        NodeValue nodeValue = NodeValue.makeNode("057.0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + nodeValue), (boolean)nodeValue.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + nodeValue), (boolean)nodeValue.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"057.0", (String)string);
    }

    public void testNodeBool1() {
        NodeValue nodeValue = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + nodeValue), (boolean)nodeValue.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        TestNodeValue.assertTrue((String)("Not satisfied: " + nodeValue), (boolean)nodeValue.isSatisfied(null));
    }

    public void testNodeBool2() {
        NodeValue nodeValue = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + nodeValue), (boolean)nodeValue.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        TestNodeValue.assertFalse((String)("Satisfied: " + nodeValue), (boolean)nodeValue.isSatisfied(null));
    }

    public void testFloatDouble1() {
        NodeValue nodeValue = NodeValue.makeNodeDouble("1.5");
        NodeValue nodeValue2 = NodeValue.makeNode("1.5", XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)"Should be equal: 1.5 float and 1.5 double", (boolean)NodeValue.sameValueAs(nodeValue, nodeValue2));
    }

    public void testFloatDouble5() {
        NodeValue nodeValue = NodeValue.makeNodeDouble("1.3");
        NodeValue nodeValue2 = NodeValue.makeNode("1.3", XSDDatatype.XSDfloat);
        TestNodeValue.assertFalse((String)"Should not be equal: 1.3 float and 1.3 double", (boolean)NodeValue.sameValueAs(nodeValue, nodeValue2));
    }

    public void testString1() {
        NodeValue nodeValue = NodeValue.makeString("string");
        TestNodeValue.assertTrue((String)("Not a string: " + nodeValue), (boolean)nodeValue.isString());
        TestNodeValue.assertFalse((String)("Is a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNodeString1() {
        NodeValue nodeValue = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + nodeValue), (boolean)nodeValue.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
    }

    public void testNodeString2() {
        NodeValue nodeValue = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + nodeValue), (boolean)nodeValue.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"\"string\"", (String)string);
    }

    public void testNodeString3() {
        NodeValue nodeValue = NodeValue.makeNode("string", XSDDatatype.XSDstring);
        TestNodeValue.assertTrue((String)("Not a string: " + nodeValue), (boolean)nodeValue.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        String string = nodeValue.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">"), (String)string);
    }

    public void testDate1() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTimeInMillis(0L);
        gregorianCalendar.set(2005, 1, 18, 20, 39, 10);
        NodeValue nodeValue = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdateTime);
        TestNodeValue.assertTrue((String)("Not a date: " + nodeValue), (boolean)nodeValue.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + nodeValue), (boolean)nodeValue.isNode());
        Calendar calendar = nodeValue.getDate();
        TestNodeValue.assertEquals((String)("Not equal: " + nodeValue), (Object)gregorianCalendar, (Object)calendar);
    }

    public void testSameValueAsIntPlain() {
        NodeValue nodeValue = NodeValue.makeInteger(5L);
        NodeValue nodeValue2 = NodeValue.makeInteger(7L);
        TestNodeValue.assertTrue((String)("Different values (" + nodeValue + "," + nodeValue2 + ")"), (!NodeValue.sameValueAs(nodeValue, nodeValue2) ? 1 : 0) != 0);
        NodeValue nodeValue3 = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Different values (" + nodeValue + "," + nodeValue3 + ")"), (boolean)NodeValue.sameValueAs(nodeValue, nodeValue3));
    }

    public void testSameValueAsIntNodeInt() {
        NodeValue nodeValue = NodeValue.makeInteger(5L);
        NodeValue nodeValue2 = NodeValue.makeNodeInteger(7L);
        TestNodeValue.assertTrue((String)("Different values (" + nodeValue + "," + nodeValue2 + ")"), (!NodeValue.sameValueAs(nodeValue, nodeValue2) ? 1 : 0) != 0);
        NodeValue nodeValue3 = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Different values (" + nodeValue + "," + nodeValue3 + ")"), (boolean)NodeValue.sameValueAs(nodeValue, nodeValue3));
    }

    public void testCompareAsInt() {
        NodeValue nodeValue = NodeValue.makeInteger(5L);
        NodeValue nodeValue2 = NodeValue.makeInteger(7L);
        TestNodeValue.assertTrue((String)("Does not compare " + nodeValue + " & " + nodeValue2), (NodeValue.compare(nodeValue, nodeValue2) == -1 ? 1 : 0) != 0);
        NodeValue nodeValue3 = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Does not compare " + nodeValue + " & " + nodeValue3), (NodeValue.compare(nodeValue, nodeValue3) == 0 ? 1 : 0) != 0);
    }

    public void testCompareAsIntNodeInt() {
        NodeValue nodeValue = NodeValue.makeInteger(5L);
        NodeValue nodeValue2 = NodeValue.makeNodeInteger(7L);
        TestNodeValue.assertTrue((String)("Does not compare " + nodeValue + " & " + nodeValue2), (NodeValue.compare(nodeValue, nodeValue2) == -1 ? 1 : 0) != 0);
        NodeValue nodeValue3 = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Does not compare " + nodeValue + " & " + nodeValue3), (NodeValue.compare(nodeValue, nodeValue3) == 0 ? 1 : 0) != 0);
    }
}

