/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.resultset.RSCompare;
import com.hp.hpl.jena.query.resultset.ResultSetMem;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.test.QueryIterOneBinding;
import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestResultSet
extends TestCase {
    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestResultSet.class);
        testSuite.setName("TestResultSet");
        return testSuite;
    }

    public void test_RS_cmp_1() {
        ResultSetMem resultSetMem = new ResultSetMem();
        ResultSetMem resultSetMem2 = new ResultSetMem();
        TestResultSet.assertTrue((boolean)RSCompare.sameOrdered(resultSetMem, resultSetMem2));
        resultSetMem.reset();
        resultSetMem2.reset();
        TestResultSet.assertTrue((boolean)RSCompare.sameUnordered(resultSetMem, resultSetMem2));
    }

    public void test_RS_cmp_2() {
        ResultSet resultSet = this.make("x", Node.createURI((String)"tag:local"));
        ResultSetMem resultSetMem = new ResultSetMem();
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(resultSet, resultSetMem));
    }

    public void test_RS_cmp_3() {
        ResultSet resultSet = this.make("x", Node.createURI((String)"tag:local"));
        ResultSetMem resultSetMem = new ResultSetMem();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(resultSet, resultSetMem));
    }

    public void test_RS_cmp_4() {
        ResultSet resultSet = this.make("x", Node.createURI((String)"tag:local"));
        ResultSet resultSet2 = this.make("x", Node.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)RSCompare.sameOrdered(resultSet, resultSet2));
        TestResultSet.assertTrue((boolean)RSCompare.sameUnordered(resultSet, resultSet2));
    }

    public void test_RS_cmp_5() {
        ResultSetRewindable resultSetRewindable = this.makeRewindable("x", Node.createURI((String)"tag:local:1"));
        ResultSetRewindable resultSetRewindable2 = this.makeRewindable("x", Node.createURI((String)"tag:local:2"));
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(resultSetRewindable, resultSetRewindable2));
        resultSetRewindable.reset();
        resultSetRewindable2.reset();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(resultSetRewindable, resultSetRewindable2));
    }

    public void test_RS_cmp_6() {
        ResultSetRewindable resultSetRewindable = this.makeRewindable("x", Node.createURI((String)"tag:local"));
        ResultSetRewindable resultSetRewindable2 = this.makeRewindable("y", Node.createURI((String)"tag:local"));
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(resultSetRewindable, resultSetRewindable2));
        resultSetRewindable.reset();
        resultSetRewindable2.reset();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(resultSetRewindable, resultSetRewindable2));
    }

    private ResultSet make(String string, Node node) {
        BindingMap bindingMap = new BindingMap();
        bindingMap.add(string, node);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        QueryIterOneBinding queryIterOneBinding = new QueryIterOneBinding(bindingMap);
        ResultSetStream resultSetStream = new ResultSetStream(arrayList, (QueryIterator)queryIterOneBinding);
        return resultSetStream;
    }

    private ResultSetRewindable makeRewindable(String string, Node node) {
        ResultSet resultSet = this.make(string, node);
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable(resultSet);
        return resultSetRewindable;
    }

    private ResultSet make(String string, Node node, String string2, Node node2) {
        BindingMap bindingMap = new BindingMap();
        bindingMap.add(string, node);
        bindingMap.add(string2, node2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        QueryIterOneBinding queryIterOneBinding = new QueryIterOneBinding(bindingMap);
        ResultSetStream resultSetStream = new ResultSetStream(arrayList, (QueryIterator)queryIterOneBinding);
        return resultSetStream;
    }

    private ResultSetRewindable makeRewindable(String string, Node node, String string2, Node node2) {
        ResultSet resultSet = this.make(string, node, string2, node2);
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable(resultSet);
        return resultSetRewindable;
    }
}

