/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;

public class ExprUtils {
    public static void dump(PrintStream printStream, List list, Binding binding) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        ExprUtils.print(printWriter, list);
        printWriter.flush();
    }

    public static void dump(PrintWriter printWriter, List list, Binding binding) {
        if (list == null) {
            return;
        }
        if (list.size() == 0) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            NodeValue nodeValue;
            Expr expr = (Expr)listIterator.next();
            if (expr instanceof NodeVar) {
                printWriter.print("?" + ((NodeVar)expr).getName());
                printWriter.print(" = ");
                nodeValue = expr.eval(binding);
                printWriter.print(nodeValue.asQuotedString());
                printWriter.print(" ");
                continue;
            }
            nodeValue = expr.eval(binding);
            printWriter.print(nodeValue.asUnquotedString());
            printWriter.print(" ");
        }
        printWriter.println();
    }

    public static void print(PrintStream printStream, List list) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)printStream);
        ExprUtils.print(printWriter, list);
        printWriter.flush();
    }

    public static void print(PrintWriter printWriter, List list) {
        if (list == null) {
            printWriter.println("<<Null list>>");
            return;
        }
        if (list.size() == 0) {
            printWriter.println("<<Empty list>>");
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            NodeValue nodeValue = (NodeValue)listIterator.next();
            printWriter.print(nodeValue.asUnquotedString());
        }
        printWriter.println();
    }
}

