/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.query.Constants;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigInteger;

public class FmtUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static PrefixMapping prefixes = PrefixMapping.Factory.create().setNsPrefixes(PrefixMapping.Standard).setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    static boolean applyUnicodeEscapes = false;

    public static String stringForObject(Object object) {
        if (object == null) {
            return "<<null>>";
        }
        if (object instanceof RDFNode) {
            return FmtUtils.stringForRDFNode((RDFNode)object);
        }
        if (object instanceof Node) {
            return FmtUtils.stringForNode((Node)object);
        }
        return object.toString();
    }

    public static String stringForRDFNode(RDFNode rDFNode) {
        return FmtUtils.stringForRDFNode(rDFNode, null);
    }

    public static String stringForRDFNode(RDFNode rDFNode, SerializationContext serializationContext) {
        return FmtUtils.stringForNode(rDFNode.asNode(), serializationContext);
    }

    public static String stringForLiteral(Node_Literal node_Literal, SerializationContext serializationContext) {
        String string = node_Literal.getLiteralDatatypeURI();
        String string2 = node_Literal.getLiteralLanguage();
        String string3 = node_Literal.getLiteralLexicalForm();
        if (string != null) {
            if (string.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(string3);
                    return string3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals(XSD.xdouble.getURI()) && (string3.indexOf(46) >= 0 || string3.indexOf(101) >= 0 || string3.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(string3);
                    return string3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals(XSD.xboolean.getURI())) {
                if (string3.equalsIgnoreCase("true")) {
                    return string3;
                }
                if (string3.equalsIgnoreCase("false")) {
                    return string3;
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        FmtUtils.stringEsc(stringBuffer, string3, true);
        stringBuffer.append("\"");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("@");
            stringBuffer.append(string2);
        }
        if (string != null) {
            stringBuffer.append("^^");
            stringBuffer.append(FmtUtils.stringForURI(string, serializationContext));
        }
        return stringBuffer.toString();
    }

    public static String stringForString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        FmtUtils.stringEsc(stringBuffer, string, true);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static String stringForResource(Resource resource) {
        return FmtUtils.stringForResource(resource, new SerializationContext(null, (PrefixMapping)resource.getModel(), null));
    }

    public static String stringForResource(Resource resource, SerializationContext serializationContext) {
        return FmtUtils.stringForNode(resource.asNode(), serializationContext);
    }

    public static String stringForNode(Node node) {
        return FmtUtils.stringForNode(node, null);
    }

    public static String stringForNode(Node node, SerializationContext serializationContext) {
        if (node == null) {
            return "<<null>>";
        }
        if (node.isBlank()) {
            if (serializationContext == null) {
                return "[?]";
            }
            if (serializationContext.getBNodeMap() == null) {
                return "[??]";
            }
            return serializationContext.getBNodeMap().asString(node);
        }
        if (node.isLiteral()) {
            return FmtUtils.stringForLiteral((Node_Literal)node, serializationContext);
        }
        if (node.isURI()) {
            String string = node.getURI();
            return FmtUtils.stringForURI(string, serializationContext);
        }
        if (node.isVariable()) {
            if (node.getName().startsWith(Constants.anonVarMarker)) {
                return serializationContext.getBNodeMap().asString(node);
            }
            return "?" + node.getName();
        }
        return node.toString();
    }

    public static String stringForURI(String string, SerializationContext serializationContext) {
        if (serializationContext == null) {
            return FmtUtils.stringForURI(string, (PrefixMapping)null);
        }
        return FmtUtils.stringForURI(string, serializationContext.getPrefixMapping());
    }

    public static String stringForURI(String string, PrefixMapping prefixMapping) {
        String string2;
        if (prefixMapping != null && (string2 = prefixMapping.shortForm(string)) != null && !string2.equals(string)) {
            int n = string2.indexOf(58);
            if (n < 0) {
                throw new ARQInternalErrorException("Broken short form -- " + string2);
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (FmtUtils.checkValidPrefix(string3) && FmtUtils.checkValidLocalname(string4)) {
                return string2;
            }
        }
        return "<" + FmtUtils.stringEsc(string) + ">";
    }

    private static boolean checkValidPrefix(String string) {
        return true;
    }

    private static boolean checkValidLocalname(String string) {
        return !string.endsWith(".");
    }

    public static String stringEsc(String string) {
        return FmtUtils.stringEsc(string, true);
    }

    public static String stringEsc(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        FmtUtils.stringEsc(stringBuffer, string, bl);
        return stringBuffer.toString();
    }

    public static void stringEsc(StringBuffer stringBuffer, String string) {
        FmtUtils.stringEsc(stringBuffer, string, true);
    }

    public static void stringEsc(StringBuffer stringBuffer, String string, boolean bl) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (bl && (c == '\n' || c == '\r' || c == '\f')) {
                if (c == '\n') {
                    stringBuffer.append("\\n");
                }
                if (c == '\t') {
                    stringBuffer.append("\\t");
                }
                if (c == '\r') {
                    stringBuffer.append("\\r");
                }
                if (c != '\f') continue;
                stringBuffer.append("\\f");
                continue;
            }
            if (!applyUnicodeEscapes) {
                stringBuffer.append(c);
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            String string2 = Integer.toHexString(c).toUpperCase();
            stringBuffer.append("\\u");
            for (int j = 4 - string2.length(); j > 0; --j) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
        }
    }
}

