/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.hp.hpl.jena.query.Lock;
import com.hp.hpl.jena.shared.JenaException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockMRSW
implements Lock {
    static Log log = LogFactory.getLog((Class)LockMRSW.class);
    Map threadStates = new HashMap();
    int threadStatesSize = this.threadStates.size();
    WriterPreferenceReadWriteLock mrswLock = new WriterPreferenceReadWriteLock();
    SynchronizedInt activeReadLocks = new SynchronizedInt(0);
    SynchronizedInt activeWriteLocks = new SynchronizedInt(0);

    public LockMRSW() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock : " + Thread.currentThread().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterCriticalSection(boolean bl) {
        LockState lockState = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " >> enterCS: " + this.report(lockState)));
        }
        if (lockState.readLocks > 0 && lockState.writeLocks == 0 && !bl) {
            ++lockState.readLocks;
            this.activeReadLocks.increment();
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << enterCS: promotion attempt: " + this.report(lockState)));
            }
            throw new JenaException("enterCriticalSection: Write lock request while holding read lock - potential deadlock");
        }
        if (lockState.writeLocks > 0 && bl) {
            bl = false;
        }
        try {
            if (bl) {
                if (lockState.readLocks == 0) {
                    this.mrswLock.readLock().acquire();
                }
                ++lockState.readLocks;
                this.activeReadLocks.increment();
            } else {
                if (lockState.writeLocks == 0) {
                    this.mrswLock.writeLock().acquire();
                }
                ++lockState.writeLocks;
                this.activeWriteLocks.increment();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << enterCS: " + this.report(lockState)));
            }
        }
    }

    public final void leaveCriticalSection() {
        LockState lockState = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " >> leaveCS: " + this.report(lockState)));
        }
        try {
            if (lockState.readLocks > 0) {
                --lockState.readLocks;
                this.activeReadLocks.decrement();
                if (lockState.readLocks == 0) {
                    this.mrswLock.readLock().release();
                }
                lockState.clean();
                return;
            }
            if (lockState.writeLocks > 0) {
                --lockState.writeLocks;
                this.activeWriteLocks.decrement();
                if (lockState.writeLocks == 0) {
                    this.mrswLock.writeLock().release();
                }
                lockState.clean();
                return;
            }
            throw new JenaException("leaveCriticalSection: No lock held (" + Thread.currentThread().getName() + ")");
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << leaveCS: " + this.report(lockState)));
            }
        }
    }

    private String report(LockState lockState) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Thread R/W: ");
        stringBuffer.append(Integer.toString(lockState.readLocks));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toString(lockState.writeLocks));
        stringBuffer.append(" :: Model R/W: ");
        stringBuffer.append(Integer.toString(this.activeReadLocks.get()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toString(this.activeWriteLocks.get()));
        stringBuffer.append(" (thread: ");
        stringBuffer.append(lockState.thread.getName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    synchronized LockState getLockState() {
        Thread thread = Thread.currentThread();
        LockState lockState = (LockState)this.threadStates.get(thread);
        if (lockState == null) {
            lockState = new LockState(this);
            this.threadStates.put(thread, lockState);
            this.threadStatesSize = this.threadStates.size();
        }
        return lockState;
    }

    synchronized void removeLockState(Thread thread) {
        this.threadStates.remove(thread);
    }

    static class LockState {
        int readLocks = 0;
        int writeLocks = 0;
        LockMRSW lock;
        Thread thread;

        LockState(LockMRSW lockMRSW) {
            this.lock = lockMRSW;
            this.thread = Thread.currentThread();
        }

        void clean() {
            if (this.lock.activeReadLocks.get() == 0 && this.lock.activeWriteLocks.get() == 0) {
                this.lock.removeLockState(this.thread);
            }
        }
    }
}

