/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class NodeToLabelMap {
    int bNodeCounter = 0;
    Map bNodeStrings = new HashMap();
    boolean bNodesAsFakeURIs = false;
    String prefixString = "b";

    public NodeToLabelMap(String string, boolean bl) {
        this.bNodesAsFakeURIs = bl;
        this.prefixString = "_:" + string;
    }

    public String asString(Node node) {
        String string = (String)this.bNodeStrings.get(node);
        if (string != null) {
            return string;
        }
        if (this.bNodesAsFakeURIs && node.isBlank()) {
            string = "<_:" + node.getBlankNodeId().toString() + ">";
        } else {
            if (!node.isBlank() && !node.isVariable()) {
                LogFactory.getLog((Class)NodeToLabelMap.class).warn((Object)("Not a variable or bNode: " + node));
                return "";
            }
            string = this.prefixString + this.bNodeCounter++;
            this.bNodeStrings.put(node, string);
        }
        return string;
    }

    public boolean isBNodesAsFakeURIs() {
        return this.bNodesAsFakeURIs;
    }

    public void setBNodesAsFakeURIs(boolean bl) {
        this.bNodesAsFakeURIs = bl;
    }

    public String getPrefixString() {
        return this.prefixString;
    }

    public void setPrefixString(String string) {
        if (string == null) {
            LogFactory.getLog((Class)NodeToLabelMap.class).fatal((Object)"Prefix string is null");
            throw new ARQInternalErrorException("Prefix string is null");
        }
        if (string.equals("")) {
            LogFactory.getLog((Class)NodeToLabelMap.class).fatal((Object)"Prefix string is the empty string");
            throw new ARQInternalErrorException("Prefix string is the empty string");
        }
        this.prefixString = string;
    }
}

