/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;

public class NodeUtils {
    private static final int UNKNOWN = -99;

    public static int compareNodesByValue(Node node, Node node2) {
        int n = NodeUtils.compareNodesByKind(node, node2);
        if (n != -99) {
            return n;
        }
        return NodeUtils.compareLiteralsByValue(node, node2);
    }

    public static int compareNodesByKindTypeLexical(Node node, Node node2) {
        int n = NodeUtils.compareNodesByKind(node, node2);
        if (n != -99) {
            return n;
        }
        return NodeUtils.compareLiteralsLexical(node, node2);
    }

    private static int compareNodesByKind(Node node, Node node2) {
        if (node == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node.isBlank()) {
            if (node2.isBlank()) {
                String string = node.getBlankNodeId().toString();
                String string2 = node2.getBlankNodeId().toString();
                return string.compareTo(string2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node.isURI()) {
            if (node2.isURI()) {
                String string = node.getURI();
                String string3 = node2.getURI();
                return string.compareTo(string3);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        if (node.isLiteral() && node2.isLiteral()) {
            return -99;
        }
        throw new QueryException("Compare: " + node + "  " + node2);
    }

    private static int compareLiteralsByValue(Node node, Node node2) {
        NodeValue nodeValue = NodeValue.makeNode(node);
        NodeValue nodeValue2 = NodeValue.makeNode(node2);
        try {
            return NodeValue.compare(nodeValue, nodeValue2);
        }
        catch (ExprEvalException exprEvalException) {
            String string = nodeValue.asString();
            String string2 = nodeValue2.asString();
            return string.compareTo(string2);
        }
    }

    private static int compareLiteralsLexical(Node node, Node node2) {
        String string = node.getLiteralLexicalForm();
        String string2 = node2.getLiteralLexicalForm();
        String string3 = node.getLiteralDatatypeURI();
        String string4 = node2.getLiteralDatatypeURI();
        if (string3 != null || string4 == null) {
            // empty if block
        }
        if (string3 != null && string4 != null && string3.equals(string4)) {
            return string.compareTo(string2);
        }
        if (string3 == null || string4 == null) {
            int n = string2.compareTo(string2);
            if (n != 0) {
                return n;
            }
            if (string3 == null) {
                return -1;
            }
            if (string4 == null) {
                return 1;
            }
            throw new QueryException("Bug: one plain literal: " + node + " and " + node2);
        }
        int n = string.compareTo(string2);
        if (n != 0) {
            return n;
        }
        return string3.compareTo(string4);
    }
}

