/*
 * Decompiled with CFR 0.152.
 */
package SME2Plugin;

import SME2Plugin.PostProcessing;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.AbstractStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.IStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.impl.owlstc.simpack.XSNTFIDFDJacIOInfStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Utils;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import de.dfki.sme2.IMatchmakerPlugin;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SyntacticMatchmaker
implements IMatchmakerPlugin {
    protected Model model = ModelFactory.createDefaultModel();
    protected IStrategy strategy = new XSNTFIDFDJacIOInfStrategy();
    protected FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".owls");
        }
    };
    protected String queryStringQueryURL = String.valueOf(AbstractStrategy.prolog) + AbstractStrategy.NL + "SELECT ?service WHERE { ?service rdf:type service:Service }";
    protected String corpusFile = "OWLSTCv3_Corpus.ser";
    protected String serURL = null;
    private static Logger logger = Logger.getLogger(SyntacticMatchmaker.class);

    protected void matchmake(InputStream in, Hashtable<URL, Vector<URL>> results, URL queryPath) {
        Model queryModel = this.getQueryModel(in);
        String realQueryURL = this.getQueryURL(queryModel);
        System.out.println("Matchmaking: " + realQueryURL);
        ResultSet rs = this.getResults(queryModel, realQueryURL, this.strategy);
        System.out.println("Matchmaking Finish: " + realQueryURL);
        Vector<URL> thisResults = PostProcessing.transformResults(rs, this.serURL);
        results.put(queryPath, thisResults);
    }

    protected ResultSet getResults(Model queryModel, String queryURL, IStrategy strategy) {
        String queryString = strategy.getStrategy().replaceAll("<<<queryURL>>>", "<" + queryURL + ">");
        Query query = QueryFactory.create((String)queryString);
        query.serialize(new IndentedWriter((OutputStream)System.out, true));
        if (logger.isDebugEnabled()) {
            query.serialize(new IndentedWriter((OutputStream)System.out, true));
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.model);
        ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)qexec.execSelect());
        qexec.close();
        if (logger.isDebugEnabled()) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs, (Query)query);
            System.out.println("Size of result set: " + ResultSetFormatter.consume((ResultSet)rs));
        }
        return rs;
    }

    protected Model getService(URL serviceURL) {
        InputStream in = null;
        File file = new File(serviceURL.getFile());
        if (serviceURL.getProtocol().equals("http")) {
            try {
                in = serviceURL.openStream();
                this.model.read(in, "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (file.isFile()) {
                in = FileManager.get().open(file.toString());
                this.model.read(in, "");
            } else {
                String[] files = file.list(this.filter);
                if (files == null) {
                    logger.error((Object)("Error on readig " + file + " Aborting..."));
                    System.exit(0);
                }
                int i = 0;
                while (i < files.length) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("[ADD] " + (i + 1) + "/" + files.length + " " + file + "/" + files[i]);
                    }
                    in = FileManager.get().open(file + "/" + files[i]);
                    this.model.read(in, "");
                    ++i;
                }
            }
            if (logger.isDebugEnabled()) {
                this.model.write((OutputStream)System.out);
            }
        }
        return this.model;
    }

    protected String getQueryURL(Model queryModel) {
        RDFNode queryNode = null;
        Resource queryResource = null;
        String queryString = this.queryStringQueryURL;
        Query query = QueryFactory.create((String)queryString);
        if (logger.isDebugEnabled()) {
            query.serialize(new IndentedWriter((OutputStream)System.out, true));
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)queryModel);
        ResultSet rs = qexec.execSelect();
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            queryNode = rb.get("service");
            if (!queryNode.canAs(Resource.class)) continue;
            queryResource = (Resource)queryNode;
        }
        qexec.close();
        String queryResourceURI = queryResource.getURI();
        return queryResourceURI;
    }

    protected Model getQueryModel(InputStream in) {
        Model queryModel = ModelFactory.createDefaultModel();
        queryModel.read(in, "");
        return queryModel;
    }

    public static void main(String[] args) {
        SyntacticMatchmaker mm = new SyntacticMatchmaker();
        String queries = "file://" + Utils.userDir + Utils.separator + "data" + Utils.separator + "owls-tc3" + Utils.separator + "htdocs" + Utils.separator + "queries" + Utils.separator + "1.1" + Utils.separator + "book_price_service.owls";
        String services = "file://" + Utils.userDir + Utils.separator + "data" + Utils.separator + "owls-tc3" + Utils.separator + "htdocs" + Utils.separator + "services" + Utils.separator + "1.1" + Utils.separator;
        try {
            URL querURL = new URL(queries);
            URL serURL = new URL(services);
            mm.input(serURL);
            System.out.println("ok1");
            Hashtable<URL, Vector<URL>> results = mm.query(querURL);
            System.out.println("ok");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void input(URL arg0) {
        if (this.serURL == null) {
            this.serURL = arg0.getFile();
        }
        this.model = this.getService(arg0);
    }

    public Hashtable<URL, Vector<URL>> query(URL queryURL) {
        InputStream in;
        Hashtable<URL, Vector<URL>> results = new Hashtable<URL, Vector<URL>>();
        String querystr = queryURL.getFile();
        System.out.println("queryURL format: *****\u3000" + queryURL.toString());
        File file = new File(querystr);
        if (queryURL.getProtocol().equals("http")) {
            try {
                in = queryURL.openStream();
                this.matchmake(in, results, queryURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (file.isFile()) {
            in = FileManager.get().open(file.toString());
            this.matchmake(in, results, queryURL);
        } else {
            String[] files = file.list(this.filter);
            if (files == null) {
                logger.error((Object)("Error on readig " + file + " Aborting..."));
                System.exit(0);
            }
            int i = 0;
            while (i < files.length) {
                logger.debug((Object)("Read " + file + "/" + files[i]));
                InputStream in2 = FileManager.get().open(file + "/" + files[i]);
                this.matchmake(in2, results, queryURL);
                ++i;
            }
        }
        Set querySet = results.keySet();
        for (URL url : querySet) {
            System.out.println("query url:" + url.toString());
            System.out.println("service url:" + results.get(url).get(0).toString());
        }
        return results;
    }
}

