/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.MachineLearning;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.OWLSTCv3RelevanceSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Set;

public class svmDataGeneration {
    public String[] strategies = null;
    public String trainFile = null;
    public String testFile = null;
    public Hashtable<String, Hashtable<String, Hashtable<String, Double>>> datamodel = null;
    private String path = ".\\data\\owlstc3similarity\\";
    private String modelpath = ".\\data\\modeldata\\";
    private OWLSTCv3RelevanceSet relevanceSet = new OWLSTCv3RelevanceSet(".\\data\\owls-tc3\\owls-tc3.xml");

    public svmDataGeneration(String trainFile, String testFile) {
        File strategyFile = new File(this.path);
        if (strategyFile.isDirectory()) {
            File[] files = strategyFile.listFiles();
            this.strategies = new String[files.length];
            int i = 0;
            while (i < files.length) {
                this.strategies[i] = files[i].getName();
                ++i;
            }
        }
        this.trainFile = trainFile;
        this.testFile = testFile;
    }

    public void GenerateTrainData(String testQuery, String[] pickStrategies) {
        File train = new File(String.valueOf(this.modelpath) + this.trainFile + "_" + testQuery);
        File test = new File(String.valueOf(this.modelpath) + this.testFile + "_" + testQuery);
        PrintWriter trainwriter = null;
        PrintWriter testwriter = null;
        Set<String> serviceSet = null;
        try {
            trainwriter = new PrintWriter(train);
            testwriter = new PrintWriter(test);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (this.datamodel == null) {
            System.out.println("Please generate data model first");
        } else {
            Set<String> querySet = this.datamodel.get(pickStrategies[0]).keySet();
            for (String query : querySet) {
                int i;
                String vector;
                if (serviceSet == null) {
                    serviceSet = this.datamodel.get(pickStrategies[0]).get(query).keySet();
                }
                if (query.equals(testQuery)) {
                    for (String ser : serviceSet) {
                        vector = "";
                        vector = this.relevanceSet.relevanceSetContainsName(query, ser) ? String.valueOf(vector) + "1" : String.valueOf(vector) + "0";
                        i = 0;
                        while (i < pickStrategies.length) {
                            vector = String.valueOf(vector) + " " + (i + 1) + ":" + this.datamodel.get(this.strategies[i]).get(query).get(ser).toString();
                            ++i;
                        }
                        testwriter.println(vector);
                        testwriter.flush();
                    }
                    continue;
                }
                for (String ser : serviceSet) {
                    vector = "";
                    vector = this.relevanceSet.relevanceSetContainsName(query, ser) ? String.valueOf(vector) + "1" : String.valueOf(vector) + "0";
                    i = 0;
                    while (i < pickStrategies.length) {
                        vector = String.valueOf(vector) + " " + (i + 1) + ":" + this.datamodel.get(this.strategies[i]).get(query).get(ser).toString();
                        ++i;
                    }
                    trainwriter.println(vector);
                    testwriter.flush();
                }
            }
        }
        testwriter.close();
        trainwriter.close();
    }

    public void GenerateTrainDataNew(String testQuery, String[] pickStrategies) {
        File train = new File(String.valueOf(this.modelpath) + testQuery);
        PrintWriter trainwriter = null;
        Set<String> serviceSet = null;
        try {
            trainwriter = new PrintWriter(train);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (this.datamodel == null) {
            System.out.println("Please generate data model first");
        } else {
            Set<String> querySet = this.datamodel.get(pickStrategies[0]).keySet();
            for (String query : querySet) {
                if (serviceSet == null) {
                    serviceSet = this.datamodel.get(pickStrategies[0]).get(query).keySet();
                }
                for (String ser : serviceSet) {
                    String vector = "";
                    vector = this.relevanceSet.relevanceSetContainsName(query, ser) ? String.valueOf(vector) + "1" : String.valueOf(vector) + "0";
                    int i = 0;
                    while (i < pickStrategies.length) {
                        vector = String.valueOf(vector) + " " + (i + 1) + ":" + this.datamodel.get(this.strategies[i]).get(query).get(ser).toString();
                        ++i;
                    }
                    trainwriter.println(vector);
                }
            }
        }
        trainwriter.close();
    }

    public void generateDataModel() {
        this.datamodel = new Hashtable();
        int i = 0;
        while (i < this.strategies.length) {
            String strategyName = this.strategies[i];
            Hashtable<String, Hashtable<String, Double>> results = new Hashtable<String, Hashtable<String, Double>>();
            File strategyFile = new File(String.valueOf(this.path) + strategyName);
            if (strategyFile.isDirectory()) {
                File[] queryFiles = strategyFile.listFiles();
                int j = 0;
                while (j < queryFiles.length) {
                    File query = queryFiles[j];
                    Hashtable<String, Double> matchResult = new Hashtable<String, Double>();
                    this.readFile(matchResult, query);
                    String queryName = query.getName();
                    results.put(queryName.substring(0, queryName.length()), matchResult);
                    ++j;
                }
            }
            this.datamodel.put(strategyName, results);
            ++i;
        }
    }

    public void readFile(Hashtable<String, Double> result, File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    int index = line.indexOf(":");
                    String servicename = line.substring(0, index);
                    Double value = new Double(line.substring(index + 1));
                    result.put(servicename, value);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        svmDataGeneration dataGeneration = new svmDataGeneration("owlstc3", "test1");
        dataGeneration.generateDataModel();
        String[] pickStrategies = new String[]{"TFIDFDStrategy", "JaccardInInferredStrategy", "JaccardOutInferredStrategy"};
        File queries = new File(".\\data\\owls-tc3\\htdocs\\queries\\1.1");
        String[] querynames = null;
        dataGeneration.GenerateTrainDataNew("owlstc3", pickStrategies);
    }
}

