/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import java.io.BufferedWriter;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BuildWekaFile {
    private String relation;
    private LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private Hashtable<String, Vector<String>> data = new Hashtable();

    public BuildWekaFile(String relation) {
        this.relation = relation;
    }

    public void addAttribute(String name, String type) {
        this.attributes.put(name, type);
    }

    public void clearData() {
        this.data = new Hashtable();
    }

    public void addData(String instance, String d) {
        if (this.data.containsKey(instance)) {
            this.data.get(instance).add(d);
        } else {
            Vector<String> dat = new Vector<String>();
            dat.add(d);
            this.data.put(instance, dat);
        }
    }

    public void appendFile(BufferedWriter out) throws Exception {
        this.appendHeader(out);
        this.appendData(out);
    }

    public void writeFile(PrintStream out) {
        this.writeHeader(out);
        this.writeData(out);
    }

    public void writeHeader(PrintStream out) {
        out.print("@RELATION " + this.relation + "\n\n");
        Set<Map.Entry<String, String>> set = this.attributes.entrySet();
        for (Map.Entry<String, String> entry : set) {
            out.print("@ATTRIBUTE " + entry.getKey() + " " + entry.getValue() + "\n");
        }
        out.print("\n");
    }

    public void appendHeader(BufferedWriter out) throws Exception {
        out.write("@RELATION " + this.relation + "\n\n");
        Set<Map.Entry<String, String>> set = this.attributes.entrySet();
        for (Map.Entry<String, String> entry : set) {
            out.write("@ATTRIBUTE " + entry.getKey() + " " + entry.getValue() + "\n");
        }
        out.write("\n");
        out.write("@DATA\n");
    }

    public void writeData(PrintStream out) {
        out.print("@DATA\n");
        Set<Map.Entry<String, Vector<String>>> set = this.data.entrySet();
        for (Map.Entry<String, Vector<String>> entry : set) {
            Vector<String> values = entry.getValue();
            int length = values.size();
            int i = 0;
            while (i < length - 1) {
                out.print(String.valueOf(values.get(i)) + ",");
                ++i;
            }
            out.print(String.valueOf(values.get(length - 1)) + "\n");
        }
    }

    public void appendData(BufferedWriter out) throws Exception {
        Set<Map.Entry<String, Vector<String>>> set = this.data.entrySet();
        for (Map.Entry<String, Vector<String>> entry : set) {
            Vector<String> values = entry.getValue();
            int length = values.size();
            int i = 0;
            while (i < length - 1) {
                out.write(String.valueOf(values.get(i)) + ",");
                ++i;
            }
            out.write(String.valueOf(values.get(length - 1)) + "\n");
        }
    }

    public void addDataLibSVM(String instance, String d) {
        if (this.data.containsKey(instance)) {
            this.data.get(instance).add(0, d);
        } else {
            Vector<String> dat = new Vector<String>();
            dat.add(0, d);
            this.data.put(instance, dat);
        }
    }

    public void appendDataLibSVM(BufferedWriter out) throws Exception {
        Set<Map.Entry<String, Vector<String>>> set = this.data.entrySet();
        for (Map.Entry<String, Vector<String>> entry : set) {
            Vector<String> values = entry.getValue();
            int length = values.size();
            out.write(String.valueOf(values.get(0)) + " ");
            int i = 1;
            while (i < length - 1) {
                out.write(String.valueOf(i) + ":" + values.get(i) + " ");
                ++i;
            }
            out.write(String.valueOf(length - 1) + ":" + values.get(length - 1) + "\n");
        }
    }
}

