/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.AtomicExpression;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.service.Service;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SameIndividualAtom;

public class ConditionTools {
    private static Logger logger;
    private static OWLKnowledgeBase kb;
    private static String userDir;
    private static String sep;
    private static String ontSet;
    public static String serviceConditionCacheName;
    public static Hashtable<String, Hashtable<String, Vector<AtomicExpression>>> serviceConditionCache;
    public static String serviceInterfaceCacheName;
    public static Hashtable<String, Hashtable<String, HashMap<String, String>>> serviceInterfaceCache;

    static {
        ObjectInputStream in;
        File file;
        logger = Logger.getLogger(ConditionTools.class);
        kb = null;
        userDir = Utils.userDir;
        sep = Utils.separator;
        ontSet = null;
        serviceConditionCacheName = "serviceConditionCache.ser";
        serviceInterfaceCacheName = "serviceInterfaceCache.ser";
        try {
            file = new File(serviceConditionCacheName);
            in = new ObjectInputStream(new FileInputStream(file));
            serviceConditionCache = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            serviceConditionCache = new Hashtable();
        }
        try {
            file = new File(serviceInterfaceCacheName);
            in = new ObjectInputStream(new FileInputStream(file));
            serviceInterfaceCache = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            serviceInterfaceCache = new Hashtable();
        }
    }

    public static HashMap<String, String> getInterfaceParameters(String servicename, Service service, String parameterType) {
        if (serviceInterfaceCache.containsKey(servicename)) {
            if (serviceInterfaceCache.get(servicename).containsKey(parameterType)) {
                return serviceInterfaceCache.get(servicename).get(parameterType);
            }
            HashMap<String, String> map = null;
            if (parameterType.equals("input")) {
                map = ConditionTools.getURIList(service.getProfile().getInputs());
            } else if (parameterType.equals("output")) {
                map = ConditionTools.getURIList(service.getProfile().getOutputs());
            }
            serviceInterfaceCache.get(servicename).put(parameterType, map);
            try {
                ConditionTools.serializeServiceInterfaceCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return map;
        }
        Hashtable<String, HashMap<String, String>> table = new Hashtable<String, HashMap<String, String>>();
        HashMap<String, String> map = null;
        if (parameterType.equals("input")) {
            map = ConditionTools.getURIList(service.getProfile().getInputs());
        } else if (parameterType.equals("output")) {
            map = ConditionTools.getURIList(service.getProfile().getOutputs());
        }
        table.put(parameterType, map);
        serviceInterfaceCache.put(servicename, table);
        try {
            ConditionTools.serializeServiceInterfaceCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Vector<AtomicExpression> getProcessCondition(String servicename, String type) {
        if (serviceConditionCache.containsKey(servicename)) {
            if (serviceConditionCache.get(servicename).containsKey(type)) {
                return serviceConditionCache.get(servicename).get(type);
            }
            System.out.println(String.valueOf(servicename) + ": does not exist " + type + " condition");
            return null;
        }
        logger.debug((Object)("Cache miss for service " + servicename));
        System.out.println(String.valueOf(servicename) + ": does not exist " + type + " service");
        return null;
    }

    public static Vector<AtomicExpression> getProcessConditions(String servicename, Service service, String type) {
        if (serviceConditionCache.containsKey(servicename)) {
            if (serviceConditionCache.get(servicename).containsKey(type)) {
                return serviceConditionCache.get(servicename).get(type);
            }
            Vector<AtomicExpression> vec = ConditionTools.getConditions(service, type);
            serviceConditionCache.get(servicename).put(type, vec);
            try {
                ConditionTools.serializeServiceConditionCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return vec;
        }
        logger.debug((Object)("Cache miss for service " + servicename));
        Vector<AtomicExpression> vec = ConditionTools.getConditions(service, type);
        Hashtable<String, Vector<AtomicExpression>> table = new Hashtable<String, Vector<AtomicExpression>>();
        table.put(type, vec);
        serviceConditionCache.put(servicename, table);
        try {
            ConditionTools.serializeServiceConditionCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vec;
    }

    public static AtomicExpression HandleAtom(Atom atom) {
        AtomicExpression atomExpr = null;
        IndividualPropertyAtom propertyAtom = null;
        DataPropertyAtom dataAtom = null;
        ClassAtom classAtom = null;
        Object atomType = null;
        OWLClass atomClassType = kb.createClass(URI.create("http://www.w3.org/2003/11/swrl#ClassAtom"));
        OWLClass individualPropertyAtomType = kb.createClass(URI.create("http://www.w3.org/2003/11/swrl#IndividualPropertyAtom"));
        OWLClass differentIndividualsAtomType = kb.createClass(URI.create("http://www.w3.org/2003/11/swrl#DifferentIndividualsAtom"));
        OWLClass sameIndividualAtomType = kb.createClass(URI.create("http://www.w3.org/2003/11/swrl#SameIndividualAtom"));
        OWLClass datavaluedPropertyAtomType = kb.createClass(URI.create("http://www.w3.org/2003/11/swrl#DatavaluedPropertyAtom"));
        if (atom.isType(individualPropertyAtomType)) {
            atomExpr = new AtomicExpression(1);
            propertyAtom = (IndividualPropertyAtom)atom;
            OWLIndividual obj = atom.getProperty(SWRL.propertyPredicate);
            atomExpr.setArgument1(propertyAtom.getArgument1().getURI().toString());
            atomExpr.setArgument2(propertyAtom.getArgument2().getURI().toString());
            atomExpr.setPredicate(obj.toString());
            System.out.println(String.valueOf(obj.toString()) + "(" + propertyAtom.getArgument1().getURI().toString() + ")" + propertyAtom.getArgument2().getURI().toString());
        } else if (atom.isType(differentIndividualsAtomType)) {
            atomExpr = new AtomicExpression(2);
            DifferentIndividualsAtom diffAtom = (DifferentIndividualsAtom)atom;
            System.out.println("DifferentIndividuals:");
            atomExpr.setArgument1(diffAtom.getArgument1().getURI().toString());
            atomExpr.setArgument2(diffAtom.getArgument2().getURI().toString());
        } else if (atom.isType(sameIndividualAtomType)) {
            atomExpr = new AtomicExpression(3);
            SameIndividualAtom sameAtom = (SameIndividualAtom)atom;
            System.out.println("DifferentIndividuals:");
            atomExpr.setArgument1(sameAtom.getArgument1().getURI().toString());
            atomExpr.setArgument2(sameAtom.getArgument2().getURI().toString());
        } else if (atom.isType(datavaluedPropertyAtomType)) {
            atomExpr = new AtomicExpression(4);
            dataAtom = (DataPropertyAtom)atom;
            OWLIndividual obj = atom.getProperty(SWRL.propertyPredicate);
            atomExpr.setArgument1(dataAtom.getArgument1().getURI().toString());
            atomExpr.setArgument2(dataAtom.getArgument2().toString());
            atomExpr.setPredicate(obj.toString());
        } else if (atom.isType(atomClassType)) {
            atomExpr = new AtomicExpression(0);
            classAtom = (ClassAtom)atom;
            OWLIndividual obj = atom.getProperty(SWRL.classPredicate);
            atomExpr.setPredicate(obj.toString());
            atomExpr.setArgument1(classAtom.getArgument1().getURI().toString());
        }
        return atomExpr;
    }

    public static HashMap<String, String> getURIList(OWLIndividualList resourcen) {
        Iterator iter = resourcen.iterator();
        HashMap<String, String> urilist = new HashMap<String, String>();
        while (iter.hasNext()) {
            Parameter pare = (Parameter)iter.next();
            urilist.put(pare.getURI().toString(), pare.getParamType().getURI().toString());
        }
        return urilist;
    }

    private static Vector<AtomicExpression> getConditions(Service service, String type) {
        Vector<AtomicExpression> vec = new Vector<AtomicExpression>();
        try {
            Expression expr;
            Result result;
            Process process = service.getProcess();
            Condition con = null;
            AtomList list = null;
            if (type.equals("precondition")) {
                con = process.getCondition();
                if (con != null) {
                    list = con.getBody();
                }
            } else if (type.equals("effect") && (result = process.getResult()) != null && (expr = result.getEffect()) != null) {
                list = expr.getBody();
            }
            boolean n = false;
            if (list != null) {
                while (!list.isEmpty()) {
                    Atom indi = list.getFirst();
                    vec.add(ConditionTools.HandleAtom(indi));
                    list = list.getRest();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vec;
    }

    public static void serializeServiceConditionCache() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(serviceConditionCacheName));
        out.writeObject(serviceConditionCache);
        out.close();
    }

    public static void serializeServiceInterfaceCache() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(serviceInterfaceCacheName));
        out.writeObject(serviceInterfaceCache);
        out.close();
    }

    public static void print(Vector<AtomicExpression> vec) {
        int i = 0;
        while (i < vec.size()) {
            AtomicExpression expr = vec.get(i);
            System.out.println(String.valueOf(expr.getPredicate()) + ":" + "(" + expr.getArgument1() + "," + expr.getArgument2() + ")");
            ++i;
        }
    }

    public static void printHashMap(HashMap<String, String> map) {
        Set<Map.Entry<String, String>> enSet = map.entrySet();
        for (Map.Entry<String, String> en : enSet) {
            System.out.println(String.valueOf(en.getKey()) + ":" + en.getValue());
        }
    }

    public static void main(String[] args) {
        int num = 0;
        ConditionTools tool = new ConditionTools();
        File filefolder = new File("F:\\workspace\\owls-iMatcher\\data\\OWLS-TC4_SWRL\\htdocs\\queries\\1.1\\");
        String servicename = null;
        if (filefolder.isDirectory()) {
            File[] files = filefolder.listFiles();
            int i = 0;
            while (i < (files.length > 200 ? 200 : files.length)) {
                servicename = "http://127.0.0.1/queries/1.1/" + files[i].getName();
                System.out.println(String.valueOf(i) + " :" + servicename);
                kb = OWLFactory.createKB();
                kb.setReasoner("RDFS");
                URI uri = null;
                Service service = null;
                try {
                    uri = new URI(servicename);
                    service = kb.readService(uri);
                    Vector<AtomicExpression> processPreConditions = ConditionTools.getConditions(service, "precondition");
                    Vector<AtomicExpression> processEffect = ConditionTools.getProcessConditions(servicename, service, "effect");
                    HashMap<String, String> inputParamter = ConditionTools.getInterfaceParameters(servicename, service, "input");
                    HashMap<String, String> outputParamter = ConditionTools.getInterfaceParameters(servicename, service, "output");
                    if (processPreConditions.isEmpty() && processEffect.isEmpty()) {
                        ++num;
                    } else {
                        System.out.println("precondition:");
                        ConditionTools.print(processPreConditions);
                        System.out.println("effect:");
                        ConditionTools.print(processEffect);
                        System.out.println("Input:");
                        ConditionTools.printHashMap(inputParamter);
                        System.out.println("Output:");
                        ConditionTools.printHashMap(outputParamter);
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                service.delete();
                kb = null;
                ++i;
            }
            System.out.println(num);
        }
    }
}

