/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.IStrategy;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Vector;
import owlsmx.similaritymeasures.SimilarityMeasure;

public class Gnuplotter {
    private static String evalFile = "eval.gp";

    public static void makeMicroAveragingEvalScript(Vector<IStrategy> strategies, String title) {
        Gnuplotter.makeMicroAveragingEvalScript(strategies, title, evalFile);
    }

    public static void makeMicroAveragingEvalScript(Vector<IStrategy> strategies, String title, String evalFile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(evalFile));
            out.write("set terminal postscript eps enhanced color solid\n");
            out.write("set out 'pre-rec.eps'\n");
            out.write("set title '" + title + "'\n");
            out.write("set key out vert box\n");
            out.write("set key bottom center\n");
            out.write("set size ratio -1\n");
            out.write("set xlabel 'Recall'\n");
            out.write("set ylabel 'Precision'\n");
            out.write("set yrange [0:1]\n");
            out.write("set xrange [0:1]\n");
            out.write("set xtics 0.0,0.1,1.0\n");
            out.write("set mxtic 2\n");
            out.write("set ytics 0.0,0.1,1.0\n");
            out.write("set mytic 2\n");
            int length = strategies.size();
            int i = 1;
            while (i <= length) {
                out.write("set style line " + i + " lt " + i + " lw 3 ps 1\n");
                ++i;
            }
            out.write("plot ");
            i = 0;
            while (i < length) {
                if (i != length - 1) {
                    out.write("\"pre-rec-" + strategies.get(i).getName() + ".dat\"" + " w linesp ls " + (i + 1) + " t " + "\"" + strategies.get(i).getShortName() + " (" + (i + 1) + ")" + "\"" + ", ");
                } else {
                    out.write("\"pre-rec-" + strategies.get(i).getName() + ".dat\"" + " w linesp ls " + (i + 1) + " t " + "\"" + strategies.get(i).getShortName() + " (" + (i + 1) + ")" + "\"");
                }
                ++i;
            }
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void makeMicroAveragingOWLSMXEvalScript(Vector<SimilarityMeasure> strategies, String title, int minDegree, double minSim) {
        Gnuplotter.makeMicroAveragingOWLSMXEvalScript(strategies, title, minDegree, minSim, evalFile);
    }

    public static void makeMicroAveragingOWLSMXEvalScript(Vector<SimilarityMeasure> strategies, String title, int minDegree, double minSim, String evalFile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(evalFile));
            out.write("set terminal postscript eps enhanced color solid\n");
            out.write("set out 'pre-rec.eps'\n");
            out.write("set title '" + title + "'\n");
            out.write("set key out vert box\n");
            out.write("set key bottom center\n");
            out.write("set size ratio -1\n");
            out.write("set xlabel 'Recall'\n");
            out.write("set ylabel 'Precision'\n");
            out.write("set yrange [0:1]\n");
            out.write("set xrange [0:1]\n");
            out.write("set xtics 0.0,0.1,1.0\n");
            out.write("set mxtic 2\n");
            out.write("set ytics 0.0,0.1,1.0\n");
            out.write("set mytic 2\n");
            int length = strategies.size();
            int i = 1;
            while (i <= length) {
                out.write("set style line " + i + " lt " + i + " lw 3 ps 1\n");
                ++i;
            }
            out.write("plot ");
            i = 0;
            while (i < length) {
                if (i != length - 1) {
                    out.write("\"pre-rec-" + strategies.get(i).getName() + "-" + minDegree + "-" + minSim + ".dat\"" + " w linesp ls " + (i + 1) + " t " + "\"" + strategies.get(i).getName() + "-" + minDegree + "-" + minSim + "\"" + ", ");
                } else {
                    out.write("\"pre-rec-" + strategies.get(i).getName() + "-" + minDegree + "-" + minSim + ".dat\"" + " w linesp ls " + (i + 1) + " t " + "\"" + strategies.get(i).getName() + "-" + minDegree + "-" + minSim + "\"");
                }
                ++i;
            }
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void makePrecisionHistogramEvalScript(Vector<IStrategy> strategies, Vector<Double> rpA, Vector<Double> rpB, String title) {
        Gnuplotter.makePrecisionHistogramEvalScript(strategies, rpA, rpB, title, evalFile);
    }

    public static void makePrecisionHistogramEvalScript(Vector<IStrategy> strategies, Vector<Double> rpA, Vector<Double> rpB, String title, String evalFile) {
        evalFile = "eval-phist-" + strategies.get(0).getShortName() + "vs" + strategies.get(1).getShortName() + ".gp";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(evalFile));
            out.write("set terminal postscript eps enhanced color solid\n");
            out.write("set out 'phist-" + strategies.get(0).getShortName() + "vs" + strategies.get(1).getShortName() + ".eps'\n");
            out.write("set key top left\n");
            out.write("set title '" + title + "'\n");
            out.write("set xlabel 'Query Number'\n");
            out.write("set ylabel 'R-Precision " + strategies.get(0).getShortName() + "/" + strategies.get(1).getShortName() + "\n");
            out.write("set autoscale\n");
            out.write("set style data histograms\n");
            out.write("set style fill solid border -1\n");
            out.write("set style histogram clustered gap 1\n");
            out.write("plot ");
            out.write("'precision-histogram-" + strategies.get(0).getShortName() + "_" + strategies.get(1).getShortName() + ".dat'" + " using 4:xtic(1) ti col");
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void makePrecisionHistogramEvalScript2(Vector<IStrategy> strategies, Vector<Double> rpA, Vector<Double> rpB, String title) {
        Gnuplotter.makePrecisionHistogramEvalScript2(strategies, rpA, rpB, title, evalFile);
    }

    public static void makePrecisionHistogramEvalScript2(Vector<IStrategy> strategies, Vector<Double> rpA, Vector<Double> rpB, String title, String evalFile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(evalFile));
            out.write("set terminal postscript eps enhanced color solid\n");
            out.write("set out 'phist-" + strategies.get(0).getShortName() + "vs" + strategies.get(1).getShortName() + ".eps'\n");
            out.write("set key top left\n");
            out.write("set title '" + title + "'\n");
            out.write("set xlabel 'Query Number'\n");
            out.write("set ylabel 'R-Precision " + strategies.get(0).getShortName() + "/" + strategies.get(1).getShortName() + "\n");
            out.write("set autoscale\n");
            out.write("set style data histograms\n");
            out.write("set style fill solid border -1\n");
            out.write("set style histogram clustered gap 1\n");
            out.write("plot ");
            out.write("'precision-histogram-" + strategies.get(0).getShortName() + "_" + strategies.get(1).getShortName() + ".dat'" + " using 2:xtic(1) ti col, '' u 3 ti col");
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

