/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.reasonerfactory.pellet.PelletReasonerFactory;
import simpack.measure.it.Lin;
import simpack.measure.it.Resnik;
import simpack.measure.set.Dice;
import simpack.measure.set.Jaccard;
import simpack.measure.set.LOI;
import simpack.measure.set.Resembalance;

public class Reasoning {
    private static String userDir = Utils.userDir;
    private static String sep = Utils.separator;
    private static String ontSet = "file://" + userDir + sep + "data" + sep + "OWLS-TC4_SWRL" + sep + "htdocs" + sep + "ontology";
    public static Hashtable<String, OWLOntology> ontbase = new Hashtable();
    public static OWLReasoner reasoner = null;
    public static OWLOntologyManager manager = null;
    public static int numberofallClass;
    public static String uriAncestorsCacheName;
    public static Hashtable<String, String> uriAncestorsCache;

    static {
        uriAncestorsCacheName = "uriAncestorsCache.ser";
        try {
            System.out.println("------------" + uriAncestorsCacheName);
            File file = new File(uriAncestorsCacheName);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            uriAncestorsCache = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            uriAncestorsCache = new Hashtable();
        }
        OWLOntology onto = null;
        HashSet<OWLOntology> ontologySet = new HashSet<OWLOntology>();
        manager = OWLManager.createOWLOntologyManager();
        try {
            URL fileURL = new URL(ontSet);
            File file = new File(fileURL.getFile());
            if (file.isDirectory()) {
                File[] ontfiles = file.listFiles();
                int i = 0;
                while (i < 25) {
                    File ontfile = ontfiles[i];
                    URI onturi = ontfile.toURI();
                    try {
                        onto = manager.loadOntologyFromPhysicalURI(onturi);
                        String filename = "http://127.0.0.1/ontology/" + ontfile.getName();
                        ontologySet.add(onto);
                    }
                    catch (OWLOntologyCreationException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            PelletReasonerFactory reasonerFactory = new PelletReasonerFactory();
            reasoner = reasonerFactory.createReasoner(manager);
            try {
                reasoner.loadOntologies(ontologySet);
                System.out.println("classify ontologies......");
                reasoner.classify();
                System.out.println("classify finish.");
                OWLClass thingClass = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Thing"));
                numberofallClass = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getDescendantClasses((OWLDescription)thingClass)).size();
            }
            catch (OWLReasonerException e1) {
                e1.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void init() {
    }

    public static double getSimilarityNew(String request, String service, boolean alignFlag, String estimateMeasure) {
        double sim = 0.0;
        double alignsim = 0.0;
        OWLClass reqClass = manager.getOWLDataFactory().getOWLClass(URI.create(request));
        OWLClass serClass = manager.getOWLDataFactory().getOWLClass(URI.create(service));
        OWLClass thingClass = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Thing"));
        OWLClass nothingClass = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Nothing"));
        if (reqClass.equals(serClass)) {
            return 1.0;
        }
        try {
            Set reqSupSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)reqClass));
            reqSupSet.remove(thingClass);
            Set serSupSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)serClass));
            serSupSet.remove(thingClass);
            HashSet commonSet = new HashSet(reqSupSet);
            commonSet.retainAll(serSupSet);
            Set reqSubSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getDescendantClasses((OWLDescription)reqClass));
            reqSubSet.remove(nothingClass);
            Set serSubSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getDescendantClasses((OWLDescription)serClass));
            serSubSet.remove(nothingClass);
            if (reqSubSet.contains(serClass) || serSupSet.contains(reqClass)) {
                sim = 1.0;
            } else if (serSubSet.contains(reqClass) || reqSupSet.contains(serClass) || commonSet.size() > 0) {
                if (estimateMeasure.equals("Jaccard")) {
                    Jaccard jac = new Jaccard(reqSupSet, serSupSet);
                    if (jac.calculate()) {
                        sim = jac.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Dice")) {
                    Dice dic = new Dice(reqSupSet, serSupSet);
                    if (dic.calculate()) {
                        sim = dic.getSimilarity();
                    }
                } else if (estimateMeasure.equals("LOI")) {
                    LOI loi = new LOI(reqSupSet, serSupSet);
                    if (loi.calculate()) {
                        sim = loi.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Resembalance")) {
                    Resembalance resembalance = new Resembalance(reqSupSet, serSupSet);
                    if (resembalance.calculate()) {
                        sim = resembalance.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Rensik")) {
                    Resnik resnik = new Resnik((double)commonSet.size(), (double)numberofallClass);
                    if (resnik.calculate()) {
                        sim = resnik.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Lin")) {
                    int numberofreq = reqSupSet.size() + reqSubSet.size() + 1;
                    int numberofser = serSupSet.size() + serSupSet.size() + 1;
                    if (commonSet.size() == 0) {
                        sim = 0.0;
                    } else {
                        Lin lin = new Lin((double)numberofallClass, (double)commonSet.size(), (double)numberofreq, (double)numberofser);
                        if (lin.calculate()) {
                            sim = lin.getSimilarity();
                        }
                    }
                }
            }
        }
        catch (OWLReasonerException e) {
            e.printStackTrace();
        }
        if (sim > alignsim) {
            return sim;
        }
        return alignsim;
    }

    public static double getSimilarity(String request, String service, boolean alignFlag, String estimateMeasure) {
        double sim = 0.0;
        double alignsim = 0.0;
        OWLClass reqClass = manager.getOWLDataFactory().getOWLClass(URI.create(request));
        OWLClass serClass = manager.getOWLDataFactory().getOWLClass(URI.create(service));
        OWLClass thingClass = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Thing"));
        OWLClass nothingClass = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Nothing"));
        if (reqClass.equals(serClass)) {
            return 1.0;
        }
        try {
            Set reqSupSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)reqClass));
            reqSupSet.remove(thingClass);
            Set serSupSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)serClass));
            serSupSet.remove(thingClass);
            HashSet commonSet = new HashSet(reqSupSet);
            commonSet.retainAll(serSupSet);
            Set reqSubSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getDescendantClasses((OWLDescription)reqClass));
            reqSubSet.remove(nothingClass);
            Set serSubSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getDescendantClasses((OWLDescription)serClass));
            serSubSet.remove(nothingClass);
            if (reqSubSet.contains(serClass) || serSupSet.contains(reqClass)) {
                sim = 1.0;
            } else if (serSubSet.contains(reqClass) || reqSupSet.contains(serClass) || commonSet.size() > 0) {
                if (estimateMeasure.equals("Jaccard")) {
                    Jaccard jac = new Jaccard(reqSupSet, serSupSet);
                    if (jac.calculate()) {
                        sim = jac.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Dice")) {
                    Dice dic = new Dice(reqSupSet, serSupSet);
                    if (dic.calculate()) {
                        sim = dic.getSimilarity();
                    }
                } else if (estimateMeasure.equals("LOI")) {
                    LOI loi = new LOI(reqSupSet, serSupSet);
                    if (loi.calculate()) {
                        sim = loi.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Resembalance")) {
                    Resembalance resembalance = new Resembalance(reqSupSet, serSupSet);
                    if (resembalance.calculate()) {
                        sim = resembalance.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Rensik")) {
                    Resnik resnik = new Resnik((double)commonSet.size(), (double)numberofallClass);
                    if (resnik.calculate()) {
                        sim = resnik.getSimilarity();
                    }
                } else if (estimateMeasure.equals("Lin")) {
                    int numberofreq = reqSupSet.size() + reqSubSet.size() + 1;
                    int numberofser = serSupSet.size() + serSupSet.size() + 1;
                    if (commonSet.size() == 0) {
                        sim = 0.0;
                    } else {
                        Lin lin = new Lin((double)numberofallClass, (double)commonSet.size(), (double)numberofreq, (double)numberofser);
                        if (lin.calculate()) {
                            sim = lin.getSimilarity();
                        }
                    }
                }
            }
        }
        catch (OWLReasonerException e) {
            e.printStackTrace();
        }
        if (sim > alignsim) {
            return sim;
        }
        return alignsim;
    }

    public static double getIR(Set<String> req, Set<String> ser) {
        double sim = 0.0;
        HashSet reqSet = new HashSet();
        HashSet serSet = new HashSet();
        OWLClass thingClass = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Thing"));
        for (String a : req) {
            OWLClass reqClass = manager.getOWLDataFactory().getOWLClass(URI.create(a));
            try {
                Set reqSupSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)reqClass));
                reqSupSet.remove(thingClass);
                reqSet.addAll(reqSupSet);
            }
            catch (OWLReasonerException e) {
                e.printStackTrace();
            }
        }
        for (String b : ser) {
            OWLClass serClass = manager.getOWLDataFactory().getOWLClass(URI.create(b));
            try {
                Set serSupSet = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)serClass));
                serSupSet.remove(thingClass);
                serSet.addAll(serSupSet);
            }
            catch (OWLReasonerException e) {
                e.printStackTrace();
            }
        }
        Jaccard jac = new Jaccard(reqSet, serSet);
        if (jac.calculate()) {
            sim = jac.getSimilarity();
        }
        return sim;
    }

    public static void main(String[] args) {
        String book = "http://www.w3.org/2002/07/owl#Thing";
        OWLClass owlclass = manager.getOWLDataFactory().getOWLClass(URI.create(book));
        Set set = null;
        if (reasoner == null) {
            System.out.println("faile");
        }
        try {
            set = reasoner.getDescendantClasses((OWLDescription)owlclass);
        }
        catch (OWLReasonerException e) {
            e.printStackTrace();
        }
        Set set2 = OWLReasonerAdapter.flattenSetOfSets((Set)set);
        for (OWLClass cl : set2) {
            System.out.println(cl.getURI().toString());
        }
        System.out.println(set2.size());
    }
}

