/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.service.Service;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.reasonerfactory.pellet.PelletReasonerFactory;

public class ReasoningTools {
    private static Logger logger;
    public static Hashtable<String, Hashtable<String, String>> ontologyCache;
    public static Hashtable<URI, String> uriCache;
    public static Hashtable<String, Hashtable<String, Vector<URI>>> OWLSServiceCache;
    public static String uriCacheName;
    public static String ontologyCacheName;
    public static String OWLSServiceCacheName;

    static {
        ObjectInputStream in;
        File file;
        logger = Logger.getLogger(ReasoningTools.class);
        uriCacheName = "uriCache.ser";
        ontologyCacheName = "ontologyCache.ser";
        OWLSServiceCacheName = "OWLSServiceCacheName.ser";
        try {
            file = new File(ontologyCacheName);
            in = new ObjectInputStream(new FileInputStream(file));
            ontologyCache = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ontologyCache = new Hashtable();
        }
        try {
            file = new File(uriCacheName);
            in = new ObjectInputStream(new FileInputStream(file));
            uriCache = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            uriCache = new Hashtable();
        }
        try {
            file = new File(OWLSServiceCacheName);
            in = new ObjectInputStream(new FileInputStream(file));
            OWLSServiceCache = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OWLSServiceCache = new Hashtable();
        }
    }

    public static String unfoldConcepts(String ontology, String type, boolean doInfer) {
        if (!doInfer) {
            if (type.equals("input")) {
                Vector<URI> uriList = ReasoningTools.getURIs(ontology, type);
                String unfold = "";
                for (URI uri : uriList) {
                    unfold = String.valueOf(unfold) + uri.toString() + " ";
                }
                logger.debug((Object)("UNFOLD: " + unfold));
                return unfold.trim();
            }
            Vector<URI> uriList = ReasoningTools.getURIs(ontology, type);
            String unfold = "";
            for (URI uri : uriList) {
                unfold = String.valueOf(unfold) + uri.toString() + " ";
            }
            logger.debug((Object)("UNFOLD: " + unfold));
            return unfold.trim();
        }
        if (ontologyCache.containsKey(ontology)) {
            logger.debug((Object)("Cache hit for ontology " + ontology));
            if (ontologyCache.get(ontology).containsKey(type)) {
                logger.debug((Object)("Cache hit for ontology and " + type));
                return ontologyCache.get(ontology).get(type);
            }
            logger.debug((Object)("Cache miss for " + type));
            String unfold = ReasoningTools.unfold(ontology, type);
            ontologyCache.get(ontology).put(type, unfold);
            try {
                ReasoningTools.serializeOntologyCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return unfold;
        }
        logger.debug((Object)("Cache miss for ontology " + ontology));
        String unfold = ReasoningTools.unfold(ontology, type);
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(type, unfold);
        ontologyCache.put(ontology, table);
        try {
            ReasoningTools.serializeOntologyCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unfold;
    }

    private static String unfold(String ontology, String type) {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology onto = null;
        try {
            onto = manager.loadOntologyFromPhysicalURI(URI.create(ontology));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        PelletReasonerFactory reasonerFactory = new PelletReasonerFactory();
        OWLReasoner reasoner = reasonerFactory.createReasoner(manager);
        String unfold = "";
        try {
            Vector<URI> uriList = ReasoningTools.getURIs(ontology, type);
            if (!uriList.isEmpty()) {
                HashSet<URI> conceptsToAdd = new HashSet<URI>();
                conceptsToAdd.addAll(uriList);
                for (URI uri : uriList) {
                    if (uriCache.containsKey(uri)) {
                        logger.debug((Object)("URI cache hit for uri " + uri));
                        unfold = String.valueOf(unfold) + uriCache.get(uri);
                        continue;
                    }
                    logger.debug((Object)("URI cache miss for uri " + uri));
                    OWLClass r = manager.getOWLDataFactory().getOWLClass(uri);
                    OWLClass thing = manager.getOWLDataFactory().getOWLClass(URI.create("http://www.w3.org/2002/07/owl#Thing"));
                    if (r != null) {
                        Set set = OWLReasonerAdapter.flattenSetOfSets((Set)reasoner.getAncestorClasses((OWLDescription)r));
                        set.remove(thing);
                        String uf = ReasoningTools.convertSettoString(set);
                        unfold = String.valueOf(unfold) + uf;
                        uriCache.put(uri, unfold);
                        ReasoningTools.serializeURICache();
                        continue;
                    }
                    System.out.println("ERROR");
                }
                logger.debug((Object)("UNFOLD: " + unfold));
            }
            return unfold;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return unfold;
        }
    }

    public static Vector<URI> getServiceInterface(String ontology, String type) {
        if (OWLSServiceCache.containsKey(ontology)) {
            if (OWLSServiceCache.get(ontology).containsKey(type)) {
                return OWLSServiceCache.get(ontology).get(type);
            }
            Vector<URI> vec = ReasoningTools.getURIs(ontology, type);
            OWLSServiceCache.get(ontology).put(type, vec);
            try {
                ReasoningTools.serializeOWLSServiceCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return vec;
        }
        logger.debug((Object)("Cache miss for service " + ontology));
        Vector<URI> vec = ReasoningTools.getURIs(ontology, type);
        Hashtable<String, Vector<URI>> table = new Hashtable<String, Vector<URI>>();
        table.put(type, vec);
        OWLSServiceCache.put(ontology, table);
        try {
            ReasoningTools.serializeOWLSServiceCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vec;
    }

    public static Vector<URI> getURIs(String ontology, String type) {
        Vector<URI> uriList = null;
        OWLKnowledgeBase base = OWLFactory.createKB();
        base.setReasoner("RDFS");
        URI uri = null;
        try {
            uri = new URI(ontology);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        Service service = null;
        try {
            service = base.readService(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        uriList = type.equals("input") ? ReasoningTools.getURIList(service.getProfile().getInputs()) : ReasoningTools.getURIList(service.getProfile().getOutputs());
        return uriList;
    }

    private static void serializeURICache() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(uriCacheName));
        out.writeObject(uriCache);
        out.close();
    }

    private static void serializeOntologyCache() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(ontologyCacheName));
        out.writeObject(ontologyCache);
        out.close();
    }

    private static void serializeOWLSServiceCache() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(OWLSServiceCacheName));
        out.writeObject(OWLSServiceCache);
        out.close();
    }

    public static Vector<URI> getURIList(OWLIndividualList resourcen) {
        Iterator iter = resourcen.iterator();
        Vector<URI> urilist = new Vector<URI>();
        while (iter.hasNext()) {
            Parameter pare = (Parameter)iter.next();
            urilist.add(pare.getParamType().getURI());
        }
        return urilist;
    }

    public static String convertSettoString(Set<OWLClass> set) {
        String result = "";
        for (OWLClass cl : set) {
            result = String.valueOf(result) + cl.toString() + " ";
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(ReasoningTools.unfoldConcepts("http://127.0.0.1/services/1.1/BookPrice.owls", "input", true));
        Vector<URI> inputs = null;
        inputs = ReasoningTools.getURIs("http://127.0.0.1/services/1.1/EBookOrder1.owls", "input");
        for (URI a : inputs) {
            System.out.println(a.toString());
        }
    }
}

