/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.isparql.apf.simpack;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.ReasoningTools;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.Binding1;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionBase;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import owlsmx.exceptions.MatchingException;
import owlsmx.similaritymeasures.JensenShannonMeasure;
import owlsmx.tokenizer.PrimitiveConceptTokenizer;
import owlsmx.utils.CosineResultTriple;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.Cosine;
import simpack.util.Vector;

public class cosineVSMInputs
extends PropertyFunctionBase {
    private static Log logger = LogFactory.getLog(cosineVSMInputs.class);

    public QueryIterator exec(Binding binding, PropFuncArg subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        double d;
        subject = subject.evalIfExists(binding);
        Node s = subject.getArg();
        object = object.evalIfExists(binding);
        Node arg1 = object.getArg(0);
        Node arg2 = object.getArg(1);
        boolean doInfer = false;
        if (object.getArgList().size() >= 3) {
            Node arg3 = object.getArg(2);
            if (arg3.getLiteralLexicalForm().equals("true")) {
                doInfer = true;
            } else if (arg3.getLiteralLexicalForm().equals("false")) {
                doInfer = false;
            }
        }
        double threshold = 0.0;
        if (object.getArgList().size() >= 4) {
            Node arg4 = object.getArg(3);
            threshold = Double.valueOf(arg4.getLiteralLexicalForm());
        }
        String a = null;
        String b = null;
        if (arg1.isLiteral() && arg2.isLiteral()) {
            a = arg1.getLiteralLexicalForm();
            b = arg2.getLiteralLexicalForm();
        } else if (arg1.isURI() && arg2.isURI()) {
            a = arg1.getURI();
            b = arg2.getURI();
        } else {
            System.out.println("Error: Node types unequal.");
            System.out.println(arg1.toString());
            System.out.println(arg2.toString());
        }
        if (logger.isDebugEnabled()) {
            System.out.println(String.valueOf(a) + " <==> " + b);
        }
        String unfoldedInputs1 = ReasoningTools.unfoldConcepts(a.substring(0, a.lastIndexOf("#")), "input", doInfer);
        String unfoldedInputs2 = ReasoningTools.unfoldConcepts(b.substring(0, b.lastIndexOf("#")), "input", doInfer);
        PrimitiveConceptTokenizer tokenizer = new PrimitiveConceptTokenizer();
        Map pc1 = tokenizer.getTokenFrequencies(unfoldedInputs1);
        Map pc2 = tokenizer.getTokenFrequencies(unfoldedInputs2);
        JensenShannonMeasure jsMX = new JensenShannonMeasure();
        jsMX.setWeigth(201);
        CosineResultTriple TFs = null;
        try {
            TFs = jsMX.getTFArrays(pc1, pc2);
        }
        catch (MatchingException ex) {
            ex.printStackTrace();
        }
        double[] weightedPC1 = jsMX.weigthAndNormalizeTerms(TFs.term1);
        double[] weightedPC2 = jsMX.weigthAndNormalizeTerms(TFs.term2);
        Vector vPC1 = new Vector();
        Vector vPC2 = new Vector();
        double[] dArray = weightedPC1;
        int n = weightedPC1.length;
        int n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            vPC1.add((Object)d);
            ++n2;
        }
        dArray = weightedPC2;
        n = weightedPC2.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            vPC2.add((Object)d);
            ++n2;
        }
        Cosine c = null;
        try {
            c = new Cosine(vPC1, vPC2);
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
        }
        double sim = c.getSimilarity();
        if (sim < threshold) {
            sim = 0.0;
        }
        if (Double.isNaN(sim)) {
            sim = 0.0;
        }
        NodeValue nv = NodeValue.makeDouble((double)sim);
        Binding1 bind = new Binding1(binding, Var.alloc((Node)s), nv.asNode());
        return new QueryIterSingleton((Binding)bind, execCxt);
    }
}

