/*
 * Decompiled with CFR 0.152.
 */
package edu.nudt.nlp.isparql.apf.logicexpression;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.AtomicExpression;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.ConditionTools;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.Binding1;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionBase;
import java.util.Vector;

public class LogicExpressionSimilarity
extends PropertyFunctionBase {
    public static void main(String[] args) {
    }

    public double getExpressionsSimilarity(Vector<AtomicExpression> requests, Vector<AtomicExpression> services) {
        double sim = 0.0;
        double simTol = 0.0;
        if (requests == null || services == null) {
            return sim;
        }
        if (requests.size() == 0) {
            return sim;
        }
        for (AtomicExpression request : requests) {
            for (AtomicExpression service : services) {
                if (!service.getPredicate().equals(request.getPredicate())) continue;
                if (service.getType() == 1 || service.getType() == 2 || service.getType() == 3) {
                    if (!service.getArgument1().equals(request.getArgument1()) || !service.getArgument2().equals(request.getArgument2())) continue;
                    simTol += 1.0;
                    continue;
                }
                if (service.getType() != 0 || !service.getArgument1().equals(request.getArgument1())) continue;
                simTol += 1.0;
            }
        }
        sim = simTol / (double)requests.size();
        return sim;
    }

    public double getObjectDistance(String str1, String str2) {
        if (str1.equals(str2)) {
            return 0.0;
        }
        return 1.0;
    }

    public QueryIterator exec(Binding binding, PropFuncArg subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        subject = subject.evalIfExists(binding);
        Node s = subject.getArg();
        object = object.evalIfExists(binding);
        Node arg1 = object.getArg(0);
        Node arg2 = object.getArg(1);
        boolean doInfer = false;
        if (object.getArgList().size() >= 3) {
            Node arg3 = object.getArg(2);
            if (arg3.getLiteralLexicalForm().equals("true")) {
                doInfer = true;
            } else if (arg3.getLiteralLexicalForm().equals("false")) {
                doInfer = false;
            }
        }
        double threshold = 0.0;
        if (object.getArgList().size() >= 4) {
            Node arg4 = object.getArg(3);
            threshold = Double.valueOf(arg4.getLiteralLexicalForm());
        }
        String a = null;
        String b = null;
        if (arg1.isLiteral() && arg2.isLiteral()) {
            a = arg1.getLiteralLexicalForm();
            b = arg2.getLiteralLexicalForm();
        } else if (arg1.isURI() && arg2.isURI()) {
            a = arg1.getURI();
            b = arg2.getURI();
        } else {
            System.out.println("Error: Node types unequal.");
            System.out.println(arg1.toString());
            System.out.println(arg2.toString());
        }
        a = a.substring(0, a.lastIndexOf("#"));
        b = b.substring(0, b.lastIndexOf("#"));
        Vector<AtomicExpression> servicePreCondition = ConditionTools.getProcessCondition(a, "precondition");
        Vector<AtomicExpression> requestPreCondition = ConditionTools.getProcessCondition(b, "precondition");
        Vector<AtomicExpression> serviceEffect = ConditionTools.getProcessCondition(a, "effect");
        Vector<AtomicExpression> requestEffect = ConditionTools.getProcessCondition(b, "effect");
        double simPre = this.getExpressionsSimilarity(servicePreCondition, requestPreCondition);
        double simEffect = this.getExpressionsSimilarity(requestEffect, serviceEffect);
        double sim = (simPre + simEffect) / 2.0;
        NodeValue nv = NodeValue.makeDouble((double)sim);
        Binding1 bind = new Binding1(binding, Var.alloc((Node)s), nv.asNode());
        return new QueryIterSingleton((Binding)bind, execCxt);
    }
}

