/*
 * Decompiled with CFR 0.152.
 */
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.AbstractStrategy;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Logger;

public class getOWLSServiceName {
    public static Hashtable<String, Set<String>> owlsServiceURLandName = new Hashtable();
    public static String owlsServiceURLandNameCache = "owlsServiceURLandName.ser";
    public static String owlsServiceURLandNameCache2 = "owlsServiceURLandName2.ser";
    public static Hashtable<String, Set<String>> owlsServiceURLandName2 = new Hashtable();
    private String NL = System.getProperty("line.separator");
    private static Logger logger = Logger.getLogger(getOWLSServiceName.class);
    public String queryString = String.valueOf(AbstractStrategy.prolog) + AbstractStrategy.NL + "SELECT ?service" + AbstractStrategy.NL + "WHERE { " + "?service service:presents ?serviceProfile . }";

    public String getResult(Model queryModel) {
        System.out.println(this.queryString);
        Query query = QueryFactory.create((String)this.queryString);
        System.out.println(query.toString());
        if (logger.isDebugEnabled()) {
            query.serialize(new IndentedWriter((OutputStream)System.out, true));
            System.out.println();
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)queryModel);
        ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)qexec.execSelect());
        qexec.close();
        if (logger.isDebugEnabled()) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs, (Query)query);
            System.out.println("Size of result set: " + ResultSetFormatter.consume((ResultSet)rs));
        }
        String serName = null;
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            RDFNode service = rb.get("service");
            if (!service.canAs(Resource.class)) continue;
            Resource res = (Resource)service;
            serName = res.getURI();
        }
        return serName;
    }

    protected Model getService(File serviceURL, Model model) {
        InputStream in = null;
        File file = serviceURL;
        in = FileManager.get().open(file.toString());
        model.read(in, "");
        if (logger.isDebugEnabled()) {
            model.write((OutputStream)System.out);
        }
        return model;
    }

    private static void serializeServiceCache() throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(owlsServiceURLandNameCache));
        out.writeObject(owlsServiceURLandName);
        out.close();
    }

    public static void main(String[] args) {
        ObjectInputStream in;
        getOWLSServiceName get = new getOWLSServiceName();
        try {
            File file = new File(owlsServiceURLandNameCache);
            in = new ObjectInputStream(new FileInputStream(file));
            owlsServiceURLandName = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            owlsServiceURLandName = new Hashtable();
        }
        try {
            File file2 = new File(owlsServiceURLandNameCache2);
            in = new ObjectInputStream(new FileInputStream(file2));
            owlsServiceURLandName2 = (Hashtable)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            owlsServiceURLandName2 = new Hashtable();
        }
        String serviceCol = ".\\data\\OWLS-TC4_SWRL\\htdocs\\services\\1.1\\";
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".owls");
            }
        };
        File file = new File(serviceCol);
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            Model model = ModelFactory.createDefaultModel();
            get.getService(files[i], model);
            String serName = get.getResult(model);
            if (owlsServiceURLandName.containsKey(serName)) {
                owlsServiceURLandName.get(serName).add(files[i].getName());
                try {
                    getOWLSServiceName.serializeServiceCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                HashSet<String> serSet = new HashSet<String>();
                serSet.add(files[i].getName());
                owlsServiceURLandName.put(serName, serSet);
                try {
                    getOWLSServiceName.serializeServiceCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

