/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Literal
extends Node {
    private ATermAppl atermValue;
    private Object value;
    private Datatype datatype;
    private boolean hasValue;

    public Literal(ATermAppl name, ATermAppl term, ABox abox, DependencySet ds) {
        super(name, abox);
        if (term != null) {
            boolean bl = this.hasValue = !term.getArgument(2).equals(ATermUtils.NO_DATATYPE);
            if (this.hasValue) {
                this.value = abox.dtReasoner.getValue(term);
                if (this.value == null) {
                    this.depends.put(name, ds);
                }
            }
            this.atermValue = ATermUtils.makeValue((ATerm)term);
        } else {
            this.hasValue = false;
        }
    }

    public Literal(Literal literal, ABox abox) {
        super(literal, abox);
        this.atermValue = literal.atermValue;
        this.value = literal.value;
        this.hasValue = literal.hasValue;
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends((ATerm)ATermUtils.TOP_LIT);
    }

    @Override
    public Node copyTo(ABox abox) {
        return new Literal(this, abox);
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public int getNominalLevel() {
        return this.isNominal() ? 0 : Integer.MAX_VALUE;
    }

    @Override
    public boolean isNominal() {
        return this.value != null;
    }

    @Override
    public boolean isBlockable() {
        return this.value == null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }

    @Override
    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this.hasValue && literal.hasValue) {
            return this.value.getClass().equals(literal.value.getClass()) && !this.value.equals(literal.value);
        }
        return false;
    }

    @Override
    public boolean hasType(ATerm type) {
        if (super.hasType(type)) {
            return true;
        }
        return this.hasValue && this.atermValue.equals(type);
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        DependencySet ds = null;
        if (this.isDifferent(node) && (ds = (DependencySet)this.differents.get(node)) == null) {
            ds = DependencySet.INDEPENDENT;
        }
        return ds;
    }

    @Override
    public void addType(ATermAppl c, DependencySet d) {
        if (this.hasType((ATerm)c)) {
            return;
        }
        super.addType(c, d);
        this.checkClash();
    }

    public void addAllTypes(Map<ATermAppl, DependencySet> types, DependencySet ds) {
        for (ATermAppl c : types.keySet()) {
            if (this.hasType((ATerm)c)) continue;
            DependencySet depends = types.get(c);
            super.addType(c, depends.union(ds, this.abox.doExplanation()));
        }
        this.checkClash();
    }

    @Override
    public boolean hasSuccessor(Node x) {
        return false;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    @Override
    public final Literal getSame() {
        return (Literal)super.getSame();
    }

    @Override
    public ATermAppl getTerm() {
        return this.hasValue ? (ATermAppl)this.atermValue.getArgument(0) : null;
    }

    public String getDatatypeURI() {
        if (this.hasValue) {
            ATermAppl literal = this.getTerm();
            String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
            if (datatypeURI.equals("")) {
                return null;
            }
            return datatypeURI;
        }
        if (this.datatype == null) {
            return null;
        }
        if (this.datatype instanceof UnionDatatype) {
            return null;
        }
        if (this.datatype.getURI() != null) {
            return this.datatype.getURI();
        }
        AtomicDatatype primitive = ((AtomicDatatype)this.datatype).getPrimitiveType();
        if (primitive == null) {
            return null;
        }
        return primitive.getURI();
    }

    public String getLang() {
        return this.hasValue ? ((ATermAppl)((ATermAppl)this.atermValue.getArgument(0)).getArgument(1)).getName() : "";
    }

    public String getLexicalValue() {
        if (this.hasValue) {
            return this.value.toString();
        }
        return null;
    }

    private void checkClash() {
        String uri;
        AtomicDatatype litDatatype;
        if (this.hasValue && this.value == null) {
            this.abox.setClash(Clash.invalidLiteral(this, this.getDepends((ATerm)this.name), this.getTerm()));
            return;
        }
        if (this.hasType((ATerm)ATermUtils.BOTTOM_LIT)) {
            this.abox.setClash(Clash.emptyDatatype(this, this.getDepends((ATerm)ATermUtils.BOTTOM_LIT)));
            if (this.abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this.abox.getClash());
            }
            return;
        }
        Set<ATermAppl> types = this.getTypes();
        if (types.size() == 1) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        DatatypeReasoner dtReasoner = this.abox.getDatatypeReasoner();
        ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
        for (ATermAppl type : types) {
            if (type.equals(RDFSLiteral.instance.getName()) || ATermUtils.isAnd(type)) continue;
            primitives.add(type);
        }
        if (primitives.isEmpty()) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
        this.datatype = dtReasoner.intersection(dt);
        if (this.datatype.isEmpty()) {
            DependencySet ds = DependencySet.EMPTY;
            for (int i = 0; i < dt.length; ++i) {
                ds = ds.union(this.getDepends((ATerm)dt[i]), this.abox.doExplanation());
            }
            this.abox.setClash(Clash.emptyDatatype(this, ds, dt));
        } else if (this.hasValue && !this.datatype.contains(this.value, litDatatype = (AtomicDatatype)dtReasoner.getDatatype(uri = this.getDatatypeURI()))) {
            DependencySet ds = DependencySet.EMPTY;
            for (int i = 0; i < dt.length; ++i) {
                ds = ds.union(this.getDepends((ATerm)dt[i]), this.abox.doExplanation());
            }
            if (this.getDatatypeURI() == null) {
                this.abox.setClash(Clash.missingDatatype(this, ds, this.getTerm(), dt[0]));
            } else {
                this.abox.setClash(Clash.valueDatatype(this, ds, this.getTerm(), dt[0]));
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean restore(int branch) {
        Boolean restorePruned = this.restorePruned(branch);
        if (restorePruned == Boolean.FALSE) {
            return restorePruned;
        }
        boolean restored = restorePruned == Boolean.TRUE;
        return restored |= super.restore(branch);
    }

    @Override
    public final void prune(DependencySet ds) {
        this.pruned = ds;
    }

    @Override
    public void unprune(int branch) {
        super.unprune(branch);
        this.checkClash();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return super.toString();
        }
        String str = "\"" + this.value + "\"";
        String lang = this.getLang();
        if (!lang.equals("")) {
            return str + "@" + lang;
        }
        String datatypeURI = this.getDatatypeURI();
        if (datatypeURI != null) {
            return str + "^^" + datatypeURI;
        }
        return str;
    }

    public String debugString() {
        return this.name + " = " + this.getTypes().toString();
    }
}

