/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role {
    public static final String[] TYPES = new String[]{"Untyped", "Object", "Datatype", "Annotation", "Ontology"};
    @Deprecated
    public static final int UNDEFINED = 0;
    public static final int UNTYPED = 0;
    public static final int OBJECT = 1;
    public static final int DATATYPE = 2;
    public static final int ANNOTATION = 3;
    public static final int ONTOLOGY = 4;
    private ATermAppl name;
    private int type = 0;
    private Role inverse = null;
    private Set<Role> subRoles = SetUtils.emptySet();
    private Set<Role> superRoles = SetUtils.emptySet();
    private Map<Role, DependencySet> disjointRoles = Collections.emptyMap();
    private Set<ATermList> subRoleChains = SetUtils.emptySet();
    private Set<Role> functionalSupers = SetUtils.emptySet();
    private Set<Role> transitiveSubRoles = SetUtils.emptySet();
    private TransitionGraph tg;
    public static int TRANSITIVE = 1;
    public static int FUNCTIONAL = 2;
    public static int INV_FUNCTIONAL = 4;
    public static int REFLEXIVE = 8;
    public static int IRREFLEXIVE = 16;
    public static int ASYM;
    public static int ANTI_SYM;
    public static int SIMPLE;
    public static int COMPLEX_SUB;
    public static int FORCE_SIMPLE;
    private int flags = SIMPLE;
    private DependencySet explainAsymmetric = DependencySet.INDEPENDENT;
    private DependencySet explainFunctional = DependencySet.INDEPENDENT;
    private DependencySet explainIrreflexive = DependencySet.INDEPENDENT;
    private DependencySet explainReflexive = DependencySet.INDEPENDENT;
    private DependencySet explainSymmetric = DependencySet.INDEPENDENT;
    private DependencySet explainTransitive = DependencySet.INDEPENDENT;
    private DependencySet explainInverseFunctional = DependencySet.INDEPENDENT;
    private Map<ATerm, DependencySet> explainSub = new HashMap<ATerm, DependencySet>();
    private Map<ATerm, DependencySet> explainSup = new HashMap<ATerm, DependencySet>();
    private Map<ATermAppl, DependencySet> domains = Collections.emptyMap();
    private Map<ATermAppl, DependencySet> ranges = Collections.emptyMap();

    public Role(ATermAppl name) {
        this(name, 0);
    }

    public Role(ATermAppl name, int type) {
        this.name = name;
        this.type = type;
        this.addSubRole(this, DependencySet.INDEPENDENT);
        this.addSuperRole(this, DependencySet.INDEPENDENT);
    }

    public boolean equals(Object o) {
        if (o instanceof Role) {
            return this.name == ((Role)o).getName();
        }
        return false;
    }

    public String toString() {
        return ATermUtils.toString(this.name);
    }

    public String debugString() {
        String str = "(" + TYPES[this.type] + "Role " + this.name;
        if (this.isTransitive()) {
            str = str + " Transitive";
        }
        if (this.isReflexive()) {
            str = str + " Reflexive";
        }
        if (this.isIrreflexive()) {
            str = str + " Irreflexive";
        }
        if (this.isSymmetric()) {
            str = str + " Symmetric";
        }
        if (this.isAsymmetric()) {
            str = str + " Asymmetric";
        }
        if (this.isFunctional()) {
            str = str + " Functional";
        }
        if (this.isInverseFunctional()) {
            str = str + " InverseFunctional";
        }
        if (this.hasComplexSubRole()) {
            str = str + " ComplexSubRole";
        }
        if (this.isSimple()) {
            str = str + " Simple";
        }
        if (this.type == 1 || this.type == 2) {
            str = str + " domain=" + this.domains;
            str = str + " range=" + this.ranges;
            str = str + " superPropertyOf=" + this.subRoles;
            str = str + " subPropertyOf=" + this.superRoles;
            str = str + " hasSubPropertyChain=" + this.subRoleChains;
            str = str + " disjointWith=" + this.disjointRoles;
        }
        str = str + ")";
        return str;
    }

    public void addSubRoleChain(ATermList chain) {
        this.addSubRoleChain(chain, DependencySet.INDEPENDENT);
    }

    public void addSubRoleChain(ATermList chain, DependencySet ds) {
        if (chain.isEmpty()) {
            throw new InternalReasonerException("Adding a subproperty chain that is empty!");
        }
        if (chain.getLength() == 1) {
            throw new InternalReasonerException("Adding a subproperty chain that has a single element!");
        }
        this.subRoleChains = SetUtils.add(chain, this.subRoleChains);
        this.explainSub.put((ATerm)chain, ds);
        this.setSimple(false);
        if (ATermUtils.isTransitiveChain(chain, (ATerm)this.name) && !this.isTransitive()) {
            this.setTransitive(true, ds);
        }
    }

    public void removeSubRoleChain(ATermList chain) {
        this.subRoleChains = SetUtils.remove(chain, this.subRoleChains);
        this.explainSub.remove(chain);
        if (this.isTransitive() && ATermUtils.isTransitiveChain(chain, (ATerm)this.name)) {
            this.setTransitive(false, null);
        }
    }

    public void removeSubRoleChains() {
        this.subRoleChains = Collections.emptySet();
        if (this.isTransitive()) {
            this.setTransitive(false, null);
        }
    }

    public void addSubRole(Role r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp((ATerm)r.getName(), (ATerm)this.getName())) : DependencySet.INDEPENDENT;
        this.addSubRole(r, ds);
    }

    public void addSubRole(Role r, DependencySet ds) {
        if (PelletOptions.USE_TRACING && this.explainSub.get(r.getName()) == null) {
            this.explainSub.put((ATerm)r.getName(), ds);
        }
        this.subRoles = SetUtils.add(r, this.subRoles);
        this.explainSub.put((ATerm)r.getName(), ds);
    }

    public boolean removeDomain(ATermAppl a, DependencySet ds) {
        DependencySet existing = this.domains.get(a);
        if (existing != null && ((Object)ds.getExplain()).equals(existing.getExplain())) {
            this.domains.remove(a);
            return true;
        }
        return false;
    }

    public boolean removeRange(ATermAppl a, DependencySet ds) {
        DependencySet existing = this.ranges.get(a);
        if (existing != null && ((Object)ds.getExplain()).equals(existing.getExplain())) {
            this.ranges.remove(a);
            return true;
        }
        return false;
    }

    public void removeSubRole(Role r) {
        this.subRoles = SetUtils.remove(r, this.subRoles);
    }

    public void addSuperRole(Role r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp((ATerm)this.name, (ATerm)r.getName())) : DependencySet.INDEPENDENT;
        this.addSuperRole(r, ds);
    }

    public void addSuperRole(Role r, DependencySet ds) {
        this.superRoles = SetUtils.add(r, this.superRoles);
        this.explainSup.put((ATerm)r.getName(), ds);
    }

    public void addDisjointRole(Role r, DependencySet ds) {
        if (this.disjointRoles.isEmpty()) {
            this.disjointRoles = new HashMap<Role, DependencySet>();
        }
        this.disjointRoles.put(r, ds);
    }

    boolean addDomain(ATermAppl a, DependencySet ds) {
        DependencySet existing;
        if (this.domains.isEmpty()) {
            this.domains = CollectionUtils.makeMap();
        }
        return (existing = this.domains.put(a, ds)) == null || !((Object)existing.getExplain()).equals(ds.getExplain());
    }

    boolean addRange(ATermAppl a, DependencySet ds) {
        DependencySet existing;
        if (this.ranges.isEmpty()) {
            this.ranges = CollectionUtils.makeMap();
        }
        return (existing = this.ranges.put(a, ds)) == null || !((Object)existing.getExplain()).equals(ds.getExplain());
    }

    public boolean isObjectRole() {
        return this.type == 1;
    }

    public boolean isDatatypeRole() {
        return this.type == 2;
    }

    public boolean isOntologyRole() {
        return this.type == 4;
    }

    public boolean isAnnotationRole() {
        return this.type == 3;
    }

    public boolean isUntypedRole() {
        return this.type == 0;
    }

    public Role getInverse() {
        return this.inverse;
    }

    public boolean hasNamedInverse() {
        return this.inverse != null && !this.inverse.isAnon();
    }

    public boolean hasComplexSubRole() {
        return (this.flags & COMPLEX_SUB) != 0;
    }

    public boolean isFunctional() {
        return (this.flags & FUNCTIONAL) != 0;
    }

    public boolean isInverseFunctional() {
        return (this.flags & INV_FUNCTIONAL) != 0;
    }

    public boolean isSymmetric() {
        return this.inverse != null && this.inverse.equals(this);
    }

    public boolean isAntisymmetric() {
        return (this.flags & ASYM) != 0;
    }

    public boolean isAsymmetric() {
        return (this.flags & ASYM) != 0;
    }

    public boolean isTransitive() {
        return (this.flags & TRANSITIVE) != 0;
    }

    public boolean isReflexive() {
        return (this.flags & REFLEXIVE) != 0;
    }

    public boolean isIrreflexive() {
        return (this.flags & IRREFLEXIVE) != 0;
    }

    public boolean isAnon() {
        return this.name.getArity() != 0;
    }

    public ATermAppl getName() {
        return this.name;
    }

    public Set<ATermAppl> getDomains() {
        return this.domains.keySet();
    }

    public Set<ATermAppl> getRanges() {
        return this.ranges.keySet();
    }

    public Set<Role> getSubRoles() {
        return Collections.unmodifiableSet(this.subRoles);
    }

    public Set<Role> getEquivalentProperties() {
        return SetUtils.intersection(this.subRoles, this.superRoles);
    }

    public boolean isEquivalent(Role r) {
        return this.subRoles.contains(r) && this.superRoles.contains(r);
    }

    public Set<Role> getProperSubRoles() {
        return SetUtils.difference(this.subRoles, this.superRoles);
    }

    public Set<ATermList> getSubRoleChains() {
        return this.subRoleChains;
    }

    public Set<Role> getSuperRoles() {
        return Collections.unmodifiableSet(this.superRoles);
    }

    public Set<Role> getDisjointRoles() {
        return Collections.unmodifiableSet(this.disjointRoles.keySet());
    }

    public DependencySet getExplainDisjointRole(Role role) {
        return this.disjointRoles.get(role);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TYPES[this.type];
    }

    public boolean isSubRoleOf(Role r) {
        return this.superRoles.contains(r);
    }

    public boolean isSuperRoleOf(Role r) {
        return this.subRoles.contains(r);
    }

    public void setInverse(Role term) {
        this.inverse = term;
    }

    public void setFunctional(boolean b) {
        DependencySet ds = DependencySet.INDEPENDENT;
        this.setFunctional(b, ds);
    }

    public void setFunctional(boolean b, DependencySet ds) {
        if (b) {
            this.flags |= FUNCTIONAL;
            this.explainFunctional = ds;
        } else {
            this.flags &= ~FUNCTIONAL;
            this.explainFunctional = DependencySet.INDEPENDENT;
        }
    }

    public void setInverseFunctional(boolean b) {
        this.setInverseFunctional(b, DependencySet.INDEPENDENT);
    }

    public void setInverseFunctional(boolean b, DependencySet ds) {
        if (b) {
            this.flags |= INV_FUNCTIONAL;
            this.explainInverseFunctional = ds;
        } else {
            this.flags &= ~INV_FUNCTIONAL;
            this.explainInverseFunctional = DependencySet.INDEPENDENT;
        }
    }

    public void setTransitive(boolean b) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive((ATerm)this.name)) : DependencySet.INDEPENDENT;
        this.setTransitive(b, ds);
    }

    public void setTransitive(boolean b, DependencySet ds) {
        ATermList roleChain = ATermUtils.makeList(new ATerm[]{this.name, this.name});
        if (b) {
            this.flags |= TRANSITIVE;
            this.explainTransitive = ds;
            this.addSubRoleChain(roleChain, ds);
        } else {
            this.flags &= ~TRANSITIVE;
            this.explainTransitive = ds;
            this.removeSubRoleChain(roleChain);
        }
    }

    public void setReflexive(boolean b) {
        this.setReflexive(b, DependencySet.INDEPENDENT);
    }

    public void setReflexive(boolean b, DependencySet ds) {
        this.flags = b ? (this.flags |= REFLEXIVE) : (this.flags &= ~REFLEXIVE);
        this.explainReflexive = ds;
    }

    public void setIrreflexive(boolean b) {
        this.setIrreflexive(b, DependencySet.INDEPENDENT);
    }

    public void setIrreflexive(boolean b, DependencySet ds) {
        this.flags = b ? (this.flags |= IRREFLEXIVE) : (this.flags &= ~IRREFLEXIVE);
        this.explainIrreflexive = ds;
    }

    public void setAntisymmetric(boolean b) {
        this.setAsymmetric(b, DependencySet.INDEPENDENT);
    }

    public void setAsymmetric(boolean b) {
        this.setAsymmetric(b, DependencySet.INDEPENDENT);
    }

    public void setAntisymmetric(boolean b, DependencySet ds) {
        this.setAsymmetric(b, ds);
    }

    public void setAsymmetric(boolean b, DependencySet ds) {
        this.flags = b ? (this.flags |= ANTI_SYM) : (this.flags &= ~ANTI_SYM);
        this.explainAsymmetric = ds;
    }

    public void setHasComplexSubRole(boolean b) {
        if (b == this.hasComplexSubRole()) {
            return;
        }
        this.flags = b ? (this.flags |= COMPLEX_SUB) : (this.flags &= ~COMPLEX_SUB);
        if (this.inverse != null) {
            this.inverse.setHasComplexSubRole(b);
        }
        if (b) {
            this.setSimple(false);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSubRolesAndChains(Set<Role> subRoles, Set<ATermList> subRoleChains, Map<ATerm, DependencySet> dependencies) {
        this.subRoles = subRoles;
        this.subRoleChains = subRoleChains;
        this.explainSub = dependencies;
    }

    @Deprecated
    public void setSubRoleChains(Set<ATermList> subRoleChains) {
        this.subRoleChains = subRoleChains;
    }

    @Deprecated
    public void setSubRoles(Set<Role> subRoles) {
        this.subRoles = subRoles;
    }

    public void setSuperRoles(Set<Role> superRoles) {
        this.superRoles = superRoles;
    }

    public Set<Role> getFunctionalSupers() {
        return this.functionalSupers;
    }

    public void addFunctionalSuper(Role r) {
        for (Role fs : this.functionalSupers) {
            if (fs.isSubRoleOf(r)) {
                this.functionalSupers = SetUtils.remove(fs, this.functionalSupers);
                break;
            }
            if (!r.isSubRoleOf(fs)) continue;
            return;
        }
        this.functionalSupers = SetUtils.add(r, this.functionalSupers);
    }

    public void setForceSimple(boolean b) {
        if (b == this.isForceSimple()) {
            return;
        }
        this.flags = b ? (this.flags |= FORCE_SIMPLE) : (this.flags &= ~FORCE_SIMPLE);
        if (this.inverse != null) {
            this.inverse.setForceSimple(b);
        }
    }

    public boolean isForceSimple() {
        return (this.flags & FORCE_SIMPLE) != 0;
    }

    public boolean isSimple() {
        return (this.flags & SIMPLE) != 0;
    }

    void setSimple(boolean b) {
        if (b == this.isSimple()) {
            return;
        }
        this.flags = b ? (this.flags |= SIMPLE) : (this.flags &= ~SIMPLE);
        if (this.inverse != null) {
            this.inverse.setSimple(b);
        }
    }

    public Set<Role> getTransitiveSubRoles() {
        return this.transitiveSubRoles;
    }

    public void addTransitiveSubRole(Role r) {
        this.setSimple(false);
        if (this.transitiveSubRoles.isEmpty()) {
            this.transitiveSubRoles = SetUtils.singleton(r);
        } else if (this.transitiveSubRoles.size() == 1) {
            Role tsr = this.transitiveSubRoles.iterator().next();
            if (tsr.isSubRoleOf(r)) {
                this.transitiveSubRoles = SetUtils.singleton(r);
            } else if (!r.isSubRoleOf(tsr)) {
                this.transitiveSubRoles = new HashSet<Role>(2);
                this.transitiveSubRoles.add(tsr);
                this.transitiveSubRoles.add(r);
            }
        } else {
            for (Role tsr : this.transitiveSubRoles) {
                if (tsr.isSubRoleOf(r)) {
                    this.transitiveSubRoles.remove(tsr);
                    this.transitiveSubRoles.add(r);
                    return;
                }
                if (!r.isSubRoleOf(tsr)) continue;
                return;
            }
            this.transitiveSubRoles.add(r);
        }
    }

    public void setFSM(TransitionGraph tg) {
        this.tg = tg;
    }

    public TransitionGraph getFSM() {
        return this.tg;
    }

    public DependencySet getExplainAsymmetric() {
        return this.explainAsymmetric;
    }

    public DependencySet getExplainDomain(ATermAppl a) {
        return this.domains.get(a);
    }

    public DependencySet getExplainFunctional() {
        return this.explainFunctional;
    }

    public DependencySet getExplainInverseFunctional() {
        return this.explainInverseFunctional;
    }

    public DependencySet getExplainIrreflexive() {
        return this.explainIrreflexive;
    }

    public DependencySet getExplainRange(ATermAppl a) {
        return this.ranges.get(a);
    }

    public DependencySet getExplainReflexive() {
        return this.explainReflexive;
    }

    public DependencySet getExplainSub(ATerm r) {
        DependencySet ds = this.explainSub.get(r);
        if (ds == null) {
            return DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public DependencySet getExplainSuper(ATerm r) {
        DependencySet ds = this.explainSup.get(r);
        if (ds == null) {
            return DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public DependencySet getExplainSymmetric() {
        return this.explainSymmetric;
    }

    public DependencySet getExplainTransitive() {
        return this.explainTransitive;
    }

    static {
        ANTI_SYM = ASYM = 32;
        SIMPLE = 64;
        COMPLEX_SUB = 128;
        FORCE_SIMPLE = 256;
    }
}

