/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.pure.PureFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.URIUtils;
import org.mindswap.pellet.utils.iterator.MultiListIterator;
import org.mindswap.pellet.utils.iterator.PairIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATermUtils {
    public static final String NOT = "not";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String SOME = "some";
    public static final String ALL = "all";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String CARD = "card";
    public static final String VALUE = "value";
    public static final String SELF = "self";
    public static final String INV = "inv";
    public static final String SUB = "sub";
    public static final String SAME = "same";
    public static final String DISJOINT = "disjoint";
    public static final String DISJOINTS = "disjoints";
    public static final String COMPLEMENT = "complement";
    private static final ATermFactory factory = new PureFactory();
    public static final AFun LITFUN = factory.makeAFun("literal", 3, false);
    public static final int LIT_VAL_INDEX = 0;
    public static final int LIT_LANG_INDEX = 1;
    public static final int LIT_URI_INDEX = 2;
    public static final AFun ANDFUN = factory.makeAFun("and", 1, false);
    public static final AFun ORFUN = factory.makeAFun("or", 1, false);
    public static final AFun SOMEFUN = factory.makeAFun("some", 2, false);
    public static final AFun ALLFUN = factory.makeAFun("all", 2, false);
    public static final AFun NOTFUN = factory.makeAFun("not", 1, false);
    public static final AFun MAXFUN = factory.makeAFun("max", 3, false);
    public static final AFun MINFUN = factory.makeAFun("min", 3, false);
    public static final AFun VALUEFUN = factory.makeAFun("value", 1, false);
    public static final AFun SELFFUN = factory.makeAFun("self", 1, false);
    public static final AFun CARDFUN = factory.makeAFun("card", 3, false);
    public static Set<AFun> CLASS_FUN = SetUtils.create(ALLFUN, SOMEFUN, MAXFUN, MINFUN, CARDFUN, ANDFUN, ORFUN, NOTFUN, VALUEFUN, SELFFUN);
    public static final AFun INVFUN = factory.makeAFun("inv", 1, false);
    public static final AFun SUBFUN = factory.makeAFun("subClassOf", 2, false);
    public static final AFun EQCLASSFUN = factory.makeAFun("equivalentClasses", 2, false);
    public static final AFun SAMEASFUN = factory.makeAFun("sameAs", 2, false);
    public static final AFun DISJOINTFUN = factory.makeAFun("disjointWith", 2, false);
    public static final AFun DISJOINTSFUN = factory.makeAFun("disjointClasses", 1, false);
    public static final AFun DISJOINTPROPFUN = factory.makeAFun("disjointPropertyWith", 2, false);
    public static final AFun DISJOINTPROPSFUN = factory.makeAFun("disjointProperties", 1, false);
    public static final AFun COMPLEMENTFUN = factory.makeAFun("complementOf", 2, false);
    public static final AFun VARFUN = factory.makeAFun("var", 1, false);
    public static final AFun TYPEFUN = factory.makeAFun("type", 2, false);
    public static final AFun PROPFUN = factory.makeAFun("prop", 3, false);
    public static final AFun DIFFERENTFUN = factory.makeAFun("different", 2, false);
    public static final AFun ALLDIFFERENTFUN = factory.makeAFun("allDifferent", 1, false);
    public static final AFun ASYMMETRICFUN;
    public static final AFun ANTISYMMETRICFUN;
    public static final AFun FUNCTIONALFUN;
    public static final AFun INVFUNCTIONALFUN;
    public static final AFun IRREFLEXIVEFUN;
    public static final AFun REFLEXIVEFUN;
    public static final AFun SYMMETRICFUN;
    public static final AFun TRANSITIVEFUN;
    public static final AFun SUBPROPFUN;
    public static final AFun EQPROPFUN;
    public static final AFun INVPROPFUN;
    public static final AFun DOMAINFUN;
    public static final AFun RANGEFUN;
    public static final AFun RULEFUN;
    public static final AFun BUILTINFUN;
    public static final AFun RESTRDATATYPEFUN;
    public static final AFun FACET;
    public static final ATermAppl EMPTY;
    public static final ATermList EMPTY_LIST;
    public static Set<AFun> AXIOM_FUN;
    public static final ATermAppl TOP;
    public static final ATermAppl BOTTOM;
    public static final ATermAppl TOP_LIT;
    public static final ATermAppl BOTTOM_LIT;
    public static final ATermAppl CONCEPT_SAT_IND;
    public static final ATermInt ONE;
    public static QNameProvider qnames;
    public static ATermAppl NO_DATATYPE;
    public static final AFun BNODE_FUN;
    public static final AFun ANON_FUN;
    public static final AFun ANON_NOMINAL_FUN;
    private static final ATermAppl[] anonCache;

    public static ATermFactory getFactory() {
        return factory;
    }

    public static final ATermAppl makeTypeAtom(ATermAppl ind, ATermAppl c) {
        return factory.makeAppl(TYPEFUN, (ATerm)ind, (ATerm)c);
    }

    public static final ATermAppl makePropAtom(ATermAppl p, ATermAppl s, ATermAppl o) {
        return factory.makeAppl(PROPFUN, (ATerm)p, (ATerm)s, (ATerm)o);
    }

    public static ATermAppl makePlainLiteral(String value) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)EMPTY, (ATerm)EMPTY);
    }

    public static ATermAppl makePlainLiteral(String value, String lang) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)ATermUtils.makeTermAppl(lang), (ATerm)EMPTY);
    }

    public static ATermAppl makeTypedLiteral(String value, String dt) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)EMPTY, (ATerm)ATermUtils.makeTermAppl(dt));
    }

    public static ATermAppl makeLiteral(ATermAppl name) {
        return factory.makeAppl(LITFUN, (ATerm)name, (ATerm)EMPTY, (ATerm)NO_DATATYPE);
    }

    public static String getLiteralValue(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(0)).getName();
    }

    public static String getLiteralLang(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(1)).getName();
    }

    public static String getLiteralDatatype(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(2)).getName();
    }

    public static ATermAppl makeTermAppl(String name) {
        return factory.makeAppl(factory.makeAFun(name, 0, false));
    }

    public static ATermAppl makeTermAppl(AFun fun, ATerm[] args) {
        return factory.makeAppl(fun, args);
    }

    public static ATermAppl makeNot(ATerm c) {
        return factory.makeAppl(NOTFUN, c);
    }

    public static ATerm term(String str) {
        return factory.parse(str);
    }

    public static ATermList negate(ATermList list) {
        if (list.isEmpty()) {
            return list;
        }
        ATermAppl a = (ATermAppl)list.getFirst();
        a = ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot((ATerm)a);
        ATermList result = ATermUtils.makeList((ATerm)a, ATermUtils.negate(list.getNext()));
        return result;
    }

    public static final ATermAppl negate(ATermAppl a) {
        return ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot((ATerm)a);
    }

    public static final boolean isAnonNominal(ATermAppl term) {
        return term.getAFun().equals(ANON_NOMINAL_FUN);
    }

    public static final ATermAppl makeAnonNominal(int id) {
        return factory.makeAppl(ANON_NOMINAL_FUN, (ATerm)factory.makeInt(id));
    }

    public static final ATermAppl makeAnon(int id) {
        if (id < anonCache.length) {
            return anonCache[id];
        }
        return factory.makeAppl(ANON_FUN, (ATerm)factory.makeInt(id));
    }

    public static final ATermAppl makeBnode(String id) {
        return factory.makeAppl(BNODE_FUN, (ATerm)ATermUtils.makeTermAppl(id));
    }

    public static final ATermAppl makeVar(String name) {
        return factory.makeAppl(VARFUN, (ATerm)ATermUtils.makeTermAppl(name));
    }

    public static final ATermAppl makeVar(ATermAppl name) {
        return factory.makeAppl(VARFUN, (ATerm)name);
    }

    public static final ATermAppl makeValue(ATerm c) {
        return factory.makeAppl(VALUEFUN, c);
    }

    public static final ATermAppl makeInv(ATermAppl r) {
        if (ATermUtils.isInv(r)) {
            return (ATermAppl)r.getArgument(0);
        }
        return factory.makeAppl(INVFUN, (ATerm)r);
    }

    public static final ATermAppl makeInvProp(ATerm r, ATerm s) {
        return factory.makeAppl(INVPROPFUN, r, s);
    }

    public static final ATermAppl makeSub(ATerm a, ATerm b) {
        return factory.makeAppl(SUBFUN, a, b);
    }

    public static final ATermAppl makeSame(ATerm a, ATerm b) {
        return ATermUtils.makeEqClasses(a, b);
    }

    public static final ATermAppl makeEqClasses(ATerm a, ATerm b) {
        return factory.makeAppl(EQCLASSFUN, a, b);
    }

    public static final ATermAppl makeSameAs(ATerm a, ATerm b) {
        return factory.makeAppl(SAMEASFUN, a, b);
    }

    public static final ATermAppl makeSubProp(ATerm r, ATerm s) {
        return factory.makeAppl(SUBPROPFUN, r, s);
    }

    public static final ATermAppl makeEqProp(ATerm r, ATerm s) {
        return factory.makeAppl(EQPROPFUN, r, s);
    }

    public static final ATermAppl makeDomain(ATerm r, ATerm c) {
        return factory.makeAppl(DOMAINFUN, r, c);
    }

    public static final ATermAppl makeRange(ATerm r, ATerm c) {
        return factory.makeAppl(RANGEFUN, r, c);
    }

    public static final ATermAppl makeComplement(ATerm a, ATerm b) {
        return factory.makeAppl(COMPLEMENTFUN, a, b);
    }

    public static final ATermAppl makeDisjoint(ATerm a, ATerm b) {
        return factory.makeAppl(DISJOINTFUN, a, b);
    }

    public static final ATermAppl makeDisjoints(ATermList list) {
        return factory.makeAppl(DISJOINTSFUN, (ATerm)list);
    }

    public static final ATermAppl makeDisjointProperty(ATerm a, ATerm b) {
        return factory.makeAppl(DISJOINTPROPFUN, a, b);
    }

    public static final ATermAppl makeDisjointProperties(ATermList list) {
        return factory.makeAppl(DISJOINTPROPSFUN, (ATerm)list);
    }

    public static final ATermAppl makeDifferent(ATerm a, ATerm b) {
        return factory.makeAppl(DIFFERENTFUN, a, b);
    }

    public static final ATermAppl makeAllDifferent(ATermList list) {
        return factory.makeAppl(ALLDIFFERENTFUN, (ATerm)list);
    }

    public static final ATermAppl makeAsymmetric(ATerm r) {
        return factory.makeAppl(ASYMMETRICFUN, r);
    }

    public static final ATermAppl makeAntisymmetric(ATerm r) {
        return ATermUtils.makeAsymmetric(r);
    }

    public static final ATermAppl makeFunctional(ATerm a) {
        return factory.makeAppl(FUNCTIONALFUN, a);
    }

    public static final ATermAppl makeInverseFunctional(ATerm a) {
        return factory.makeAppl(INVFUNCTIONALFUN, a);
    }

    public static final ATermAppl makeIrreflexive(ATerm r) {
        return factory.makeAppl(IRREFLEXIVEFUN, r);
    }

    public static final ATermAppl makeReflexive(ATerm r) {
        return factory.makeAppl(REFLEXIVEFUN, r);
    }

    public static final ATermAppl makeSymmetric(ATerm r) {
        return factory.makeAppl(SYMMETRICFUN, r);
    }

    public static final ATermAppl makeTransitive(ATerm r) {
        return factory.makeAppl(TRANSITIVEFUN, r);
    }

    public static final ATermAppl makeAnd(ATerm c1, ATerm c2) {
        return ATermUtils.makeAnd(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATermAppl makeAnd(ATermList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return TOP;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ANDFUN, (ATerm)list);
    }

    public static final ATermAppl makeOr(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm)c2).insert((ATerm)c1));
    }

    public static ATermAppl makeOr(ATermList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ORFUN, (ATerm)list);
    }

    public static final ATermAppl makeAllValues(ATerm r, ATerm c) {
        ATermList list;
        if (r.getType() == 4 && (list = (ATermList)r).getLength() == 1) {
            r = list.getFirst();
        }
        return factory.makeAppl(ALLFUN, r, c);
    }

    public static final ATermAppl makeSomeValues(ATerm r, ATerm c) {
        ATermUtils.assertTrue(c instanceof ATermAppl);
        return factory.makeAppl(SOMEFUN, r, c);
    }

    public static final ATermAppl makeSelf(ATermAppl r) {
        return factory.makeAppl(SELFFUN, (ATerm)r);
    }

    public static final ATermAppl makeHasValue(ATerm r, ATerm ind) {
        ATermAppl c = ATermUtils.makeValue(ind);
        return factory.makeAppl(SOMEFUN, r, (ATerm)c);
    }

    public static final ATermAppl makeNormalizedMax(ATermAppl r, int n, ATermAppl c) {
        ATermUtils.assertTrue(n >= 0);
        return ATermUtils.makeNot((ATerm)ATermUtils.makeMin((ATerm)r, n + 1, (ATerm)c));
    }

    public static final ATermAppl makeMax(ATerm r, int n, ATerm c) {
        return ATermUtils.makeMax(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeMax(ATerm r, ATermInt n, ATerm c) {
        ATermUtils.assertTrue(n.getInt() >= 0);
        return factory.makeAppl(MAXFUN, r, (ATerm)n, c);
    }

    public static final ATermAppl makeMin(ATerm r, int n, ATerm c) {
        return ATermUtils.makeMin(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeMin(ATerm r, ATermInt n, ATerm c) {
        ATermUtils.assertTrue(n.getInt() >= 0);
        return factory.makeAppl(MINFUN, r, (ATerm)n, c);
    }

    public static final ATermAppl makeDisplayCard(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(CARDFUN, r, (ATerm)factory.makeInt(n), c);
    }

    public static final ATermAppl makeDisplayMax(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MAXFUN, r, (ATerm)factory.makeInt(n), c);
    }

    public static final ATermAppl makeDisplayMin(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MINFUN, r, (ATerm)factory.makeInt(n), c);
    }

    public static final ATermAppl makeCard(ATerm r, int n, ATerm c) {
        return ATermUtils.makeDisplayCard(r, n, c);
    }

    public static final ATermAppl makeExactCard(ATerm r, int n, ATerm c) {
        return ATermUtils.makeExactCard(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeExactCard(ATerm r, ATermInt n, ATerm c) {
        ATermAppl max = ATermUtils.makeMax(r, n, c);
        if (n.getInt() == 0) {
            return max;
        }
        ATermAppl min = ATermUtils.makeMin(r, n, c);
        return ATermUtils.makeAnd((ATerm)min, (ATerm)max);
    }

    public static final ATermAppl makeFacetRestriction(ATermAppl facetName, ATermAppl facetValue) {
        return factory.makeAppl(FACET, (ATerm)facetName, (ATerm)facetValue);
    }

    public static final ATermAppl makeRestrictedDatatype(ATermAppl baseDatatype, ATermAppl[] restrictions) {
        return factory.makeAppl(RESTRDATATYPEFUN, (ATerm)baseDatatype, (ATerm)ATermUtils.makeList((ATerm[])restrictions));
    }

    public static final boolean isRestrictedDatatype(ATermAppl term) {
        return term.getAFun().equals(RESTRDATATYPEFUN);
    }

    public static final ATermList makeList(ATerm singleton) {
        return factory.makeList(singleton, EMPTY_LIST);
    }

    public static final ATermList makeList(ATerm first, ATermList rest) {
        return factory.makeList(first, rest);
    }

    public static ATermList makeList(Collection<ATermAppl> set) {
        ATermList list = EMPTY_LIST;
        for (ATermAppl term : set) {
            list = list.insert((ATerm)term);
        }
        return list;
    }

    public static final ATermList makeList(ATerm[] aTerms) {
        return ATermUtils.makeList(aTerms, 0);
    }

    private static ATermList makeList(ATerm[] aTerms, int index) {
        if (index >= aTerms.length) {
            return EMPTY_LIST;
        }
        if (index == aTerms.length - 1) {
            return ATermUtils.makeList(aTerms[index]);
        }
        return ATermUtils.makeList(aTerms[index], ATermUtils.makeList(aTerms, index + 1));
    }

    public static final boolean member(ATerm a, ATermList list) {
        return list.indexOf(a, 0) != -1;
    }

    public static boolean isSet(ATermList list) {
        if (list.isEmpty()) {
            return true;
        }
        ATerm curr = list.getFirst();
        list = list.getNext();
        while (!list.isEmpty()) {
            ATerm next = list.getFirst();
            if (Comparators.hashCodeComparator.compare(curr, next) >= 0) {
                return false;
            }
            curr = next;
            list = list.getNext();
        }
        return true;
    }

    public static ATermList toSet(ATermList list) {
        if (ATermUtils.isSet(list)) {
            return list;
        }
        int size = list.getLength();
        ATermAppl[] a = ATermUtils.toArray(list);
        if (a == null || a.length < size) {
            a = new ATerm[Math.max(100, size)];
        }
        Arrays.sort(a, 0, size, Comparators.hashCodeComparator);
        ATermList set = ATermUtils.makeList((ATerm)a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = set.getFirst();
            if (s.equals(a[i])) continue;
            set = set.insert((ATerm)a[i]);
        }
        return set;
    }

    public static ATermList toSet(ATerm[] a, int size) {
        Arrays.sort(a, 0, size, Comparators.hashCodeComparator);
        ATermList set = ATermUtils.makeList(a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = set.getFirst();
            if (s.equals(a[i])) continue;
            set = set.insert(a[i]);
        }
        return set;
    }

    public static ATermList toSet(Collection<ATermAppl> terms) {
        int size = terms.size();
        ATermAppl[] a = new ATermAppl[size];
        terms.toArray(a);
        return ATermUtils.toSet((ATerm[])a, size);
    }

    public static String toString(ATermAppl term) {
        return ATermUtils.toString(term, true, true);
    }

    public static String toString(ATermAppl term, boolean printLocalName, boolean printNNF) {
        if (term == null) {
            return "<null>";
        }
        StringBuilder sb = new StringBuilder();
        ATermUtils.toString(term, sb, printNNF ? Bool.FALSE : Bool.UNKNOWN, printLocalName);
        return sb.toString();
    }

    private static void toString(ATermAppl term, StringBuilder sb, Bool negated, boolean printLocalName) {
        if (ATermUtils.isVar(term)) {
            String name = ((ATermAppl)term.getArgument(0)).getName();
            if (printLocalName) {
                name = URIUtils.getLocalName(name);
            }
            sb.append("?").append(name);
        } else if (ATermUtils.isLiteral(term)) {
            String value = ((ATermAppl)term.getArgument(0)).toString();
            String lang = ((ATermAppl)term.getArgument(1)).getName();
            ATermAppl datatypeURI = (ATermAppl)term.getArgument(2);
            sb.append('\"').append(value).append('\"');
            if (!lang.equals("")) {
                sb.append('@').append(lang);
            } else if (!datatypeURI.equals(EMPTY)) {
                sb.append("^^");
                ATermUtils.toString(datatypeURI, sb, Bool.FALSE, printLocalName);
            }
        } else if (ATermUtils.isPrimitive(term)) {
            if (negated.isTrue()) {
                sb.append("not(");
            }
            String name = term.getName();
            sb.append(URIUtils.getLocalName(name));
            if (negated.isTrue()) {
                sb.append(")");
            }
        } else if (negated.isKnown() && ATermUtils.isNot(term)) {
            ATermUtils.toString((ATermAppl)term.getArgument(0), sb, negated.not(), printLocalName);
        } else {
            AFun fun = term.getAFun();
            if (negated.isTrue()) {
                if (fun.equals(ANDFUN)) {
                    sb.append(ORFUN.getName());
                } else if (fun.equals(ORFUN)) {
                    sb.append(ANDFUN.getName());
                } else if (fun.equals(SOMEFUN)) {
                    sb.append(ALLFUN.getName());
                } else if (fun.equals(ALLFUN)) {
                    sb.append(SOMEFUN.getName());
                } else if (fun.equals(MINFUN)) {
                    sb.append(MAXFUN.getName());
                } else if (fun.equals(MAXFUN)) {
                    sb.append(MINFUN.getName());
                } else if (!fun.equals(NOTFUN)) {
                    if (fun.equals(VALUEFUN) || fun.equals(RESTRDATATYPEFUN)) {
                        sb.append("not(");
                    }
                    sb.append(fun.getName());
                }
            } else {
                sb.append(fun.getName());
            }
            Bool negatedRecurse = negated;
            if (negated.isKnown() && fun.equals(MINFUN) || fun.equals(MAXFUN)) {
                negatedRecurse = Bool.FALSE;
            } else if (fun.equals(NOTFUN)) {
                negatedRecurse = negated.not();
            }
            sb.append("(");
            int n = term.getArity();
            for (int i = 0; i < n; ++i) {
                ATerm arg;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((arg = term.getArgument(i)) instanceof ATermAppl) {
                    ATermUtils.toString((ATermAppl)arg, sb, i > 0 ? negatedRecurse : Bool.FALSE, printLocalName);
                    continue;
                }
                if (arg instanceof ATermList) {
                    sb.append("[");
                    ATermList list = (ATermList)arg;
                    while (!list.isEmpty()) {
                        ATermUtils.toString((ATermAppl)list.getFirst(), sb, negatedRecurse, printLocalName);
                        if ((list = list.getNext()).isEmpty()) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                    continue;
                }
                int value = ((ATermInt)arg).getInt();
                if (negated.isTrue()) {
                    if (fun.equals(MINFUN)) {
                        --value;
                    } else if (fun.equals(MAXFUN)) {
                        ++value;
                    }
                }
                sb.append(value);
            }
            sb.append(")");
            if ((fun.equals(VALUEFUN) || fun.equals(RESTRDATATYPEFUN)) && negated.isTrue()) {
                sb.append(")");
            }
        }
    }

    public static ATermAppl[] toArray(ATermList list) {
        ATermAppl[] a = new ATermAppl[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            a[i++] = (ATermAppl)list.getFirst();
            list = list.getNext();
        }
        return a;
    }

    public static final void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public static final boolean isPrimitive(ATermAppl c) {
        return c.getArity() == 0;
    }

    public static final boolean isNegatedPrimitive(ATermAppl c) {
        return ATermUtils.isNot(c) && ATermUtils.isPrimitive((ATermAppl)c.getArgument(0));
    }

    public static final boolean isPrimitiveOrNegated(ATermAppl c) {
        return ATermUtils.isPrimitive(c) || ATermUtils.isNegatedPrimitive(c);
    }

    public static final boolean isBnode(ATermAppl name) {
        return name.getAFun().equals(BNODE_FUN);
    }

    public static final boolean isAnon(ATermAppl term) {
        return term.getAFun().equals(ANON_FUN);
    }

    public static Set<ATermAppl> listToSet(ATermList list) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        while (!list.isEmpty()) {
            set.add((ATermAppl)list.getFirst());
            list = list.getNext();
        }
        return set;
    }

    public static Set<ATermAppl> getPrimitives(ATermList list) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (ATermUtils.isPrimitive(term)) {
                set.add(term);
            }
            list = list.getNext();
        }
        return set;
    }

    public static final ATermAppl getTop(Role r) {
        return r.isDatatypeRole() ? TOP_LIT : TOP;
    }

    public static final boolean isTop(ATermAppl a) {
        return a.equals(TOP) || a.equals(TOP_LIT);
    }

    public static final boolean isBottom(ATermAppl a) {
        return a.equals(BOTTOM) || a.equals(BOTTOM_LIT);
    }

    public static final boolean isInv(ATermAppl r) {
        return r.getAFun().equals(INVFUN);
    }

    public static final boolean isAnd(ATermAppl a) {
        return a.getAFun().equals(ANDFUN);
    }

    public static final boolean isOr(ATermAppl a) {
        return a.getAFun().equals(ORFUN);
    }

    public static final boolean isAllValues(ATermAppl a) {
        return a.getAFun().equals(ALLFUN);
    }

    public static final boolean isSomeValues(ATermAppl a) {
        return a.getAFun().equals(SOMEFUN);
    }

    public static final boolean isSelf(ATermAppl a) {
        return a.getAFun().equals(SELFFUN);
    }

    public static final boolean isHasValue(ATermAppl a) {
        return a.getAFun().equals(SOMEFUN) && ((ATermAppl)a.getArgument(1)).getAFun().equals(VALUEFUN);
    }

    public static final boolean isNominal(ATermAppl a) {
        return a.getAFun().equals(VALUEFUN);
    }

    public static final boolean isOneOf(ATermAppl a) {
        if (!a.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            if (!ATermUtils.isNominal((ATermAppl)list.getFirst())) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isDataRange(ATermAppl a) {
        if (!a.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (!ATermUtils.isNominal(term) || !ATermUtils.isLiteral((ATermAppl)term.getArgument(0))) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isNot(ATermAppl a) {
        return a.getAFun().equals(NOTFUN);
    }

    public static final boolean isMax(ATermAppl a) {
        return a.getAFun().equals(MAXFUN);
    }

    public static final boolean isMin(ATermAppl a) {
        return a.getAFun().equals(MINFUN);
    }

    public static final boolean isCard(ATermAppl a) {
        if (ATermUtils.isMin(a) || ATermUtils.isMax(a)) {
            return true;
        }
        if (ATermUtils.isAnd(a)) {
            return ATermUtils.isMin(a = (ATermAppl)a.getArgument(0)) || ATermUtils.isMax(a);
        }
        return false;
    }

    public static final boolean isLiteral(ATermAppl a) {
        return a.getAFun().equals(LITFUN);
    }

    public static final boolean isVar(ATermAppl a) {
        return a.getAFun().equals(VARFUN);
    }

    public static final boolean isTransitiveChain(ATermList chain, ATerm r) {
        return chain.getLength() == 2 && chain.getFirst().equals(r) && chain.getLast().equals(r);
    }

    public static boolean isComplexClass(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            AFun f = a.getAFun();
            return CLASS_FUN.contains(f);
        }
        return false;
    }

    public static final boolean isPropertyAssertion(ATermAppl a) {
        return a.getAFun().equals(PROPFUN);
    }

    public static final boolean isTypeAssertion(ATermAppl a) {
        return a.getAFun().equals(TYPEFUN);
    }

    public static ATerm nnf(ATerm term) {
        if (term instanceof ATermList) {
            return ATermUtils.nnf((ATermList)term);
        }
        if (term instanceof ATermAppl) {
            return ATermUtils.nnf((ATermAppl)term);
        }
        return null;
    }

    public static ATermList nnf(ATermList list) {
        ATermList newList = factory.makeList();
        while (!list.isEmpty()) {
            newList = newList.append((ATerm)ATermUtils.nnf((ATermAppl)list.getFirst()));
            list = list.getNext();
        }
        return newList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ATermAppl nnf(ATermAppl term) {
        ATermAppl newterm = null;
        AFun af = term.getAFun();
        if (af.equals(NOTFUN)) {
            ATermUtils.assertTrue(af.getArity() == 1);
            ATermAppl arg = (ATermAppl)term.getArgument(0);
            af = arg.getAFun();
            if (arg.getArity() == 0) {
                newterm = term;
            } else if (af.equals(NOTFUN)) {
                newterm = ATermUtils.nnf((ATermAppl)arg.getArgument(0));
            } else if (af.equals(VALUEFUN) || af.equals(SELFFUN)) {
                newterm = term;
            } else if (af.equals(MAXFUN)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = ATermUtils.makeMin(arg.getArgument(0), n.getInt() + 1, ATermUtils.nnf(arg.getArgument(2)));
            } else if (af.equals(MINFUN)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = n.getInt() == 0 ? BOTTOM : ATermUtils.makeMax(arg.getArgument(0), n.getInt() - 1, ATermUtils.nnf(arg.getArgument(2)));
            } else if (af.equals(CARDFUN)) {
                newterm = ATermUtils.nnf(ATermUtils.makeNot((ATerm)ATermUtils.makeExactCard(arg.getArgument(0), (ATermInt)arg.getArgument(1), arg.getArgument(2))));
            } else if (af.equals(ANDFUN)) {
                newterm = ATermUtils.makeOr(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
            } else if (af.equals(ORFUN)) {
                newterm = ATermUtils.makeAnd(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
            } else if (af.equals(SOMEFUN)) {
                ATerm p = arg.getArgument(0);
                ATerm c = arg.getArgument(1);
                newterm = ATermUtils.makeAllValues(p, (ATerm)ATermUtils.nnf(ATermUtils.makeNot(c)));
            } else {
                if (!af.equals(ALLFUN)) throw new InternalReasonerException("Unknown term type: " + term);
                ATerm p = arg.getArgument(0);
                ATerm c = arg.getArgument(1);
                newterm = ATermUtils.makeSomeValues(p, (ATerm)ATermUtils.nnf(ATermUtils.makeNot(c)));
            }
        } else if (af.equals(MINFUN) || af.equals(MAXFUN) || af.equals(SELFFUN)) {
            newterm = term;
        } else if (af.equals(CARDFUN)) {
            newterm = ATermUtils.nnf(ATermUtils.makeExactCard(term.getArgument(0), (ATermInt)term.getArgument(1), term.getArgument(2)));
        } else {
            ATerm[] args = new ATerm[term.getArity()];
            for (int i = 0; i < term.getArity(); ++i) {
                args[i] = ATermUtils.nnf(term.getArgument(i));
            }
            newterm = factory.makeAppl(af, args);
        }
        ATermUtils.assertTrue(newterm != null);
        return newterm;
    }

    public static Collection<ATermAppl> normalize(Collection<ATermAppl> terms) {
        ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
        for (ATermAppl term : terms) {
            list.add(ATermUtils.normalize(term));
        }
        return list;
    }

    public static ATermList normalize(ATermList list) {
        int size = list.getLength();
        ATerm[] terms = new ATerm[size];
        for (int i = 0; i < size; ++i) {
            terms[i] = ATermUtils.normalize((ATermAppl)list.getFirst());
            list = list.getNext();
        }
        ATermList set = ATermUtils.toSet(terms, size);
        return set;
    }

    public static ATermAppl normalize(ATermAppl term) {
        ATerm arg3;
        ATermAppl norm = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        ATerm aTerm = arg3 = term.getArity() > 2 ? term.getArgument(2) : null;
        if (!(arg1 == null || fun.equals(SELFFUN) || fun.equals(VALUEFUN) || fun.equals(INVFUN) || fun.equals(RESTRDATATYPEFUN))) {
            if (fun.equals(NOTFUN)) {
                if (!ATermUtils.isPrimitive((ATermAppl)arg1)) {
                    norm = ATermUtils.simplify(ATermUtils.makeNot((ATerm)ATermUtils.normalize((ATermAppl)arg1)));
                }
            } else if (fun.equals(ANDFUN)) {
                norm = ATermUtils.simplify(ATermUtils.makeAnd(ATermUtils.normalize((ATermList)arg1)));
            } else if (fun.equals(ORFUN)) {
                ATermList neg = ATermUtils.negate((ATermList)arg1);
                ATermAppl and = ATermUtils.makeAnd(neg);
                ATermAppl notAnd = ATermUtils.makeNot((ATerm)and);
                norm = ATermUtils.normalize(notAnd);
            } else if (fun.equals(ALLFUN)) {
                norm = ATermUtils.simplify(ATermUtils.makeAllValues(arg1, (ATerm)ATermUtils.normalize((ATermAppl)arg2)));
            } else if (fun.equals(SOMEFUN)) {
                norm = ATermUtils.normalize(ATermUtils.makeNot((ATerm)ATermUtils.makeAllValues(arg1, (ATerm)ATermUtils.makeNot(arg2))));
            } else if (fun.equals(MAXFUN)) {
                norm = ATermUtils.normalize(ATermUtils.makeNot((ATerm)ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt() + 1, arg3)));
            } else if (fun.equals(MINFUN)) {
                norm = ATermUtils.simplify(ATermUtils.makeMin(arg1, (ATermInt)arg2, (ATerm)ATermUtils.normalize((ATermAppl)arg3)));
            } else if (fun.equals(CARDFUN)) {
                ATermAppl normMin = ATermUtils.simplify(ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt(), (ATerm)ATermUtils.normalize((ATermAppl)arg3)));
                ATermAppl normMax = ATermUtils.normalize(ATermUtils.makeMax(arg1, ((ATermInt)arg2).getInt(), arg3));
                norm = ATermUtils.simplify(ATermUtils.makeAnd((ATerm)normMin, (ATerm)normMax));
            } else {
                throw new InternalReasonerException("Unknown concept type: " + term);
            }
        }
        return norm;
    }

    public static ATermAppl simplify(ATermAppl term) {
        ATerm arg3;
        ATermAppl simp = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        ATerm aTerm = arg3 = term.getArity() > 2 ? term.getArgument(2) : null;
        if (arg1 != null && !fun.equals(SELFFUN) && !fun.equals(VALUEFUN)) {
            if (fun.equals(NOTFUN)) {
                ATermInt n;
                ATermAppl arg = (ATermAppl)arg1;
                if (ATermUtils.isNot(arg)) {
                    simp = ATermUtils.simplify((ATermAppl)arg.getArgument(0));
                } else if (ATermUtils.isMin(arg) && (n = (ATermInt)arg.getArgument(1)).getInt() == 0) {
                    simp = BOTTOM;
                }
            } else if (fun.equals(ANDFUN)) {
                ATermList conjuncts = (ATermList)arg1;
                if (conjuncts.isEmpty()) {
                    simp = TOP;
                } else {
                    HashSet<ATermAppl> set = new HashSet<ATermAppl>();
                    ArrayList<ATermAppl> negations = new ArrayList<ATermAppl>();
                    MultiListIterator i = new MultiListIterator(conjuncts);
                    while (i.hasNext()) {
                        ATermAppl c = i.next();
                        if (c.equals(TOP)) continue;
                        if (c.equals(BOTTOM)) {
                            return BOTTOM;
                        }
                        if (ATermUtils.isAnd(c)) {
                            i.append((ATermList)c.getArgument(0));
                            continue;
                        }
                        if (ATermUtils.isNot(c)) {
                            negations.add(c);
                            continue;
                        }
                        set.add(c);
                    }
                    for (ATermAppl notC : negations) {
                        ATermAppl c = (ATermAppl)notC.getArgument(0);
                        if (!set.contains(c)) continue;
                        return BOTTOM;
                    }
                    if (set.isEmpty()) {
                        if (negations.isEmpty()) {
                            return TOP;
                        }
                        if (negations.size() == 1) {
                            return (ATermAppl)negations.get(0);
                        }
                    } else if (set.size() == 1 && negations.isEmpty()) {
                        return (ATermAppl)set.iterator().next();
                    }
                    negations.addAll(set);
                    int size = negations.size();
                    ATermAppl[] terms = new ATermAppl[size];
                    negations.toArray(terms);
                    simp = ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])terms, size));
                }
            } else if (fun.equals(ALLFUN)) {
                if (arg2.equals(TOP)) {
                    simp = TOP;
                }
            } else if (fun.equals(MINFUN)) {
                ATermInt n = (ATermInt)arg2;
                if (n.getInt() == 0) {
                    simp = TOP;
                }
                if (arg3.equals(BOTTOM)) {
                    simp = BOTTOM;
                }
            } else if (fun.equals(MAXFUN)) {
                ATermInt n = (ATermInt)arg2;
                if (n.getInt() > 0 && arg3.equals(BOTTOM)) {
                    simp = TOP;
                }
            } else {
                throw new InternalReasonerException("Unknown term type: " + term);
            }
        }
        return simp;
    }

    public static ATermAppl makeSimplifiedAnd(Collection<ATermAppl> conjuncts) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> negations = new ArrayList<ATermAppl>();
        MultiListIterator listIt = new MultiListIterator(EMPTY_LIST);
        PairIterator<ATermAppl> i = new PairIterator<ATermAppl>(conjuncts.iterator(), listIt);
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (c.equals(TOP)) continue;
            if (c.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (ATermUtils.isAnd(c)) {
                listIt.append((ATermList)c.getArgument(0));
                continue;
            }
            if (ATermUtils.isNot(c)) {
                negations.add(c);
                continue;
            }
            set.add(c);
        }
        for (ATermAppl notC : negations) {
            ATermAppl c = (ATermAppl)notC.getArgument(0);
            if (!set.contains(c)) continue;
            return BOTTOM;
        }
        if (set.isEmpty()) {
            if (negations.isEmpty()) {
                return TOP;
            }
            if (negations.size() == 1) {
                return (ATermAppl)negations.get(0);
            }
        } else if (set.size() == 1 && negations.isEmpty()) {
            return (ATermAppl)set.iterator().next();
        }
        negations.addAll(set);
        int size = negations.size();
        ATermAppl[] terms = new ATermAppl[size];
        negations.toArray(terms);
        return ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])terms, size));
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl term) {
        HashSet<ATermAppl> primitives = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(term, primitives, false, false);
        return primitives;
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl term, boolean skipRestrictions, boolean skipTopLevel) {
        HashSet<ATermAppl> primitives = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(term, primitives, skipRestrictions, skipTopLevel);
        return primitives;
    }

    public static void findPrimitives(ATermAppl term, Set<ATermAppl> primitives) {
        ATermUtils.findPrimitives(term, primitives, false, false);
    }

    public static void findPrimitives(ATermAppl term, Set<ATermAppl> primitives, boolean skipRestrictions, boolean skipTopLevel) {
        AFun fun = term.getAFun();
        if (ATermUtils.isPrimitive(term)) {
            primitives.add(term);
        } else if (!(fun.equals(SELFFUN) || fun.equals(VALUEFUN) || fun.equals(RESTRDATATYPEFUN))) {
            if (fun.equals(NOTFUN)) {
                ATermAppl arg = (ATermAppl)term.getArgument(0);
                if (!ATermUtils.isPrimitive(arg) || !skipTopLevel) {
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                }
            } else if (fun.equals(ANDFUN) || fun.equals(ORFUN)) {
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl arg = (ATermAppl)list.getFirst();
                    if (!ATermUtils.isNegatedPrimitive(arg) || !skipTopLevel) {
                        ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                    }
                    list = list.getNext();
                }
            } else if (!skipRestrictions) {
                if (fun.equals(ALLFUN) || fun.equals(SOMEFUN)) {
                    ATermAppl arg = (ATermAppl)term.getArgument(1);
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                } else if (fun.equals(MAXFUN) || fun.equals(MINFUN) || fun.equals(CARDFUN)) {
                    ATermAppl arg = (ATermAppl)term.getArgument(2);
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                } else {
                    throw new InternalReasonerException("Unknown concept type: " + term);
                }
            }
        }
    }

    public static Collection<ATermAppl> primitiveOrBottom(Collection<ATermAppl> collection) {
        ArrayList<ATermAppl> ret = new ArrayList<ATermAppl>();
        for (ATermAppl a : collection) {
            if (!ATermUtils.isPrimitive(a) && a != BOTTOM) continue;
            ret.add(a);
        }
        return ret;
    }

    public static Set<ATermAppl> primitiveOrBottom(Set<ATermAppl> collection) {
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (ATermAppl a : collection) {
            if (!ATermUtils.isPrimitive(a) && a != BOTTOM) continue;
            ret.add(a);
        }
        return ret;
    }

    public static ATermAppl makeRuleAtom(ATermAppl[] head, ATermAppl[] body) {
        return factory.makeAppl(RULEFUN, (ATerm)ATermUtils.makeList((ATerm[])head), (ATerm)ATermUtils.makeList((ATerm[])body));
    }

    public static ATermAppl makeBuiltinAtom(ATermAppl[] args) {
        return factory.makeAppl(BUILTINFUN, (ATerm)ATermUtils.makeList((ATerm[])args));
    }

    static {
        ANTISYMMETRICFUN = ASYMMETRICFUN = factory.makeAFun("asymmetric", 1, false);
        FUNCTIONALFUN = factory.makeAFun("functional", 1, false);
        INVFUNCTIONALFUN = factory.makeAFun("inverseFunctional", 1, false);
        IRREFLEXIVEFUN = factory.makeAFun("irreflexive", 1, false);
        REFLEXIVEFUN = factory.makeAFun("reflexive", 1, false);
        SYMMETRICFUN = factory.makeAFun("symmetric", 1, false);
        TRANSITIVEFUN = factory.makeAFun("transitive", 1, false);
        SUBPROPFUN = factory.makeAFun("subProperty", 2, false);
        EQPROPFUN = factory.makeAFun("equivalentProperty", 2, false);
        INVPROPFUN = factory.makeAFun("inverseProperty", 2, false);
        DOMAINFUN = factory.makeAFun("domain", 2, false);
        RANGEFUN = factory.makeAFun("range", 2, false);
        RULEFUN = factory.makeAFun("rule", 2, false);
        BUILTINFUN = factory.makeAFun("builtin", 1, false);
        RESTRDATATYPEFUN = factory.makeAFun("restrictedDatatype", 2, false);
        FACET = factory.makeAFun("facet", 2, false);
        EMPTY = ATermUtils.makeTermAppl("");
        EMPTY_LIST = factory.makeList();
        AXIOM_FUN = SetUtils.create(TYPEFUN, PROPFUN, SAMEASFUN, DIFFERENTFUN, ALLDIFFERENTFUN, SUBFUN, EQCLASSFUN, DISJOINTFUN, DISJOINTSFUN, COMPLEMENTFUN, SUBPROPFUN, EQPROPFUN, INVPROPFUN, DOMAINFUN, RANGEFUN, FUNCTIONALFUN, INVFUNCTIONALFUN, TRANSITIVEFUN, SYMMETRICFUN, REFLEXIVEFUN, IRREFLEXIVEFUN, ANTISYMMETRICFUN);
        TOP = ATermUtils.makeTermAppl("_TOP_");
        BOTTOM = ATermUtils.makeNot((ATerm)TOP);
        TOP_LIT = ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal");
        BOTTOM_LIT = ATermUtils.makeNot((ATerm)TOP_LIT);
        CONCEPT_SAT_IND = ATermUtils.makeTermAppl("_C_");
        ONE = factory.makeInt(1);
        qnames = new QNameProvider();
        NO_DATATYPE = ATermUtils.makeTermAppl("NO_DATATYPE");
        BNODE_FUN = factory.makeAFun("bnode", 1, false);
        ANON_FUN = factory.makeAFun("anon", 1, false);
        ANON_NOMINAL_FUN = factory.makeAFun("anon_nominal", 1, false);
        anonCache = new ATermAppl[1000];
        for (int i = 0; i < anonCache.length; ++i) {
            ATermUtils.anonCache[i] = factory.makeAppl(ANON_FUN, (ATerm)factory.makeInt(i));
        }
    }
}

