/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.progress;

import java.io.PrintStream;
import org.mindswap.pellet.utils.progress.AbstractProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

public class ConsoleProgressMonitor
extends AbstractProgressMonitor
implements ProgressMonitor {
    private PrintStream out;

    public ConsoleProgressMonitor() {
        this(System.err);
    }

    public ConsoleProgressMonitor(PrintStream out) {
        this.out = out;
    }

    public ConsoleProgressMonitor(int length) {
        this.setProgressLength(length);
    }

    protected void resetProgress() {
        super.resetProgress();
    }

    public void taskStarted() {
        super.taskStarted();
        this.out.println(this.progressTitle + " " + this.progressLength + " elements");
    }

    protected void updateProgress() {
        int pc = (int)(100.0 * (double)this.progress / (double)this.progressLength);
        if (pc == this.progressPercent) {
            return;
        }
        this.progressPercent = pc;
        this.out.print('\r');
        this.out.print(this.progressTitle);
        this.out.print(": ");
        this.out.print(this.progressMessage);
        this.out.print(" ");
        this.out.print(this.progressPercent);
        this.out.print("% complete in ");
        this.out.print(this.calcElapsedTime());
    }

    public String calcElapsedTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long timeInSeconds = elapsedTime / 1000L;
        long hours = timeInSeconds / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pad(hours));
        buffer.append(':');
        buffer.append(this.pad(minutes));
        buffer.append(':');
        buffer.append(this.pad(seconds));
        return buffer.toString();
    }

    private String pad(long value) {
        String str = value < 10L ? "0" : "";
        return str + value;
    }

    public void taskFinished() {
        this.setProgress(this.progressLength);
        this.out.println();
        this.out.print(this.progressTitle);
        this.out.print(" finished in ");
        this.out.println(this.calcElapsedTime());
    }
}

