/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.Indexer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import owlsmx.Indexer.Index;
import owlsmx.io.ErrorLog;
import owlsmx.stemmer.PorterStemmer;
import owlsmx.tokenizer.PrimitiveConceptTokenizer;

public class SimpleIndex
implements Index,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final short PURE_IDF = 1;
    public static final short LOGARITHMIC_IDF = 2;
    private Set seenClasses = new TreeSet();
    private Map DocumentFrequency = new HashMap();
    public int collection_frequency_component = 2;
    PrimitiveConceptTokenizer tokenizer = new PrimitiveConceptTokenizer();
    private static SimpleIndex index = new SimpleIndex();

    public static SimpleIndex instanceOf() {
        return index;
    }

    private SimpleIndex() {
    }

    public boolean existsDocument(String document) {
        return this.seenClasses.contains(document);
    }

    public boolean existsTerm(String term) {
        if (!this.DocumentFrequency.containsKey(term)) {
            return false;
        }
        if ((Integer)this.DocumentFrequency.get(term) <= 0) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|existsTerm: " + term + " - " + (Integer)this.DocumentFrequency.get(term));
            return false;
        }
        return true;
    }

    private void incrementDocument(String term, int count) {
        if (term.indexOf("http") >= 0 || term.indexOf("file") >= 0) {
            return;
        }
        if (this.DocumentFrequency.containsKey(term = this.prepareTerm(term))) {
            this.DocumentFrequency.put(term, new Integer((Integer)this.DocumentFrequency.get(term) + count));
        } else {
            this.DocumentFrequency.put(term, new Integer(count));
        }
    }

    public void addDocument(String document, Map termFrequencies) {
        if (this.existsDocument(document)) {
            return;
        }
        this.seenClasses.add(document);
        Iterator iter = termFrequencies.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            this.incrementDocument((String)me.getKey(), (Integer)me.getValue());
        }
    }

    public double getIDF(String term) {
        String prepared = this.prepareTerm(term);
        double idf = this.getIDF(prepared, this.collection_frequency_component);
        if (!this.existsTerm(prepared)) {
            ErrorLog.instanceOf().report("getIDF: stemmed term not in index " + prepared);
            ErrorLog.instanceOf().report("        Classes: " + this.seenClasses.size());
            if (!this.existsTerm(term)) {
                ErrorLog.instanceOf().report("        term not in index " + term);
            } else {
                ErrorLog.instanceOf().report("    but term exists in index " + term);
            }
            ErrorLog.instanceOf().report("        idf: " + idf);
        }
        return idf;
    }

    public void addDocument(String document, Set terms) {
        if (this.existsDocument(document)) {
            return;
        }
        this.seenClasses.add(document);
        Iterator iter = terms.iterator();
        while (iter.hasNext()) {
            this.incrementDocument((String)iter.next(), 1);
        }
    }

    private String prepareTerm(String term) {
        term = PorterStemmer.instanceOf().stem(term.toLowerCase());
        return term;
    }

    public double getIDF(String term, int type) {
        double result = 1.0;
        if (this.existsTerm(term) && type == 1) {
            result = 1.0 / (double)((Integer)this.DocumentFrequency.get(term)).intValue();
        } else if (this.existsTerm(term) && type == 2) {
            result = 1.0 + Math.log((double)this.seenClasses.size() / (double)((Integer)this.DocumentFrequency.get(term)).intValue());
        }
        return result;
    }

    public void addDocument(String document, String terms) {
        this.tokenizer.setString(terms);
        this.addDocument(document, this.tokenizer.getTokenFrequencies());
        this.tokenizer.clear();
    }

    public void clear() {
        this.seenClasses.clear();
        this.DocumentFrequency.clear();
        this.tokenizer.clear();
    }
}

